/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.cartesian;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.jupiter.cartesian.CartesianParameterArgumentsProvider;
import org.junitpioneer.jupiter.cartesian.CartesianTest;

class CartesianEnumArgumentsProvider<E extends Enum<E>>
implements CartesianParameterArgumentsProvider<E> {
    CartesianEnumArgumentsProvider() {
    }

    @Override
    public Stream<E> provideArguments(ExtensionContext context, Parameter parameter) {
        Class<?> parameterType = parameter.getType();
        if (!Enum.class.isAssignableFrom(parameterType)) {
            throw new PreconditionViolationException(String.format("Parameter of type %s must reference an Enum type", parameterType));
        }
        CartesianTest.Enum enumSource = (CartesianTest.Enum)AnnotationSupport.findAnnotation((AnnotatedElement)parameter, CartesianTest.Enum.class).orElseThrow(() -> new PreconditionViolationException("Parameter has to be annotated with " + CartesianTest.Enum.class.getName()));
        Set<Enum> constants = this.getEnumConstants(enumSource, parameterType);
        CartesianTest.Enum.Mode mode = enumSource.mode();
        String[] declaredConstantNames = enumSource.names();
        if (declaredConstantNames.length > 0) {
            Set<String> uniqueNames = Arrays.stream(declaredConstantNames).collect(Collectors.toSet());
            if (uniqueNames.size() != declaredConstantNames.length) {
                throw new PreconditionViolationException("Duplicate enum constant name(s) found in " + enumSource);
            }
            mode.validate(enumSource, constants, uniqueNames);
            constants.removeIf(constant -> !mode.select((Enum<?>)constant, uniqueNames));
        }
        return constants.stream();
    }

    private Set<E> getEnumConstants(CartesianTest.Enum enumSource, Class<?> parameterType) {
        Class<E> enumClass = this.determineEnumClass(enumSource, parameterType);
        return EnumSet.allOf(enumClass);
    }

    private Class<E> determineEnumClass(CartesianTest.Enum enumSource, Class<?> parameterType) {
        Class<Enum> enumClass = enumSource.value();
        if (enumClass.equals(NullEnum.class)) {
            enumClass = parameterType;
        }
        return enumClass;
    }

    static enum NullEnum {

    }
}

