/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter.cartesian;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArgumentSets {
    private final List<List<?>> argumentSets = new ArrayList();

    private ArgumentSets() {
    }

    private ArgumentSets(Collection<?> arguments) {
        this();
        this.add(arguments);
    }

    private ArgumentSets add(Collection<?> arguments) {
        this.argumentSets.add(new ArrayList(arguments));
        return this;
    }

    public static ArgumentSets create() {
        return new ArgumentSets();
    }

    public static <T> ArgumentSets argumentsForFirstParameter(Collection<T> arguments) {
        return new ArgumentSets(arguments);
    }

    @SafeVarargs
    public static <T> ArgumentSets argumentsForFirstParameter(T ... arguments) {
        return new ArgumentSets(Arrays.asList(arguments));
    }

    public static <T> ArgumentSets argumentsForFirstParameter(Stream<T> arguments) {
        return new ArgumentSets(arguments.collect(Collectors.toList()));
    }

    public final <T> ArgumentSets argumentsForNextParameter(Collection<T> arguments) {
        return this.add(arguments);
    }

    @SafeVarargs
    public final <T> ArgumentSets argumentsForNextParameter(T ... arguments) {
        return this.add(Arrays.asList(arguments));
    }

    public final <T> ArgumentSets argumentsForNextParameter(Stream<T> arguments) {
        return this.add(arguments.collect(Collectors.toList()));
    }

    List<List<?>> getArguments() {
        return this.argumentSets;
    }
}

