/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.time.Clock;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

class StopwatchExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private final Clock clock = Clock.systemUTC();
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{StopwatchExtension.class});
    static final String STORE_KEY = "StopwatchExtension";

    StopwatchExtension() {
    }

    public void beforeTestExecution(ExtensionContext context) {
        this.storeNowAsLaunchTime(context);
    }

    public void afterTestExecution(ExtensionContext context) {
        this.calculateAndReportElapsedTime(context);
    }

    void storeNowAsLaunchTime(ExtensionContext context) {
        context.getStore(NAMESPACE).put((Object)context.getUniqueId(), (Object)this.clock.instant().toEpochMilli());
    }

    long loadLaunchTime(ExtensionContext context) {
        return (Long)context.getStore(NAMESPACE).get((Object)context.getUniqueId(), Long.TYPE);
    }

    void calculateAndReportElapsedTime(ExtensionContext context) {
        long launchTime = this.loadLaunchTime(context);
        long elapsedTime = this.clock.instant().toEpochMilli() - launchTime;
        String message = String.format("Execution of '%s' took [%d] ms.", context.getDisplayName(), elapsedTime);
        context.publishReportEntry(STORE_KEY, message);
    }
}

