/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.io.InputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.jupiter.StdIn;
import org.junitpioneer.jupiter.StdIo;
import org.junitpioneer.jupiter.StdOut;

class StdIoExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    static final String SEPARATOR = System.getProperty("line.separator");
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{StdIoExtension.class});
    private static final String SYSTEM_IN_KEY = "StdIo_System_In";
    private static final String SYSTEM_OUT_KEY = "StdIo_System_Out";
    private static final String STD_IN_KEY = "StdIo_Std_In";

    StdIoExtension() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        return type == StdIn.class || type == StdOut.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType == StdOut.class) {
            return this.prepareStdOut(extensionContext);
        }
        if (parameterType == StdIn.class) {
            String[] source = extensionContext.getRequiredTestMethod().getAnnotation(StdIo.class).value();
            if (source.length == 0) {
                throw new ExtensionConfigurationException("@StdIo defined no input, so System.in is still in place and no StdIn parameter can be provided. If you want to define empty input, use `@StdIo(\"\")`.");
            }
            return extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)STD_IN_KEY, __ -> this.createSwapStoreStdIn(extensionContext, source), StdIn.class);
        }
        throw new ParameterResolutionException(String.format("Could not resolve parameter of type %s.", parameterType));
    }

    private StdOut prepareStdOut(ExtensionContext context) {
        this.storeStdOut(context);
        return this.createOut();
    }

    private void storeStdOut(ExtensionContext context) {
        context.getStore(NAMESPACE).put((Object)SYSTEM_OUT_KEY, (Object)System.out);
    }

    private StdOut createOut() {
        StdOut out = new StdOut();
        System.setOut(new PrintStream(out));
        return out;
    }

    private StdIn createSwapStoreStdIn(ExtensionContext context, String[] source) {
        StdIn newStdIn = new StdIn(source);
        this.swapAndStoreIn(context, newStdIn);
        return newStdIn;
    }

    private void swapAndStoreIn(ExtensionContext context, StdIn stdIn) {
        context.getStore(NAMESPACE).put((Object)SYSTEM_IN_KEY, (Object)System.in);
        context.getStore(NAMESPACE).put((Object)STD_IN_KEY, (Object)stdIn);
        System.setIn(stdIn);
    }

    public void beforeEach(ExtensionContext context) {
        boolean stdInStillInPlace;
        boolean testMethodIsParameterless;
        String[] source = PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, StdIo.class).orElseThrow(() -> new ExtensionConfigurationException(String.format("StdIoExtension is active but no %s annotation was found.", StdIo.class.getName()))).value();
        boolean bl = testMethodIsParameterless = context.getRequiredTestMethod().getParameterCount() == 0;
        if (source.length == 0 && testMethodIsParameterless) {
            throw new ExtensionConfigurationException("StdIoExtension is active but neither System.out or System.in are getting redirected.");
        }
        boolean bl2 = stdInStillInPlace = context.getStore(NAMESPACE).get((Object)STD_IN_KEY) == null;
        if (source.length > 0 && stdInStillInPlace) {
            this.createSwapStoreStdIn(context, source);
        }
    }

    public void afterEach(ExtensionContext context) {
        PrintStream storedSystemOut;
        InputStream storedSystemIn = (InputStream)context.getStore(NAMESPACE).get((Object)SYSTEM_IN_KEY, InputStream.class);
        if (storedSystemIn != null) {
            System.setIn(storedSystemIn);
        }
        if ((storedSystemOut = (PrintStream)context.getStore(NAMESPACE).get((Object)SYSTEM_OUT_KEY, PrintStream.class)) != null) {
            System.setOut(storedSystemOut);
        }
    }
}

