/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.internal.TestNameFormatter;
import org.junitpioneer.jupiter.RetryingTest;
import org.junitpioneer.jupiter.RetryingTestInvocationContext;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

class RetryingTestExtension
implements TestTemplateInvocationContextProvider,
TestExecutionExceptionHandler {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{RetryingTestExtension.class});

    RetryingTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return PioneerAnnotationUtils.isAnyAnnotationPresent(context, RetryingTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        FailedTestRetrier retrier = RetryingTestExtension.retrierFor(context);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(retrier, 16), false);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        ExtensionContext templateContext = (ExtensionContext)context.getParent().orElseThrow(() -> new IllegalStateException("Extension context \"" + context + "\" should have a parent context."));
        RetryingTestExtension.retrierFor(templateContext).failed(throwable);
    }

    private static FailedTestRetrier retrierFor(ExtensionContext context) {
        Method test = context.getRequiredTestMethod();
        return (FailedTestRetrier)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)test.toString(), __ -> FailedTestRetrier.createFor(test, context), FailedTestRetrier.class);
    }

    private static class FailedTestRetrier
    implements Iterator<RetryingTestInvocationContext> {
        private final int maxRetries;
        private final int minSuccess;
        private final Class<? extends Throwable>[] expectedExceptions;
        private final TestNameFormatter formatter;
        private int retriesSoFar;
        private int exceptionsSoFar;
        private boolean seenFailedAssumption;
        private boolean seenUnexpectedException;

        private FailedTestRetrier(int maxRetries, int minSuccess, Class<? extends Throwable>[] expectedExceptions, TestNameFormatter formatter) {
            this.maxRetries = maxRetries;
            this.minSuccess = minSuccess;
            this.expectedExceptions = expectedExceptions;
            this.retriesSoFar = 0;
            this.exceptionsSoFar = 0;
            this.formatter = formatter;
        }

        static FailedTestRetrier createFor(Method test, ExtensionContext context) {
            RetryingTest retryingTest = (RetryingTest)AnnotationSupport.findAnnotation((AnnotatedElement)test, RetryingTest.class).orElseThrow(() -> new IllegalStateException("@RetryingTest is missing."));
            int maxAttempts = retryingTest.maxAttempts() != 0 ? retryingTest.maxAttempts() : retryingTest.value();
            int minSuccess = retryingTest.minSuccess();
            String pattern = retryingTest.name();
            if (maxAttempts == 0) {
                throw new IllegalStateException("@RetryingTest requires that one of `value` or `maxAttempts` be set.");
            }
            if (retryingTest.value() != 0 && retryingTest.maxAttempts() != 0) {
                throw new IllegalStateException("@RetryingTest requires that one of `value` or `maxAttempts` be set, but not both.");
            }
            if (minSuccess < 1) {
                throw new IllegalStateException("@RetryingTest requires that `minSuccess` be greater than or equal to 1.");
            }
            if (maxAttempts <= minSuccess) {
                String additionalMessage = maxAttempts == minSuccess ? " Using @RepeatedTest is recommended as a replacement." : "";
                throw new IllegalStateException(String.format("@RetryingTest requires that `maxAttempts` be greater than %s.%s", minSuccess == 1 ? "1" : "`minSuccess`", additionalMessage));
            }
            if (pattern.isEmpty()) {
                throw new ExtensionConfigurationException("RetryingTest can not have an empty display name.");
            }
            String displayName = context.getDisplayName();
            TestNameFormatter formatter = new TestNameFormatter(pattern, displayName, RetryingTest.class);
            return new FailedTestRetrier(maxAttempts, minSuccess, retryingTest.onExceptions(), formatter);
        }

        void failed(Throwable exception) throws Throwable {
            ++this.exceptionsSoFar;
            if (exception instanceof TestAbortedException) {
                this.seenFailedAssumption = true;
                throw new TestAbortedException("Test execution was skipped, possibly because of a failed assumption.", exception);
            }
            if (!this.expectedException(exception)) {
                this.seenUnexpectedException = true;
                throw exception;
            }
            if (this.hasNext()) {
                throw new TestAbortedException(String.format("Test execution #%d (of up to %d) failed ~> will retry...", this.retriesSoFar, this.maxRetries), exception);
            }
            throw new AssertionFailedError(String.format("Test execution #%d (of up to %d with at least %d successes) failed ~> test fails - see cause for details", this.retriesSoFar, this.maxRetries, this.minSuccess), exception);
        }

        private boolean expectedException(Throwable exception) {
            if (this.expectedExceptions.length == 0) {
                return true;
            }
            return Arrays.stream(this.expectedExceptions).anyMatch(type -> type.isInstance(exception));
        }

        @Override
        public boolean hasNext() {
            if (this.retriesSoFar == 0) {
                return true;
            }
            if (this.seenFailedAssumption || this.seenUnexpectedException) {
                return false;
            }
            int remainingExecutionCount = this.maxRetries - this.retriesSoFar;
            int successfulExecutionCount = this.retriesSoFar - this.exceptionsSoFar;
            int requiredSuccessCount = this.minSuccess - successfulExecutionCount;
            return remainingExecutionCount >= requiredSuccessCount && requiredSuccessCount > 0;
        }

        @Override
        public RetryingTestInvocationContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.retriesSoFar;
            return new RetryingTestInvocationContext(this.formatter);
        }
    }
}

