/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.internal.PioneerUtils;
import org.junitpioneer.jupiter.ReportEntry;

class ReportEntryExtension
implements TestWatcher,
BeforeEachCallback,
InvocationInterceptor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ReportEntryExtension.class});
    private static final String KEY = "ReportEntry";

    ReportEntryExtension() {
    }

    public void beforeEach(ExtensionContext context) {
        this.findAnnotations(context).forEach(entry -> ReportEntryExtension.verifyReportEntry(context, entry));
    }

    private Stream<ReportEntry> findAnnotations(ExtensionContext context) {
        return PioneerAnnotationUtils.findAllEnclosingRepeatableAnnotations(context, ReportEntry.class);
    }

    private static void verifyReportEntry(ExtensionContext context, ReportEntry entry) {
        ReportEntryExtension.verifyParameterCount(context, entry);
        ReportEntryExtension.verifyKeyValueAreNotBlank(entry);
        ReportEntryExtension.verifyKeyNotParameterized(entry);
    }

    private static void verifyParameterCount(ExtensionContext context, ReportEntry entry) {
        if (ReportEntryExtension.hasTestParameterVariables(entry.value())) {
            int highest = ReportEntryExtension.getHighestNumberedParameter(entry);
            if (context.getRequiredTestMethod().getParameterCount() <= highest) {
                String message = "Report entry contains unresolved variable(s): { key=\"%s\" value=\"%s\" }";
                throw new ExtensionConfigurationException(String.format(message, entry.key(), entry.value()));
            }
        }
    }

    private static int getHighestNumberedParameter(ReportEntry entry) {
        int highest = 0;
        Matcher matcher = Pattern.compile("\\{[0-9]+}").matcher(entry.value());
        while (matcher.find()) {
            highest = Math.max(ReportEntryExtension.getVariableNumber(entry, matcher), highest);
        }
        return highest;
    }

    private static int getVariableNumber(ReportEntry entry, Matcher matcher) {
        return Integer.parseInt(entry.value().substring(matcher.start() + 1, matcher.end() - 1));
    }

    private static void verifyKeyValueAreNotBlank(ReportEntry entry) {
        if (entry.key().isEmpty() || entry.value().isEmpty()) {
            String message = "Report entries can't have blank key or value: { key=\"%s\", value=\"%s\" }";
            throw new ExtensionConfigurationException(String.format(message, entry.key(), entry.value()));
        }
    }

    private static void verifyKeyNotParameterized(ReportEntry entry) {
        if (ReportEntryExtension.hasTestParameterVariables(entry.key())) {
            String message = "Report entry can not have variables in the key: { key=\"%s\" value=\"%s\" }";
            throw new ExtensionConfigurationException(String.format(message, entry.key(), entry.value()));
        }
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
    }

    public void testSuccessful(ExtensionContext context) {
        this.publishOnConditions(context, ReportEntry.PublishCondition.ALWAYS, ReportEntry.PublishCondition.ON_SUCCESS);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        this.publishOnConditions(context, ReportEntry.PublishCondition.ALWAYS, ReportEntry.PublishCondition.ON_ABORTED);
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        if (!(cause instanceof ExtensionConfigurationException)) {
            this.publishOnConditions(context, ReportEntry.PublishCondition.ALWAYS, ReportEntry.PublishCondition.ON_FAILURE);
        }
    }

    private void publishOnConditions(ExtensionContext context, ReportEntry.PublishCondition ... conditions) {
        this.findAnnotations(context).filter(entry -> Arrays.asList(conditions).contains((Object)entry.when())).forEach(entry -> context.publishReportEntry(entry.key(), this.parseVariables(entry.value(), context)));
    }

    private String parseVariables(String value, ExtensionContext context) {
        if (!ReportEntryExtension.hasTestParameterVariables(value)) {
            return value;
        }
        String parsed = value;
        List list = (List)context.getStore(NAMESPACE).get((Object)KEY, List.class);
        for (int i = 0; i < list.size(); ++i) {
            parsed = parsed.replaceAll("\\{" + i + "}", PioneerUtils.nullSafeToString(list.get(i)));
        }
        return parsed;
    }

    private static boolean hasTestParameterVariables(String value) {
        return value.matches(".*\\{[0-9]+}.*");
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        extensionContext.getStore(NAMESPACE).put((Object)KEY, (Object)invocationContext.getArguments());
        invocation.proceed();
    }
}

