/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.util.Objects;
import org.junit.platform.engine.TestExecutionResult;

public final class IssueTestCase {
    private static final String NO_RESULT_EXCEPTION_MESSAGE = "The test case result should never be null (Nicolai thinks). If you see this exception, he was wrong - please open an issue at https://github.com/junit-pioneer/junit-pioneer/issues/new/choose .";
    private final String testId;
    private final TestExecutionResult.Status result;

    public IssueTestCase(String testId, TestExecutionResult.Status result) {
        this.testId = Objects.requireNonNull(testId);
        this.result = Objects.requireNonNull(result, NO_RESULT_EXCEPTION_MESSAGE);
    }

    public String testId() {
        return this.testId;
    }

    public TestExecutionResult.Status result() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IssueTestCase)) {
            return false;
        }
        IssueTestCase that = (IssueTestCase)o;
        return this.testId.equals(that.testId) && this.result == that.result;
    }

    public int hashCode() {
        return Objects.hash(this.testId, this.result);
    }

    public String toString() {
        return "IssueTestCase{uniqueName='" + this.testId + '\'' + ", result='" + this.result + '\'' + '}';
    }
}

