/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;

class EnvironmentVariableUtils {
    private EnvironmentVariableUtils() {
    }

    public static void set(String name, String value) {
        EnvironmentVariableUtils.modifyEnvironmentVariables(map -> map.put(name, value));
    }

    public static void clear(String name) {
        EnvironmentVariableUtils.modifyEnvironmentVariables(map -> {
            String cfr_ignored_0 = (String)map.remove(name);
        });
    }

    private static void modifyEnvironmentVariables(Consumer<Map<String, String>> consumer) {
        try {
            EnvironmentVariableUtils.setInProcessEnvironmentClass(consumer);
        }
        catch (ReflectiveOperationException ex) {
            EnvironmentVariableUtils.trySystemEnvClass(consumer, ex);
        }
    }

    private static void trySystemEnvClass(Consumer<Map<String, String>> consumer, ReflectiveOperationException processEnvironmentClassEx) {
        try {
            EnvironmentVariableUtils.setInSystemEnvClass(consumer);
        }
        catch (ReflectiveOperationException ex) {
            ex.addSuppressed(processEnvironmentClassEx);
            throw new ExtensionConfigurationException("Could not modify environment variables", (Throwable)ex);
        }
    }

    private static void setInProcessEnvironmentClass(Consumer<Map<String, String>> consumer) throws ReflectiveOperationException {
        Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
        Map<String, String> theEnvironment = EnvironmentVariableUtils.getFieldValue(processEnvironmentClass, null, "theEnvironment");
        Map<String, String> theCaseInsensitiveEnvironment = EnvironmentVariableUtils.getFieldValue(processEnvironmentClass, null, "theCaseInsensitiveEnvironment");
        consumer.accept(theEnvironment);
        consumer.accept(theCaseInsensitiveEnvironment);
    }

    private static void setInSystemEnvClass(Consumer<Map<String, String>> consumer) throws ReflectiveOperationException {
        Map<String, String> env = System.getenv();
        consumer.accept(EnvironmentVariableUtils.getFieldValue(env.getClass(), env, "m"));
    }

    private static Map<String, String> getFieldValue(Class<?> clazz, Object object, String name) throws ReflectiveOperationException {
        Field field = clazz.getDeclaredField(name);
        try {
            field.setAccessible(true);
        }
        catch (RuntimeException ex) {
            if (ex.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                throw new ExtensionConfigurationException("Cannot access Java runtime internals to modify environment variables. Have a look at the documentation for possible solutions: https://junit-pioneer.org/docs/environment-variables/#warnings-for-reflective-access", (Throwable)ex);
            }
            throw ex;
        }
        return (Map)field.get(object);
    }
}

