/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junitpioneer.jupiter.AbstractEntryBasedExtension;
import org.junitpioneer.jupiter.ClearEnvironmentVariable;
import org.junitpioneer.jupiter.EnvironmentVariableUtils;
import org.junitpioneer.jupiter.SetEnvironmentVariable;

class EnvironmentVariableExtension
extends AbstractEntryBasedExtension<String, String, ClearEnvironmentVariable, SetEnvironmentVariable> {
    static final AtomicBoolean REPORTED_WARNING = new AtomicBoolean(false);
    static final String WARNING_KEY = EnvironmentVariableExtension.class.getSimpleName();
    static final String WARNING_VALUE = "This extension uses reflection to mutate JDK-internal state, which is fragile. Check the Javadoc or documentation for more details.";

    EnvironmentVariableExtension() {
    }

    @Override
    protected Function<ClearEnvironmentVariable, String> clearKeyMapper() {
        return ClearEnvironmentVariable::key;
    }

    @Override
    protected Function<SetEnvironmentVariable, String> setKeyMapper() {
        return SetEnvironmentVariable::key;
    }

    @Override
    protected Function<SetEnvironmentVariable, String> setValueMapper() {
        return SetEnvironmentVariable::value;
    }

    @Override
    protected void reportWarning(ExtensionContext context) {
        boolean wasReported = REPORTED_WARNING.getAndSet(true);
        if (wasReported) {
            return;
        }
        context.publishReportEntry(WARNING_KEY, WARNING_VALUE);
        System.out.println(WARNING_KEY + ": " + WARNING_VALUE);
    }

    @Override
    protected void clearEntry(String key) {
        EnvironmentVariableUtils.clear(key);
    }

    @Override
    protected String getEntry(String key) {
        return System.getenv(key);
    }

    @Override
    protected void setEntry(String key, String value) {
        EnvironmentVariableUtils.set(key, value);
    }
}

