/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.jupiter.DisabledUntil;

class DisabledUntilExtension
implements ExecutionCondition {
    private static final DateTimeFormatter ISO_8601 = DateTimeFormatter.ISO_DATE;

    DisabledUntilExtension() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return this.getUntilDateFromAnnotation(context).map(untilDate -> this.evaluateUntilDate(context, (LocalDate)untilDate)).orElse(ConditionEvaluationResult.enabled((String)"No @DisabledUntil annotation found on element"));
    }

    private Optional<LocalDate> getUntilDateFromAnnotation(ExtensionContext context) {
        return PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, DisabledUntil.class).map(DisabledUntil::date).map(this::parseDate);
    }

    private LocalDate parseDate(String dateString) {
        try {
            return LocalDate.parse(dateString, ISO_8601);
        }
        catch (DateTimeParseException ex) {
            throw new ExtensionConfigurationException("The `untilDate` string '" + dateString + "' is no valid ISO-8601 string.", (Throwable)ex);
        }
    }

    private ConditionEvaluationResult evaluateUntilDate(ExtensionContext context, LocalDate untilDate) {
        LocalDate today = LocalDate.now();
        boolean disabled = today.isBefore(untilDate);
        if (disabled) {
            String message = String.format("The `date` %s is after the current date %s", untilDate.format(ISO_8601), today.format(ISO_8601));
            return ConditionEvaluationResult.disabled((String)message);
        }
        String message = String.format("The `date` %s is before or on the current date %s, so `@DisabledUntil` no longer disabled test \"%s\". Please remove the annotation.", untilDate.format(ISO_8601), today.format(ISO_8601), context.getUniqueId());
        context.publishReportEntry(DisabledUntilExtension.class.getSimpleName(), message);
        return ConditionEvaluationResult.enabled((String)message);
    }
}

