/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.jupiter.DisableIfTestFails;
import org.opentest4j.TestAbortedException;

class DisableIfTestFailsExtension
implements TestExecutionExceptionHandler,
ExecutionCondition {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{DisableIfTestFailsExtension.class});
    private static final String DISABLED_KEY = "DISABLED_KEY";
    private static final String DISABLED_VALUE = "";

    DisableIfTestFailsExtension() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        boolean disabled;
        boolean bl = disabled = context.getStore(NAMESPACE).get((Object)DISABLED_KEY) != null;
        if (disabled) {
            return ConditionEvaluationResult.disabled((String)"Another failed with one of the specified exceptions.");
        }
        return ConditionEvaluationResult.enabled((String)"No test failed with one of the specified exceptions (yet).");
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        ExtensionContext testClassContext = (ExtensionContext)context.getParent().orElseThrow(IllegalStateException::new);
        DisableIfTestFailsExtension.findConfigurations(testClassContext).filter(configuration -> configuration.shouldDisable(throwable)).forEach(configuration -> configuration.context().getStore(NAMESPACE).put((Object)DISABLED_KEY, (Object)DISABLED_VALUE));
        throw throwable;
    }

    private static Stream<Configuration> findConfigurations(ExtensionContext context) {
        Optional type = context.getTestClass();
        if (!type.isPresent()) {
            return Stream.empty();
        }
        List<DisableIfTestFails> annotations = DisableIfTestFailsExtension.findAnnotationOn((Class)type.get()).collect(Collectors.toList());
        Stream<Configuration> onClassConfig = DisableIfTestFailsExtension.createConfigurationFor(context, annotations);
        Stream onParentClassConfigs = context.getParent().map(DisableIfTestFailsExtension::findConfigurations).orElse(Stream.empty());
        List stream = Stream.concat(onClassConfig, onParentClassConfigs).collect(Collectors.toList());
        return stream.stream();
    }

    private static Stream<Configuration> createConfigurationFor(ExtensionContext context, List<DisableIfTestFails> annotations) {
        if (annotations.isEmpty()) {
            return Stream.empty();
        }
        Set<Class<? extends Throwable>> onClassExceptions = annotations.stream().map(DisableIfTestFails::with).flatMap(exceptions -> ((Class[])exceptions).length == 0 ? Stream.of(Throwable.class) : Arrays.stream(exceptions)).collect(Collectors.toSet());
        boolean disableOnAssertions = annotations.stream().anyMatch(DisableIfTestFails::onAssertion);
        Configuration onClassConfig = new Configuration(context, onClassExceptions, disableOnAssertions);
        return Stream.of(onClassConfig);
    }

    private static Stream<DisableIfTestFails> findAnnotationOn(Class<?> element) {
        if (element == null || element == Object.class) {
            return Stream.empty();
        }
        Stream onElement = AnnotationSupport.findAnnotation(element, DisableIfTestFails.class).map(Stream::of).orElse(Stream.empty());
        Stream onInterfaces = Arrays.stream(element.getInterfaces()).flatMap(DisableIfTestFailsExtension::findAnnotationOn);
        Stream<DisableIfTestFails> onSuperclass = DisableIfTestFailsExtension.findAnnotationOn(element.getSuperclass());
        return Stream.of(onElement, onInterfaces, onSuperclass).flatMap(s -> s);
    }

    private static class Configuration {
        private final ExtensionContext context;
        private final Set<Class<? extends Throwable>> disableOnExceptions;
        private final boolean disableOnAssertions;

        public Configuration(ExtensionContext context, Set<Class<? extends Throwable>> disableOnExceptions, boolean disableOnAssertions) {
            this.context = context;
            this.disableOnExceptions = disableOnExceptions;
            if (disableOnExceptions.isEmpty()) {
                throw new IllegalArgumentException("List of exceptions to disable on must not be empty.");
            }
            this.disableOnAssertions = disableOnAssertions;
        }

        public boolean shouldDisable(Throwable exception) {
            if (exception instanceof TestAbortedException) {
                return false;
            }
            if (exception instanceof AssertionError) {
                return this.disableOnAssertions;
            }
            return this.disableOnExceptions.stream().anyMatch(type -> type.isInstance(exception));
        }

        public ExtensionContext context() {
            return this.context;
        }
    }
}

