/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.util.TimeZone;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.jupiter.DefaultTimeZone;

class DefaultTimeZoneExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{DefaultTimeZoneExtension.class});
    private static final String KEY = "DefaultTimeZone";

    DefaultTimeZoneExtension() {
    }

    public void beforeEach(ExtensionContext context) {
        PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, DefaultTimeZone.class).ifPresent(annotation -> this.setDefaultTimeZone(context.getStore(NAMESPACE), (DefaultTimeZone)annotation));
    }

    private void setDefaultTimeZone(ExtensionContext.Store store, DefaultTimeZone annotation) {
        TimeZone defaultTimeZone = DefaultTimeZoneExtension.createTimeZone(annotation.value());
        this.storeDefaultTimeZone(store);
        TimeZone.setDefault(defaultTimeZone);
    }

    private static TimeZone createTimeZone(String timeZoneId) {
        TimeZone configuredTimeZone = TimeZone.getTimeZone(timeZoneId);
        if (configuredTimeZone.equals(TimeZone.getTimeZone("GMT")) && !timeZoneId.equals("GMT")) {
            throw new ExtensionConfigurationException(String.format("@DefaultTimeZone not configured correctly. Could not find the specified time zone + '%s'. Please use correct identifiers, e.g. \"GMT\" for Greenwich Mean Time.", timeZoneId));
        }
        return configuredTimeZone;
    }

    private void storeDefaultTimeZone(ExtensionContext.Store store) {
        store.put((Object)KEY, (Object)TimeZone.getDefault());
    }

    public void afterEach(ExtensionContext context) {
        PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, DefaultTimeZone.class).ifPresent(__ -> this.resetDefaultTimeZone(context.getStore(NAMESPACE)));
    }

    private void resetDefaultTimeZone(ExtensionContext.Store store) {
        TimeZone timeZone = (TimeZone)store.get((Object)KEY, TimeZone.class);
        if (timeZone != null) {
            TimeZone.setDefault(timeZone);
        }
    }
}

