/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.util.Locale;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.jupiter.DefaultLocale;

class DefaultLocaleExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{DefaultLocaleExtension.class});
    private static final String KEY = "DefaultLocale";

    DefaultLocaleExtension() {
    }

    public void beforeEach(ExtensionContext context) {
        PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, DefaultLocale.class).ifPresent(annotation -> this.setDefaultLocale(context, (DefaultLocale)annotation));
    }

    private void setDefaultLocale(ExtensionContext context, DefaultLocale annotation) {
        Locale configuredLocale = DefaultLocaleExtension.createLocale(annotation);
        this.storeDefaultLocale(context);
        Locale.setDefault(configuredLocale);
    }

    private void storeDefaultLocale(ExtensionContext context) {
        context.getStore(NAMESPACE).put((Object)KEY, (Object)Locale.getDefault());
    }

    private static Locale createLocale(DefaultLocale annotation) {
        if (!annotation.value().isEmpty()) {
            return DefaultLocaleExtension.createFromLanguageTag(annotation);
        }
        return DefaultLocaleExtension.createFromParts(annotation);
    }

    private static Locale createFromLanguageTag(DefaultLocale annotation) {
        if (!(annotation.language().isEmpty() && annotation.country().isEmpty() && annotation.variant().isEmpty())) {
            throw new ExtensionConfigurationException("@DefaultLocale can only be used with language tag if language, country, and variant are not set");
        }
        return Locale.forLanguageTag(annotation.value());
    }

    private static Locale createFromParts(DefaultLocale annotation) {
        String language = annotation.language();
        String country = annotation.country();
        String variant = annotation.variant();
        if (!(language.isEmpty() || country.isEmpty() || variant.isEmpty())) {
            return new Locale(language, country, variant);
        }
        if (!language.isEmpty() && !country.isEmpty()) {
            return new Locale(language, country);
        }
        if (!language.isEmpty() && variant.isEmpty()) {
            return new Locale(language);
        }
        throw new ExtensionConfigurationException("@DefaultLocale not configured correctly. When not using a language tag, specify eitherlanguage, or language and country, or language and country and variant.");
    }

    public void afterEach(ExtensionContext context) {
        PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, DefaultLocale.class).ifPresent(__ -> this.resetDefaultLocale(context));
    }

    private void resetDefaultLocale(ExtensionContext context) {
        Locale defaultLocale = (Locale)context.getStore(NAMESPACE).get((Object)KEY, Locale.class);
        if (defaultLocale != null) {
            Locale.setDefault(defaultLocale);
        }
    }
}

