/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.internal.PioneerUtils;
import org.junitpioneer.internal.TestNameFormatter;
import org.junitpioneer.jupiter.CartesianAnnotationConsumer;
import org.junitpioneer.jupiter.CartesianProductTest;
import org.junitpioneer.jupiter.CartesianProductTestInvocationContext;

@Deprecated
class CartesianProductTestExtension
implements TestTemplateInvocationContextProvider {
    CartesianProductTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), CartesianProductTest.class).isPresent();
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        List<List<?>> sets = this.computeSets(context);
        TestNameFormatter formatter = this.createNameFormatter(context);
        return PioneerUtils.cartesianProduct(sets).stream().map(params -> new CartesianProductTestInvocationContext((List<?>)params, formatter));
    }

    private TestNameFormatter createNameFormatter(ExtensionContext context) {
        CartesianProductTest annotation = (CartesianProductTest)AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), CartesianProductTest.class).orElseThrow(() -> new ExtensionConfigurationException("@CartesianProductTest not found."));
        String pattern = annotation.name();
        if (pattern.isEmpty()) {
            throw new ExtensionConfigurationException("CartesianProductTest can not have a non-empty display name.");
        }
        String displayName = context.getDisplayName();
        return new TestNameFormatter(pattern, displayName, CartesianProductTest.class);
    }

    private List<List<?>> computeSets(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        CartesianProductTest annotation = (CartesianProductTest)AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, CartesianProductTest.class).orElseThrow(() -> new ExtensionConfigurationException("@CartesianProductTest not found."));
        List<Annotation> argumentsSources = PioneerAnnotationUtils.findAnnotatedAnnotations(testMethod, ArgumentsSource.class);
        CartesianProductTestExtension.ensureNoInputConflicts(annotation, argumentsSources);
        if (annotation.value().length > 0) {
            return this.getSetsFromValue(testMethod, annotation);
        }
        if (!argumentsSources.isEmpty()) {
            return this.getSetsFromArgumentsSources(argumentsSources, context);
        }
        return this.getSetsFromStaticFactory(testMethod, annotation.factory());
    }

    private static void ensureNoInputConflicts(CartesianProductTest annotation, List<? extends Annotation> valueSources) {
        boolean hasValueSources;
        boolean hasValue = annotation.value().length != 0;
        boolean hasFactory = !annotation.factory().isEmpty();
        boolean bl = hasValueSources = !valueSources.isEmpty();
        if (hasValue && hasFactory || hasValue && hasValueSources || hasFactory && hasValueSources) {
            throw new ExtensionConfigurationException("CartesianProductTest can only take exactly one type of arguments source.");
        }
    }

    private List<List<?>> getSetsFromValue(Method testMethod, CartesianProductTest annotation) {
        ArrayList sets = new ArrayList();
        List strings = Arrays.stream(annotation.value()).distinct().collect(Collectors.toList());
        for (int i = 0; i < testMethod.getParameterTypes().length; ++i) {
            sets.add(strings);
        }
        return sets;
    }

    private List<List<?>> getSetsFromArgumentsSources(List<? extends Annotation> argumentsSources, ExtensionContext context) {
        ArrayList sets = new ArrayList();
        for (Annotation annotation : argumentsSources) {
            sets.add(this.getSetFromAnnotation(context, annotation));
        }
        return sets;
    }

    private List<Object> getSetFromAnnotation(ExtensionContext context, Annotation source) {
        try {
            ArgumentsProvider provider = this.initializeArgumentsProvider(source);
            return this.provideArguments(context, source, provider);
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Could not provide arguments because of exception.", (Throwable)ex);
        }
    }

    private ArgumentsProvider initializeArgumentsProvider(Annotation source) {
        ArgumentsSource providerAnnotation = (ArgumentsSource)AnnotationSupport.findAnnotation(source.annotationType(), ArgumentsSource.class).orElseThrow(() -> new PreconditionViolationException(String.format("%s was not annotated with @ArgumentsSource but should have been.", source.annotationType())));
        return (ArgumentsProvider)ReflectionSupport.newInstance((Class)providerAnnotation.value(), (Object[])new Object[0]);
    }

    private List<Object> provideArguments(ExtensionContext context, Annotation source, ArgumentsProvider provider) throws Exception {
        if (provider instanceof CartesianAnnotationConsumer) {
            ((CartesianAnnotationConsumer)provider).accept(source);
            return provider.provideArguments(context).map(Arguments::get).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
        }
        throw new PreconditionViolationException(String.format("%s does not implement the CartesianAnnotationConsumer<T> interface.", provider.getClass()));
    }

    private List<List<?>> getSetsFromStaticFactory(Method testMethod, String explicitFactoryName) {
        if (explicitFactoryName.isEmpty()) {
            return this.invokeSetsFactory(testMethod, testMethod.getName()).getSets();
        }
        return this.invokeSetsFactory(testMethod, explicitFactoryName).getSets();
    }

    private CartesianProductTest.Sets invokeSetsFactory(Method testMethod, String factoryMethodName) {
        Method factory = this.findSetsFactory(testMethod, factoryMethodName);
        return this.invokeSetsFactory(testMethod, factory);
    }

    private Method findSetsFactory(Method testMethod, String factoryMethodName) {
        String factoryName = this.getFactoryMethodName(factoryMethodName);
        Class<?> declaringClass = this.getExplicitOrImplicitClass(testMethod, factoryMethodName);
        Method factory = PioneerUtils.findMethodCurrentOrEnclosing(declaringClass, factoryName, new Class[0]).orElseThrow(() -> new ExtensionConfigurationException("Method `CartesianProductTest.Sets " + factoryName + "()` not found in " + declaringClass + " or any enclosing class."));
        String method = "Method `" + factory + "`";
        if (!Modifier.isStatic(factory.getModifiers())) {
            throw new ExtensionConfigurationException(method + " must be static.");
        }
        if (!CartesianProductTest.Sets.class.isAssignableFrom(factory.getReturnType())) {
            throw new ExtensionConfigurationException(method + " must return `CartesianProductTest.Sets`.");
        }
        return factory;
    }

    private String getFactoryMethodName(String factoryMethodName) {
        if (factoryMethodName.contains("(")) {
            factoryMethodName = factoryMethodName.substring(0, factoryMethodName.indexOf(40));
        }
        if (factoryMethodName.contains("#")) {
            return factoryMethodName.substring(factoryMethodName.indexOf(35) + 1);
        }
        return factoryMethodName;
    }

    private Class<?> getExplicitOrImplicitClass(Method testMethod, String factoryMethodName) {
        if (factoryMethodName.contains("#")) {
            String className = factoryMethodName.substring(0, factoryMethodName.indexOf(35));
            return (Class)ReflectionSupport.tryToLoadClass((String)className).getOrThrow(ex -> new ExtensionConfigurationException(String.format("Class %s not found, referenced in method %s", className, testMethod.getName()), (Throwable)ex));
        }
        return testMethod.getDeclaringClass();
    }

    private CartesianProductTest.Sets invokeSetsFactory(Method testMethod, Method factory) {
        CartesianProductTest.Sets sets = (CartesianProductTest.Sets)ReflectionSupport.invokeMethod((Method)factory, null, (Object[])new Object[0]);
        if (sets.getSets().size() > testMethod.getParameterCount()) {
            throw new ParameterResolutionException(String.format("Method `%s` must register values for each parameter exactly once. Expected [%d] parameter sets, but got [%d].", factory, testMethod.getParameterCount(), sets.getSets().size()));
        }
        return sets;
    }
}

