/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.platform.commons.PreconditionViolationException;
import org.junitpioneer.jupiter.CartesianEnumArgumentsProvider;
import org.junitpioneer.jupiter.NullEnum;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Repeatable(value=CartesianEnumSources.class)
@ArgumentsSource(value=CartesianEnumArgumentsProvider.class)
@Deprecated
public @interface CartesianEnumSource {
    public Class<? extends Enum<?>> value() default NullEnum.class;

    public String[] names() default {};

    public Mode mode() default Mode.INCLUDE;

    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Deprecated
    public static @interface CartesianEnumSources {
        public CartesianEnumSource[] value();
    }

    public static enum Mode {
        INCLUDE(Mode::validateNames, (name, names) -> names.contains(name)),
        EXCLUDE(Mode::validateNames, (name, names) -> !names.contains(name)),
        MATCH_ALL(Mode::validatePatterns, (name, patterns) -> patterns.stream().allMatch(name::matches)),
        MATCH_ANY(Mode::validatePatterns, (name, patterns) -> patterns.stream().anyMatch(name::matches));

        private final Validator validator;
        private final BiPredicate<String, Set<String>> selector;

        private Mode(Validator validator, BiPredicate<String, Set<String>> selector) {
            this.validator = validator;
            this.selector = selector;
        }

        void validate(CartesianEnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names) {
            this.validator.validate(Objects.requireNonNull(enumSource), constants, Objects.requireNonNull(names));
        }

        boolean select(Enum<?> constant, Set<String> names) {
            return this.selector.test(Objects.requireNonNull(constant.name()), Objects.requireNonNull(names));
        }

        private static void validateNames(CartesianEnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names) {
            Set allNames = constants.stream().map(Enum::name).collect(Collectors.toSet());
            if (!allNames.containsAll(names)) {
                throw new PreconditionViolationException("Invalid enum constant name(s) in " + enumSource + ". Valid names include: " + allNames);
            }
        }

        private static void validatePatterns(CartesianEnumSource enumSource, Set<? extends Enum<?>> constants, Set<String> names) {
            try {
                names.forEach(Pattern::compile);
            }
            catch (PatternSyntaxException e) {
                throw new PreconditionViolationException("Pattern compilation failed for a regular expression supplied in " + enumSource, (Throwable)e);
            }
        }

        private static interface Validator {
            public void validate(CartesianEnumSource var1, Set<? extends Enum<?>> var2, Set<String> var3);
        }
    }
}

