/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.platform.commons.PreconditionViolationException;
import org.junitpioneer.internal.PioneerAnnotationUtils;
import org.junitpioneer.jupiter.CartesianAnnotationConsumer;
import org.junitpioneer.jupiter.CartesianEnumSource;
import org.junitpioneer.jupiter.NullEnum;

@Deprecated
class CartesianEnumArgumentsProvider
implements CartesianAnnotationConsumer<CartesianEnumSource>,
ArgumentsProvider {
    private CartesianEnumSource enumSource;

    CartesianEnumArgumentsProvider() {
    }

    @Override
    public void accept(CartesianEnumSource enumSource) {
        this.enumSource = enumSource;
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        Set<Enum> constants = this.getEnumConstants(context);
        CartesianEnumSource.Mode mode = this.enumSource.mode();
        String[] declaredConstantNames = this.enumSource.names();
        if (declaredConstantNames.length > 0) {
            Set<String> uniqueNames = Arrays.stream(declaredConstantNames).collect(Collectors.toSet());
            if (uniqueNames.size() != declaredConstantNames.length) {
                throw new PreconditionViolationException("Duplicate enum constant name(s) found in " + this.enumSource);
            }
            mode.validate(this.enumSource, constants, uniqueNames);
            constants.removeIf(constant -> !mode.select((Enum<?>)constant, uniqueNames));
        }
        return constants.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private <E extends Enum<E>> Set<? extends E> getEnumConstants(ExtensionContext context) {
        Class<E> enumClass = this.determineEnumClass(context);
        return EnumSet.allOf(enumClass);
    }

    private <E extends Enum<E>> Class<E> determineEnumClass(ExtensionContext context) {
        Class<Enum> enumClass = this.enumSource.value();
        if (enumClass.equals(NullEnum.class)) {
            Method method = context.getRequiredTestMethod();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length <= 0) {
                throw new PreconditionViolationException("Test method must declare at least one parameter: " + method.toGenericString());
            }
            Class<?> parameterType = parameterTypes[this.determineParameterTypeIndex(method)];
            if (!Enum.class.isAssignableFrom(parameterType)) {
                throw new PreconditionViolationException(String.format("Parameter of type %s must reference an Enum type (alternatively, use the annotation's 'value' attribute to specify the type explicitly): %s", parameterType, method.toGenericString()));
            }
            enumClass = parameterType;
        }
        return enumClass;
    }

    private int determineParameterTypeIndex(Method method) {
        List<Annotation> argumentSources = PioneerAnnotationUtils.findAnnotatedAnnotations(method, ArgumentsSource.class);
        return IntStream.range(0, argumentSources.size()).filter(i -> this.enumSource == argumentSources.get(i)).findFirst().orElseThrow(() -> new PreconditionViolationException("CartesianEnumSource annotation not found"));
    }
}

