/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.internal.PioneerUtils;

abstract class AbstractEntryBasedExtension<K, V, C extends Annotation, S extends Annotation>
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    AbstractEntryBasedExtension() {
    }

    public void beforeAll(ExtensionContext context) {
        this.clearAndSetEntries(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.clearAndSetEntries(context);
    }

    private void clearAndSetEntries(ExtensionContext context) {
        Map<K, V> entriesToSet;
        Set<K> entriesToClear;
        try {
            entriesToClear = this.findEntriesToClear(context);
            entriesToSet = this.findEntriesToSet(context);
            this.preventClearAndSetSameEntries(entriesToClear, entriesToSet.keySet());
        }
        catch (IllegalStateException ex) {
            throw new ExtensionConfigurationException("Don't clear/set the same entry more than once.", (Throwable)ex);
        }
        if (entriesToClear.isEmpty() && entriesToSet.isEmpty()) {
            return;
        }
        this.reportWarning(context);
        this.storeOriginalEntries(context, entriesToClear, entriesToSet.keySet());
        this.clearEntries(entriesToClear);
        this.setEntries(entriesToSet);
    }

    private Set<K> findEntriesToClear(ExtensionContext context) {
        return this.findAnnotations(context, this.getClearAnnotationType()).map(this.clearKeyMapper()).collect(PioneerUtils.distinctToSet());
    }

    private Map<K, V> findEntriesToSet(ExtensionContext context) {
        return this.findAnnotations(context, this.getSetAnnotationType()).collect(Collectors.toMap(this.setKeyMapper(), this.setValueMapper()));
    }

    private <A extends Annotation> Stream<A> findAnnotations(ExtensionContext context, Class<A> clazz) {
        return AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), clazz).stream();
    }

    private Class<C> getClearAnnotationType() {
        return this.getActualTypeArgumentAt(2);
    }

    private Class<S> getSetAnnotationType() {
        return this.getActualTypeArgumentAt(3);
    }

    private <T> Class<T> getActualTypeArgumentAt(int index) {
        ParameterizedType abstractEntryBasedExtensionType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)abstractEntryBasedExtensionType.getActualTypeArguments()[index];
    }

    private void preventClearAndSetSameEntries(Collection<K> entriesToClear, Collection<K> entriesToSet) {
        entriesToClear.stream().filter(entriesToSet::contains).map(Object::toString).reduce((e0, e1) -> e0 + ", " + e1).ifPresent(duplicateEntries -> {
            throw new IllegalStateException("Cannot clear and set the following entries at the same time: " + duplicateEntries);
        });
    }

    private void storeOriginalEntries(ExtensionContext context, Collection<K> entriesToClear, Collection<K> entriesToSet) {
        this.getStore(context).put(this.getStoreKey(context), (Object)new EntriesBackup(entriesToClear, entriesToSet));
    }

    private void clearEntries(Collection<K> entriesToClear) {
        entriesToClear.forEach(this::clearEntry);
    }

    private void setEntries(Map<K, V> entriesToSet) {
        entriesToSet.forEach(this::setEntry);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.restoreOriginalEntries(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.restoreOriginalEntries(context);
    }

    private void restoreOriginalEntries(ExtensionContext context) {
        ((EntriesBackup)this.getStore(context).getOrDefault(this.getStoreKey(context), EntriesBackup.class, (Object)new EntriesBackup())).restoreBackup();
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass()}));
    }

    private Object getStoreKey(ExtensionContext context) {
        return context.getUniqueId();
    }

    protected abstract Function<C, K> clearKeyMapper();

    protected abstract Function<S, K> setKeyMapper();

    protected abstract Function<S, V> setValueMapper();

    protected abstract void clearEntry(K var1);

    protected abstract V getEntry(K var1);

    protected abstract void setEntry(K var1, V var2);

    protected void reportWarning(ExtensionContext context) {
    }

    private class EntriesBackup {
        private final Set<K> entriesToClear = new HashSet();
        private final Map<K, V> entriesToSet = new HashMap();

        public EntriesBackup() {
        }

        public EntriesBackup(Collection<K> entriesToClear, Collection<K> entriesToSet) {
            Stream.concat(entriesToClear.stream(), entriesToSet.stream()).forEach(entry -> {
                Object backup = AbstractEntryBasedExtension.this.getEntry(entry);
                if (backup == null) {
                    this.entriesToClear.add(entry);
                } else {
                    this.entriesToSet.put(entry, backup);
                }
            });
        }

        public void restoreBackup() {
            this.entriesToClear.forEach(AbstractEntryBasedExtension.this::clearEntry);
            this.entriesToSet.forEach(AbstractEntryBasedExtension.this::setEntry);
        }
    }
}

