/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.internal;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junitpioneer.internal.PioneerUtils;

public final class TestNameFormatter {
    public static final String DISPLAY_NAME_PLACEHOLDER = "{displayName}";
    public static final String INDEX_PLACEHOLDER = "{index}";
    public static final String ARGUMENTS_PLACEHOLDER = "{arguments}";
    private final String pattern;
    private final String displayName;
    private final Class<?> forClass;

    public TestNameFormatter(String pattern, String displayName, Class<?> forClass) {
        this.pattern = pattern;
        this.displayName = displayName;
        this.forClass = forClass;
    }

    public String format(int invocationIndex, Object ... arguments) {
        try {
            return this.formatSafely(invocationIndex, arguments);
        }
        catch (Exception ex) {
            String message = "The display name pattern defined for the " + this.forClass.getName() + " is invalid. See nested exception for further details.";
            throw new ExtensionConfigurationException(message, (Throwable)ex);
        }
    }

    private String formatSafely(int invocationIndex, Object[] arguments) {
        String messageFormatPattern = this.prepareMessageFormatPattern(invocationIndex, arguments);
        MessageFormat format = new MessageFormat(messageFormatPattern);
        Object[] readableArguments = this.makeReadable(arguments);
        return format.format(readableArguments);
    }

    private String prepareMessageFormatPattern(int invocationIndex, Object[] arguments) {
        String result = this.pattern.replace(DISPLAY_NAME_PLACEHOLDER, this.displayName).replace(INDEX_PLACEHOLDER, String.valueOf(invocationIndex));
        if (result.contains(ARGUMENTS_PLACEHOLDER)) {
            String replacement = IntStream.range(0, arguments.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
            result = result.replace(ARGUMENTS_PLACEHOLDER, replacement);
        }
        return result;
    }

    private Object[] makeReadable(Object[] arguments) {
        Object[] result = Arrays.copyOf(arguments, arguments.length, Object[].class);
        for (int i = 0; i < result.length; ++i) {
            result[i] = PioneerUtils.nullSafeToString(arguments[i]);
        }
        return result;
    }
}

