/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.internal;

import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import org.junit.platform.commons.support.ReflectionSupport;

public class PioneerUtils {
    private PioneerUtils() {
    }

    public static <T> Collector<T, Set<T>, Set<T>> distinctToSet() {
        return Collector.of(HashSet::new, PioneerUtils::addButThrowIfDuplicate, (left, right) -> {
            right.forEach(element -> PioneerUtils.addButThrowIfDuplicate(left, element));
            return left;
        }, new Collector.Characteristics[0]);
    }

    private static <T> void addButThrowIfDuplicate(Set<T> set, T element) {
        boolean newElement = set.add(element);
        if (!newElement) {
            throw new IllegalStateException("Duplicate element '" + element + "'.");
        }
    }

    public static Optional<Method> findMethodCurrentOrEnclosing(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Optional method;
        Class<?> current = clazz;
        do {
            method = ReflectionSupport.findMethod(current, (String)methodName, (Class[])parameterTypes);
            current = current.getEnclosingClass();
        } while (!method.isPresent() && current != null);
        return method;
    }

    public static String nullSafeToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            switch (object.getClass().getComponentType().getSimpleName()) {
                case "boolean": {
                    return Arrays.toString((boolean[])object);
                }
                case "byte": {
                    return Arrays.toString((byte[])object);
                }
                case "char": {
                    return Arrays.toString((char[])object);
                }
                case "int": {
                    return Arrays.toString((int[])object);
                }
                case "short": {
                    return Arrays.toString((short[])object);
                }
                case "long": {
                    return Arrays.toString((long[])object);
                }
                case "float": {
                    return Arrays.toString((float[])object);
                }
                case "double": {
                    return Arrays.toString((double[])object);
                }
            }
            return Arrays.deepToString((Object[])object);
        }
        return object.toString();
    }

    public static <T> Class<T> wrap(Class<T> clazz) {
        return MethodType.methodType(clazz).wrap().returnType();
    }

    public static List<List<?>> cartesianProduct(List<List<?>> lists) {
        ArrayList resultLists = new ArrayList();
        if (lists.isEmpty()) {
            resultLists.add(Collections.emptyList());
            return resultLists;
        }
        List<?> firstList = lists.get(0);
        List<List<?>> remainingLists = PioneerUtils.cartesianProduct(lists.subList(1, lists.size()));
        for (Object item : firstList) {
            for (List<?> remainingList : remainingLists) {
                ArrayList resultList = new ArrayList();
                resultList.add(item);
                resultList.addAll(remainingList);
                resultLists.add(resultList);
            }
        }
        return resultLists;
    }
}

