/*
 * Decompiled with CFR 0.152.
 */
package org.junitpioneer.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junitpioneer.jupiter.cartesian.CartesianArgumentsSource;

public class PioneerAnnotationUtils {
    private PioneerAnnotationUtils() {
    }

    public static boolean isAnyAnnotationPresent(ExtensionContext context, Class<? extends Annotation> ... annotationTypes) {
        return Stream.of(annotationTypes).map(annotationType -> PioneerAnnotationUtils.findClosestEnclosingAnnotation(context, annotationType)).anyMatch(Optional::isPresent);
    }

    public static boolean isAnyRepeatableAnnotationPresent(ExtensionContext context, Class<? extends Annotation> ... annotationTypes) {
        return Stream.of(annotationTypes).flatMap(annotationType -> PioneerAnnotationUtils.findClosestEnclosingRepeatableAnnotations(context, annotationType)).iterator().hasNext();
    }

    public static <A extends Annotation> Optional<A> findClosestEnclosingAnnotation(ExtensionContext context, Class<A> annotationType) {
        return PioneerAnnotationUtils.findAnnotations(context, annotationType, false, false).findFirst();
    }

    public static <A extends Annotation> Stream<A> findClosestEnclosingRepeatableAnnotations(ExtensionContext context, Class<A> annotationType) {
        return PioneerAnnotationUtils.findAnnotations(context, annotationType, true, false);
    }

    public static <A extends Annotation> Stream<A> findAllEnclosingAnnotations(ExtensionContext context, Class<A> annotationType) {
        return PioneerAnnotationUtils.findAnnotations(context, annotationType, false, true);
    }

    public static <A extends Annotation> Stream<A> findAllEnclosingRepeatableAnnotations(ExtensionContext context, Class<A> annotationType) {
        return PioneerAnnotationUtils.findAnnotations(context, annotationType, true, true);
    }

    public static <A extends Annotation> List<Annotation> findAnnotatedAnnotations(AnnotatedElement element, Class<A> annotation) {
        boolean isRepeatable = annotation.isAnnotationPresent(Repeatable.class);
        return Arrays.stream(element.getDeclaredAnnotations()).flatMap(PioneerAnnotationUtils::flatten).filter(a -> !PioneerAnnotationUtils.findOnType(a.annotationType(), annotation, isRepeatable, false).isEmpty()).collect(Collectors.toList());
    }

    private static Stream<Annotation> flatten(Annotation annotation) {
        try {
            if (PioneerAnnotationUtils.isContainerAnnotation(annotation)) {
                Method value = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
                Annotation[] invoke = (Annotation[])value.invoke((Object)annotation, new Object[0]);
                return Stream.of(invoke).flatMap(PioneerAnnotationUtils::flatten);
            }
            return Stream.of(annotation);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to flatten annotation stream.", e);
        }
    }

    public static boolean isContainerAnnotation(Annotation annotation) {
        try {
            Method value = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
            return value.getReturnType().isArray() && value.getReturnType().getComponentType().isAnnotation() && PioneerAnnotationUtils.isContainerAnnotationOf(annotation, value.getReturnType().getComponentType());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean isContainerAnnotationOf(Annotation potentialContainer, Class<?> potentialRepeatable) {
        Repeatable repeatable = potentialRepeatable.getAnnotation(Repeatable.class);
        return repeatable != null && repeatable.value().equals(potentialContainer.annotationType());
    }

    static <A extends Annotation> Stream<A> findAnnotations(ExtensionContext context, Class<A> annotationType, boolean findRepeated, boolean findAllEnclosing) {
        List onMethod = context.getTestMethod().map(method -> PioneerAnnotationUtils.findOnMethod(method, annotationType, findRepeated)).orElse(Collections.emptyList());
        if (!findAllEnclosing && !onMethod.isEmpty()) {
            return onMethod.stream();
        }
        Stream<A> onClass = PioneerAnnotationUtils.findOnOuterClasses(context.getTestClass(), annotationType, findRepeated, findAllEnclosing);
        return Stream.concat(onMethod.stream(), onClass);
    }

    private static <A extends Annotation> List<A> findOnMethod(Method element, Class<A> annotationType, boolean findRepeated) {
        if (findRepeated) {
            return AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, annotationType);
        }
        return AnnotationSupport.findAnnotation((AnnotatedElement)element, annotationType).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static <A extends Annotation> Stream<A> findOnOuterClasses(Optional<Class<?>> type, Class<A> annotationType, boolean findRepeated, boolean findAllEnclosing) {
        if (!type.isPresent()) {
            return Stream.empty();
        }
        List<Annotation> onThisClass = Arrays.asList(type.get().getAnnotationsByType(annotationType));
        if (!findAllEnclosing && !onThisClass.isEmpty()) {
            return onThisClass.stream();
        }
        List<A> onClass = PioneerAnnotationUtils.findOnType(type.get(), annotationType, findRepeated, findAllEnclosing);
        Stream<A> onParentClass = PioneerAnnotationUtils.findOnOuterClasses(type.map(Class::getEnclosingClass), annotationType, findRepeated, findAllEnclosing);
        return Stream.concat(onClass.stream(), onParentClass);
    }

    private static <A extends Annotation> List<A> findOnType(Class<?> element, Class<A> annotationType, boolean findRepeated, boolean findAllEnclosing) {
        if (element == null || element == Object.class) {
            return Collections.emptyList();
        }
        if (findRepeated) {
            return AnnotationSupport.findRepeatableAnnotations(element, annotationType);
        }
        List onElement = AnnotationSupport.findAnnotation(element, annotationType).map(Collections::singletonList).orElse(Collections.emptyList());
        List onInterfaces = Arrays.stream(element.getInterfaces()).flatMap(clazz -> PioneerAnnotationUtils.findOnType(clazz, annotationType, false, findAllEnclosing).stream()).collect(Collectors.toList());
        if (!annotationType.isAnnotationPresent(Inherited.class)) {
            if (!findAllEnclosing) {
                return onElement;
            }
            return Stream.of(onElement, onInterfaces).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        List<A> onSuperclass = PioneerAnnotationUtils.findOnType(element.getSuperclass(), annotationType, false, findAllEnclosing);
        return Stream.of(onElement, onInterfaces, onSuperclass).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static List<? extends Annotation> findParameterArgumentsSources(Method testMethod) {
        return Arrays.stream(testMethod.getParameters()).map(PioneerAnnotationUtils::collectArgumentSources).filter(list -> !list.isEmpty()).map(annotations -> (Annotation)annotations.get(0)).collect(Collectors.toList());
    }

    private static List<Annotation> collectArgumentSources(Parameter parameter) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        AnnotationSupport.findAnnotation((AnnotatedElement)parameter, CartesianArgumentsSource.class).ifPresent(annotations::add);
        annotations.addAll(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)parameter, ArgumentsSource.class));
        return annotations;
    }

    public static List<Annotation> findMethodArgumentsSources(Method testMethod) {
        return Arrays.stream(testMethod.getAnnotations()).filter(annotation -> AnnotationSupport.findAnnotation(annotation.annotationType(), CartesianArgumentsSource.class).isPresent()).collect(Collectors.toList());
    }
}

