/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class LockManager<K> {
    private final ConcurrentHashMap<K, ReentrantLock> locks = new ConcurrentHashMap();
    private final LockFactory lockFactory = new LockFactory();

    LockManager() {
    }

    void lock(K key) {
        ReentrantLock lock = this.lockFactory.getLock();
        ReentrantLock oldLock;
        while ((oldLock = this.locks.putIfAbsent(key, lock)) != null) {
            oldLock.lock();
            this.lockFactory.release(oldLock);
        }
        return;
    }

    void unLock(K key) {
        ReentrantLock lock = this.locks.remove(key);
        this.lockFactory.release(lock);
    }

    private static final class LockFactory {
        private static final int CAPACITY = 100;
        private static final ArrayList<ReentrantLock> LOCKS = new ArrayList(100);

        private LockFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReentrantLock getLock() {
            ReentrantLock qLock = null;
            ArrayList<ReentrantLock> arrayList = LOCKS;
            synchronized (arrayList) {
                if (!LOCKS.isEmpty()) {
                    qLock = LOCKS.remove(0);
                }
            }
            ReentrantLock lock = qLock != null ? qLock : new ReentrantLock();
            lock.lock();
            return lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release(ReentrantLock lock) {
            lock.unlock();
            ArrayList<ReentrantLock> arrayList = LOCKS;
            synchronized (arrayList) {
                if (LOCKS.size() <= 100) {
                    LOCKS.add(lock);
                }
            }
        }
    }
}

