/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.sql.SQLException;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.h2.information_schema.Tables;
import org.jooq.tools.StringUtils;
import org.jooq.util.h2.H2DataType;

public class H2RoutineDefinition
extends AbstractRoutineDefinition {
    public H2RoutineDefinition(SchemaDefinition schema, String name, String comment, String typeName, Number precision, Number scale) {
        this(schema, name, comment, typeName, precision, scale, null);
    }

    public H2RoutineDefinition(SchemaDefinition schema, String name, String comment, String typeName, Number precision, Number scale, String overload) {
        super(schema, null, name, comment, overload);
        if (!StringUtils.isBlank((String)typeName)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, typeName, precision, precision, scale, null, (String)null);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
    }

    @Override
    protected void init0() throws SQLException {
        for (Record record : this.create().select(Tables.FUNCTION_COLUMNS.COLUMN_NAME, Tables.FUNCTION_COLUMNS.TYPE_NAME, Tables.FUNCTION_COLUMNS.PRECISION, Tables.FUNCTION_COLUMNS.SCALE, Tables.FUNCTION_COLUMNS.POS, Tables.FUNCTION_COLUMNS.NULLABLE, Tables.FUNCTION_COLUMNS.COLUMN_DEFAULT).from((TableLike)Tables.FUNCTION_COLUMNS).where(Tables.FUNCTION_COLUMNS.ALIAS_SCHEMA.equal((Object)this.getSchema().getName())).and(Tables.FUNCTION_COLUMNS.ALIAS_NAME.equal((Object)this.getName())).and(Tables.FUNCTION_COLUMNS.POS.gt((Object)0)).and(this.getOverload() == null ? DSL.noCondition() : Tables.FUNCTION_COLUMNS.COLUMN_COUNT.eq(Tables.FUNCTION_COLUMNS.COLUMN_COUNT.getDataType().convert((Object)this.getOverload()))).orderBy((OrderField)Tables.FUNCTION_COLUMNS.POS.asc()).fetch()) {
            String paramName = (String)record.get(Tables.FUNCTION_COLUMNS.COLUMN_NAME);
            String typeName = (String)record.get(Tables.FUNCTION_COLUMNS.TYPE_NAME);
            Integer precision = (Integer)record.get(Tables.FUNCTION_COLUMNS.PRECISION);
            Short scale = (Short)record.get(Tables.FUNCTION_COLUMNS.SCALE);
            int position = (Integer)record.get(Tables.FUNCTION_COLUMNS.POS);
            boolean nullable = (Boolean)record.get(Tables.FUNCTION_COLUMNS.NULLABLE, Boolean.TYPE);
            String defaultValue = (String)record.get(Tables.FUNCTION_COLUMNS.COLUMN_DEFAULT);
            if (position == 0 && H2DataType.OTHER.getTypeName().equalsIgnoreCase(typeName)) continue;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), typeName, (Number)precision, (Number)precision, (Number)scale, (Boolean)nullable, defaultValue);
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, paramName, position, type);
            this.addParameter(InOutDefinition.IN, parameter);
        }
    }
}

