/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.exception.MockFileDatabaseException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.MockDataProvider;
import org.jooq.tools.jdbc.MockExecuteContext;
import org.jooq.tools.jdbc.MockResult;

public class MockFileDatabase
implements MockDataProvider {
    private static final JooqLogger log = JooqLogger.getLogger(MockFileDatabase.class);
    private final LineNumberReader in;
    private final Map<String, List<MockResult>> matchExactly;
    private final Map<Pattern, List<MockResult>> matchPattern;
    private final DSLContext create;
    private String nullLiteral;

    public MockFileDatabase(File file) throws IOException {
        this(file, "UTF-8");
    }

    public MockFileDatabase(File file, String encoding) throws IOException {
        this(new FileInputStream(file), encoding);
    }

    public MockFileDatabase(InputStream stream) throws IOException {
        this(stream, "UTF-8");
    }

    public MockFileDatabase(InputStream stream, String encoding) throws IOException {
        this(new InputStreamReader(stream, encoding));
    }

    public MockFileDatabase(Reader reader) throws IOException {
        this(new LineNumberReader(reader));
    }

    public MockFileDatabase(String string) throws IOException {
        this(new StringReader(string));
    }

    public MockFileDatabase nullLiteral(String literal) {
        this.nullLiteral = literal;
        return this;
    }

    private MockFileDatabase(LineNumberReader reader) throws IOException {
        this.in = reader;
        this.matchExactly = new LinkedHashMap<String, List<MockResult>>();
        this.matchPattern = new LinkedHashMap<Pattern, List<MockResult>>();
        this.create = DSL.using(SQLDialect.DEFAULT);
        this.load();
    }

    private void load() throws FileNotFoundException, IOException {
        (new Object(){
            private StringBuilder currentSQL = new StringBuilder();
            private StringBuilder currentResult = new StringBuilder();
            private String previousSQL = null;

            private void load() throws FileNotFoundException, IOException {
                try {
                    while (true) {
                        String line;
                        if ((line = this.readLine()) == null) {
                            if (this.currentResult.length() > 0) {
                                this.loadOneResult("");
                                this.currentResult = new StringBuilder();
                            }
                            break;
                        }
                        if (line.startsWith("#")) continue;
                        if (line.startsWith(">")) {
                            this.currentResult.append(line.substring(2));
                            this.currentResult.append("\n");
                            continue;
                        }
                        if (line.startsWith("@")) {
                            this.loadOneResult(line);
                            this.currentResult = new StringBuilder();
                            continue;
                        }
                        if (line.endsWith(";")) {
                            this.currentSQL.append(line.substring(0, line.length() - 1));
                            if (!MockFileDatabase.this.matchExactly.containsKey(this.previousSQL)) {
                                MockFileDatabase.this.matchExactly.put(this.previousSQL, null);
                            }
                            this.previousSQL = this.currentSQL.toString();
                            this.currentSQL = new StringBuilder();
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Loaded SQL", this.previousSQL);
                            continue;
                        }
                        if (this.currentResult.length() > 0) {
                            this.loadOneResult("");
                            this.currentResult = new StringBuilder();
                        }
                        this.currentSQL.append(line);
                    }
                }
                finally {
                    if (MockFileDatabase.this.in != null) {
                        MockFileDatabase.this.in.close();
                    }
                }
            }

            private void loadOneResult(String line) {
                ArrayList<MockResult> results = (ArrayList<MockResult>)MockFileDatabase.this.matchExactly.get(this.previousSQL);
                if (results == null) {
                    results = new ArrayList<MockResult>();
                    MockFileDatabase.this.matchExactly.put(this.previousSQL, results);
                }
                MockResult mock = this.parse(line);
                results.add(mock);
                if (log.isDebugEnabled()) {
                    String comment = "Loaded Result";
                    for (String l : mock.data.format(5).split("\n")) {
                        log.debug((Object)comment, l);
                        comment = "";
                    }
                }
            }

            private MockResult parse(String rowString) {
                int rows = 0;
                if (rowString.startsWith("@ rows:")) {
                    rows = Integer.parseInt(rowString.substring(7).trim());
                }
                MockResult result = new MockResult(rows, MockFileDatabase.this.nullLiteral == null ? MockFileDatabase.this.create.fetchFromTXT(this.currentResult.toString()) : MockFileDatabase.this.create.fetchFromTXT(this.currentResult.toString(), MockFileDatabase.this.nullLiteral));
                if (rows != result.data.size()) {
                    throw new MockFileDatabaseException("Rows mismatch. Declared: " + rows + ". Actual: " + result.data.size() + ".");
                }
                return result;
            }

            private String readLine() throws IOException {
                String line;
                do {
                    if ((line = MockFileDatabase.this.in.readLine()) != null) continue;
                    return line;
                } while ((line = line.trim()).length() <= 0);
                return line;
            }
        }).load();
    }

    @Override
    public MockResult[] execute(MockExecuteContext ctx) throws SQLException {
        if (ctx.batch()) {
            throw new SQLFeatureNotSupportedException("Not yet supported");
        }
        String sql = ctx.sql();
        String inlined = null;
        List<MockResult> list = this.matchExactly.get(sql);
        if (list == null) {
            inlined = this.create.query(sql, ctx.bindings()).toString();
            list = this.matchExactly.get(inlined);
        }
        if (list == null) {
            for (Map.Entry<Pattern, List<MockResult>> entry : this.matchPattern.entrySet()) {
                if (!entry.getKey().matcher(sql).matches() && !entry.getKey().matcher(inlined).matches()) continue;
                list = entry.getValue();
            }
        }
        if (list == null) {
            throw new SQLException("Invalid SQL: " + sql);
        }
        return list.toArray(new MockResult[list.size()]);
    }
}

