/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.UDTRecord;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractParam;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

final class UDTConstant<R extends UDTRecord<R>>
extends AbstractParam<R> {
    private static final long serialVersionUID = 6807729087019209084L;

    UDTConstant(R value) {
        super(value, value.getUDT().getDataType());
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void toSQL0(RenderContext context) {
        switch (context.family()) {
            case POSTGRES: {
                this.toSQLInline(context);
                return;
            }
        }
        this.toSQLInline(context);
    }

    private final void toSQLInline(RenderContext context) {
        switch (context.family()) {
            case POSTGRES: {
                context.keyword("row");
                break;
            }
            default: {
                context.visit(((UDTRecord)this.value).getUDT());
            }
        }
        context.sql('(');
        String separator = "";
        for (Field<?> field : ((UDTRecord)this.value).fields()) {
            context.sql(separator);
            context.visit(DSL.val(((UDTRecord)this.value).get(field), field));
            separator = ", ";
        }
        context.sql(')');
    }

    @Deprecated
    private final String getInlineConstructor(RenderContext context) {
        switch (context.family()) {
            case POSTGRES: {
                return "ROW";
            }
        }
        return Tools.getMappedUDTName(context.configuration(), (UDTRecord)this.value);
    }

    final void bind0(BindContext context) {
        switch (context.family()) {
            case POSTGRES: {
                for (Field<?> field : ((UDTRecord)this.value).fields()) {
                    context.visit(DSL.val(((UDTRecord)this.value).get(field)));
                }
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("UDTs not supported in dialect " + (Object)((Object)context.dialect()));
            }
        }
    }
}

