/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.PivotForStep;
import org.jooq.PivotInStep;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Function;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;

final class Pivot<T>
extends AbstractTable<Record>
implements PivotForStep,
PivotInStep<T> {
    private static final long serialVersionUID = -7918219502110473521L;
    private final Table<?> table;
    private final SelectFieldList aggregateFunctions;
    private Field<T> on;
    private SelectFieldList in;

    Pivot(Table<?> table, Field<?> ... aggregateFunctions) {
        super("pivot");
        this.table = table;
        this.aggregateFunctions = new SelectFieldList((SelectField<?>[])aggregateFunctions);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.pivot(ctx.configuration()));
    }

    private Table<?> pivot(Configuration configuration) {
        switch (configuration.dialect()) {
            default: 
        }
        return new DefaultPivotTable();
    }

    private <Z> Condition condition(Table<?> pivot, Field<Z> field) {
        return field.equal(pivot.field(field));
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final Table<Record> as(String alias) {
        return new TableAlias<Record>(this, alias, true);
    }

    @Override
    public final Table<Record> as(String alias, String ... fieldAliases) {
        return new TableAlias<Record>(this, alias, fieldAliases, true);
    }

    @Override
    final Fields<Record> fields0() {
        return new Fields<Record>(new Field[0]);
    }

    private abstract class DialectPivotTable
    extends AbstractTable<Record> {
        private static final long serialVersionUID = 2662639259338694177L;

        DialectPivotTable() {
            super("pivot");
        }

        @Override
        public final Class<? extends Record> getRecordType() {
            return RecordImpl.class;
        }

        @Override
        public final Table<Record> as(String as) {
            return new TableAlias<Record>(this, as);
        }

        @Override
        public final Table<Record> as(String as, String ... fieldAliases) {
            return new TableAlias<Record>(this, as, fieldAliases);
        }

        @Override
        final Fields<Record> fields0() {
            return Pivot.this.fields0();
        }
    }

    private class DefaultPivotTable
    extends DialectPivotTable {
        private static final long serialVersionUID = -5930286639571867314L;

        private DefaultPivotTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.declareTables(true).visit(this.select(ctx.configuration())).declareTables(false);
        }

        private Table<Record> select(Configuration configuration) {
            ArrayList groupingFields = new ArrayList();
            ArrayList aliasedGroupingFields = new ArrayList();
            ArrayList<Field> aggregatedFields = new ArrayList<Field>();
            Table pivot = Pivot.this.table.as("pivot_outer");
            for (Field field : Pivot.this.aggregateFunctions) {
                if (!(field instanceof Function)) continue;
                for (QueryPart argument : ((Function)field).getArguments()) {
                    if (!(argument instanceof Field)) continue;
                    aggregatedFields.add((Field)argument);
                }
            }
            for (Field<?> field : Pivot.this.table.fields()) {
                if (aggregatedFields.contains(field) || Pivot.this.on.equals(field)) continue;
                aliasedGroupingFields.add(pivot.field(field));
                groupingFields.add(field);
            }
            ArrayList aggregationSelects = new ArrayList();
            for (Field inField : Pivot.this.in) {
                for (Field aggregateFunction : Pivot.this.aggregateFunctions) {
                    Condition join = DSL.trueCondition();
                    for (Field field : groupingFields) {
                        join = join.and(Pivot.this.condition(pivot, field));
                    }
                    SelectConditionStep aggregateSelect = DSL.using(configuration).select(aggregateFunction).from((TableLike<?>)Pivot.this.table).where(Pivot.this.on.equal(inField)).and(join);
                    aggregationSelects.add(aggregateSelect.asField(inField.getName() + "_" + aggregateFunction.getName()));
                }
            }
            Table<Record> select = DSL.using(configuration).select(aliasedGroupingFields).select(aggregationSelects).from((TableLike<?>)pivot).where(pivot.field(Pivot.this.on).in(Pivot.this.in.toArray((E[])Tools.EMPTY_FIELD))).groupBy(aliasedGroupingFields).asTable();
            return select;
        }
    }
}

