/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jooq.AggregateFunction;
import org.jooq.AlterIndexFinalStep;
import org.jooq.AlterIndexStep;
import org.jooq.AlterSchemaFinalStep;
import org.jooq.AlterSchemaStep;
import org.jooq.AlterTableDropStep;
import org.jooq.AlterTableFinalStep;
import org.jooq.AlterTableStep;
import org.jooq.Attachable;
import org.jooq.CaseConditionStep;
import org.jooq.CaseValueStep;
import org.jooq.CaseWhenStep;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.ConstraintFinalStep;
import org.jooq.ConstraintTypeStep;
import org.jooq.CreateIndexStep;
import org.jooq.CreateIndexWhereStep;
import org.jooq.CreateTableAsStep;
import org.jooq.CreateTableColumnStep;
import org.jooq.CreateTableOnCommitStep;
import org.jooq.DDLQuery;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.DatePart;
import org.jooq.Delete;
import org.jooq.DeleteWhereStep;
import org.jooq.DropIndexOnStep;
import org.jooq.DropSchemaFinalStep;
import org.jooq.DropSchemaStep;
import org.jooq.DropSequenceFinalStep;
import org.jooq.DropTableFinalStep;
import org.jooq.DropTableStep;
import org.jooq.DropViewFinalStep;
import org.jooq.Field;
import org.jooq.Insert;
import org.jooq.InsertSetStep;
import org.jooq.InsertValuesStepN;
import org.jooq.JoinType;
import org.jooq.Merge;
import org.jooq.MergeOnConditionStep;
import org.jooq.Name;
import org.jooq.Parser;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptionalOnStep;
import org.jooq.Truncate;
import org.jooq.TruncateCascadeStep;
import org.jooq.TruncateFinalStep;
import org.jooq.TruncateIdentityStep;
import org.jooq.Update;
import org.jooq.WindowBeforeOverStep;
import org.jooq.WindowFinalStep;
import org.jooq.WindowIgnoreNullsStep;
import org.jooq.WindowOverStep;
import org.jooq.WindowSpecification;
import org.jooq.WindowSpecificationOrderByStep;
import org.jooq.WindowSpecificationRowsAndStep;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.SQLStateSubclass;
import org.jooq.impl.CombineOperator;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.QueriesImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SelectQueryImpl;
import org.jooq.impl.Tools;

@Deprecated
class ParserImpl
implements Parser {
    private final Configuration configuration;
    private final DSLContext dsl;
    private static final String[] SELECT_KEYWORDS = new String[]{"CONNECT", "CROSS", "EXCEPT", "FETCH", "FULL", "FROM", "GROUP BY", "HAVING", "INNER", "INTERSECT", "JOIN", "LEFT", "LIMIT", "MINUS", "NATURAL", "OFFSET", "ON", "ORDER BY", "OUTER", "RIGHT", "SELECT", "START", "UNION", "USING", "WHERE"};

    ParserImpl(Configuration configuration) {
        this.configuration = configuration;
        this.dsl = DSL.using(configuration);
    }

    @Override
    public final Queries parse(String sql) {
        ParserContext ctx = new ParserContext(this.dsl, sql);
        ArrayList<Query> result = new ArrayList<Query>();
        do {
            result.add(ParserImpl.parseQuery(ctx));
        } while (ParserImpl.parseIf(ctx, ";"));
        if (!ctx.done()) {
            throw new ParserException(ctx);
        }
        return new QueriesImpl(result);
    }

    @Override
    public final Query parseQuery(String sql) {
        ParserContext ctx = new ParserContext(this.dsl, sql);
        Query result = ParserImpl.parseQuery(ctx);
        if (!ctx.done()) {
            throw new ParserException(ctx);
        }
        return result;
    }

    @Override
    public final Table<?> parseTable(String sql) {
        ParserContext ctx = new ParserContext(this.dsl, sql);
        Table<?> result = ParserImpl.parseTable(ctx);
        if (!ctx.done()) {
            throw new ParserException(ctx);
        }
        return result;
    }

    @Override
    public final Field<?> parseField(String sql) {
        ParserContext ctx = new ParserContext(this.dsl, sql);
        Field<?> result = ParserImpl.parseField(ctx);
        if (!ctx.done()) {
            throw new ParserException(ctx);
        }
        return result;
    }

    @Override
    public final Condition parseCondition(String sql) {
        ParserContext ctx = new ParserContext(this.dsl, sql);
        Condition result = ParserImpl.parseCondition(ctx);
        if (!ctx.done()) {
            throw new ParserException(ctx);
        }
        return result;
    }

    @Override
    public final Name parseName(String sql) {
        ParserContext ctx = new ParserContext(this.dsl, sql);
        Name result = ParserImpl.parseName(ctx);
        if (!ctx.done()) {
            throw new ParserException(ctx);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final Query parseQuery(ParserContext ctx) {
        if (ctx.done()) {
            return null;
        }
        ParserImpl.parseWhitespaceIf(ctx);
        try {
            switch (ctx.character()) {
                case 'A': 
                case 'a': {
                    if (!ParserImpl.peekKeyword(ctx, "ALTER")) throw ctx.exception();
                    DDLQuery dDLQuery = ParserImpl.parseAlter(ctx);
                    return dDLQuery;
                }
                case 'C': 
                case 'c': {
                    if (!ParserImpl.peekKeyword(ctx, "CREATE")) throw ctx.exception();
                    DDLQuery dDLQuery = ParserImpl.parseCreate(ctx);
                    return dDLQuery;
                }
                case 'D': 
                case 'd': {
                    if (ParserImpl.peekKeyword(ctx, "DELETE")) {
                        Delete<?> delete = ParserImpl.parseDelete(ctx);
                        return delete;
                    }
                    if (!ParserImpl.peekKeyword(ctx, "DROP")) throw ctx.exception();
                    DDLQuery dDLQuery = ParserImpl.parseDrop(ctx);
                    return dDLQuery;
                }
                case 'I': 
                case 'i': {
                    if (!ParserImpl.peekKeyword(ctx, "INSERT")) throw ctx.exception();
                    Insert<?> insert = ParserImpl.parseInsert(ctx);
                    return insert;
                }
                case 'M': 
                case 'm': {
                    if (!ParserImpl.peekKeyword(ctx, "MERGE")) throw ctx.exception();
                    Merge<?> merge = ParserImpl.parseMerge(ctx);
                    return merge;
                }
                case 'R': 
                case 'r': {
                    if (!ParserImpl.peekKeyword(ctx, "RENAME")) throw ctx.exception();
                    DDLQuery dDLQuery = ParserImpl.parseRename(ctx);
                    return dDLQuery;
                }
                case 'S': 
                case 's': {
                    if (!ParserImpl.peekKeyword(ctx, "SELECT")) throw ctx.exception();
                    SelectQueryImpl<Record> selectQueryImpl = ParserImpl.parseSelect(ctx);
                    return selectQueryImpl;
                }
                case 'T': 
                case 't': {
                    if (!ParserImpl.peekKeyword(ctx, "TRUNCATE")) throw ctx.exception();
                    Truncate<?> truncate = ParserImpl.parseTruncate(ctx);
                    return truncate;
                }
                case 'U': 
                case 'u': {
                    if (!ParserImpl.peekKeyword(ctx, "UPDATE")) throw ctx.exception();
                    Update<?> update = ParserImpl.parseUpdate(ctx);
                    return update;
                }
                case '(': {
                    SelectQueryImpl<Record> selectQueryImpl = ParserImpl.parseSelect(ctx);
                    return selectQueryImpl;
                }
            }
            throw ctx.exception();
        }
        finally {
            ParserImpl.parseWhitespaceIf(ctx);
            if (!ctx.done() && ctx.character() != ';') {
                throw ctx.unexpectedToken();
            }
        }
    }

    private static final SelectQueryImpl<Record> parseSelect(ParserContext ctx) {
        CombineOperator combine;
        SelectQueryImpl result = ParserImpl.parseQueryPrimary(ctx);
        block8: while ((combine = ParserImpl.parseCombineOperatorIf(ctx)) != null) {
            switch (combine) {
                case UNION: {
                    result = (SelectQueryImpl)result.union(ParserImpl.parseQueryPrimary(ctx));
                    continue block8;
                }
                case UNION_ALL: {
                    result = (SelectQueryImpl)result.unionAll(ParserImpl.parseQueryPrimary(ctx));
                    continue block8;
                }
                case EXCEPT: {
                    result = (SelectQueryImpl)result.except(ParserImpl.parseQueryPrimary(ctx));
                    continue block8;
                }
                case EXCEPT_ALL: {
                    result = (SelectQueryImpl)result.exceptAll(ParserImpl.parseQueryPrimary(ctx));
                    continue block8;
                }
                case INTERSECT: {
                    result = (SelectQueryImpl)result.intersect(ParserImpl.parseQueryPrimary(ctx));
                    continue block8;
                }
                case INTERSECT_ALL: {
                    result = (SelectQueryImpl)result.intersectAll(ParserImpl.parseQueryPrimary(ctx));
                    continue block8;
                }
            }
            ctx.unexpectedToken();
        }
        if (ParserImpl.parseKeywordIf(ctx, "ORDER BY")) {
            result.addOrderBy(ParserImpl.parseSortSpecification(ctx));
        }
        if (!result.getLimit().isApplicable()) {
            boolean offsetStandard = false;
            boolean offsetPostgres = false;
            if (ParserImpl.parseKeywordIf(ctx, "OFFSET")) {
                result.addOffset((int)ParserImpl.parseUnsignedInteger(ctx).longValue());
                if (ParserImpl.parseKeywordIf(ctx, "ROWS") || ParserImpl.parseKeywordIf(ctx, "ROW")) {
                    offsetStandard = true;
                } else {
                    offsetPostgres = true;
                }
            }
            if (!offsetStandard && ParserImpl.parseKeywordIf(ctx, "LIMIT")) {
                int limit = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
                if (!offsetPostgres && ParserImpl.parseIf(ctx, ',')) {
                    result.addLimit(limit, (int)ParserImpl.parseUnsignedInteger(ctx).longValue());
                } else if (!offsetPostgres && ParserImpl.parseKeywordIf(ctx, "OFFSET")) {
                    result.addLimit((int)ParserImpl.parseUnsignedInteger(ctx).longValue(), limit);
                } else {
                    result.addLimit(limit);
                }
            } else if (!offsetPostgres && ParserImpl.parseKeywordIf(ctx, "FETCH")) {
                if (!ParserImpl.parseKeywordIf(ctx, "FIRST") && !ParserImpl.parseKeywordIf(ctx, "NEXT")) {
                    throw ctx.unexpectedToken();
                }
                result.addLimit((int)ParserImpl.parseUnsignedInteger(ctx).longValue());
                if (!ParserImpl.parseKeywordIf(ctx, "ROWS ONLY") && !ParserImpl.parseKeywordIf(ctx, "ROW ONLY")) {
                    throw ctx.unexpectedToken();
                }
            }
        }
        return result;
    }

    private static final SelectQueryImpl<Record> parseQueryPrimary(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, '(')) {
            SelectQueryImpl<Record> result = ParserImpl.parseSelect(ctx);
            ParserImpl.parse(ctx, ')');
            return result;
        }
        ParserImpl.parseKeyword(ctx, "SELECT");
        boolean distinct = ParserImpl.parseKeywordIf(ctx, "DISTINCT") || ParserImpl.parseKeywordIf(ctx, "UNIQUE");
        Long limit = null;
        Long offset = null;
        if (!distinct) {
            ParserImpl.parseKeywordIf(ctx, "ALL");
        }
        if (ParserImpl.parseKeywordIf(ctx, "TOP")) {
            limit = ParserImpl.parseUnsignedInteger(ctx);
            if (ParserImpl.parseKeywordIf(ctx, "START AT")) {
                offset = ParserImpl.parseUnsignedInteger(ctx);
            }
        }
        List<Field<?>> select = ParserImpl.parseSelectList(ctx);
        List<Table<?>> from = null;
        Condition startWith = null;
        Condition connectBy = null;
        boolean connectByNoCycle = false;
        Condition where = null;
        List<Object> groupBy = null;
        Condition having = null;
        if (ParserImpl.parseKeywordIf(ctx, "FROM")) {
            from = ParserImpl.parseTables(ctx);
        }
        if (from != null && from.size() == 1 && from.get(0).getName().equalsIgnoreCase("dual")) {
            from = null;
        }
        if (ParserImpl.parseKeywordIf(ctx, "START WITH")) {
            startWith = ParserImpl.parseCondition(ctx);
            ParserImpl.parseKeyword(ctx, "CONNECT BY");
            connectByNoCycle = ParserImpl.parseKeywordIf(ctx, "NOCYCLE");
            connectBy = ParserImpl.parseCondition(ctx);
        } else if (ParserImpl.parseKeywordIf(ctx, "CONNECT BY")) {
            connectByNoCycle = ParserImpl.parseKeywordIf(ctx, "NOCYCLE");
            connectBy = ParserImpl.parseCondition(ctx);
            if (ParserImpl.parseKeywordIf(ctx, "START WITH")) {
                startWith = ParserImpl.parseCondition(ctx);
            }
        }
        if (ParserImpl.parseKeywordIf(ctx, "WHERE")) {
            where = ParserImpl.parseCondition(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "GROUP BY")) {
            if (ParserImpl.parseIf(ctx, '(')) {
                ParserImpl.parse(ctx, ')');
                groupBy = Collections.emptyList();
            } else if (ParserImpl.parseKeywordIf(ctx, "ROLLUP")) {
                ParserImpl.parse(ctx, '(');
                groupBy = Collections.singletonList(DSL.rollup(ParserImpl.parseFields(ctx).toArray(Tools.EMPTY_FIELD)));
                ParserImpl.parse(ctx, ')');
            } else if (ParserImpl.parseKeywordIf(ctx, "CUBE")) {
                ParserImpl.parse(ctx, '(');
                groupBy = Collections.singletonList(DSL.cube(ParserImpl.parseFields(ctx).toArray(Tools.EMPTY_FIELD)));
                ParserImpl.parse(ctx, ')');
            } else if (ParserImpl.parseKeywordIf(ctx, "GROUPING SETS")) {
                ArrayList<List<Object>> fieldSets = new ArrayList<List<Object>>();
                ParserImpl.parse(ctx, '(');
                do {
                    ParserImpl.parse(ctx, '(');
                    if (ParserImpl.parseIf(ctx, ')')) {
                        fieldSets.add(Collections.emptyList());
                        continue;
                    }
                    fieldSets.add(ParserImpl.parseFields(ctx));
                    ParserImpl.parse(ctx, ')');
                } while (ParserImpl.parseIf(ctx, ','));
                ParserImpl.parse(ctx, ')');
                groupBy = Collections.singletonList(DSL.groupingSets(fieldSets.toArray(Tools.EMPTY_COLLECTION)));
            } else {
                groupBy = ParserImpl.parseFields(ctx);
                if (ParserImpl.parseKeywordIf(ctx, "WITH ROLLUP")) {
                    groupBy = Collections.singletonList(DSL.rollup(groupBy.toArray(Tools.EMPTY_FIELD)));
                }
            }
        }
        if (ParserImpl.parseKeywordIf(ctx, "HAVING")) {
            having = ParserImpl.parseCondition(ctx);
        }
        SelectQueryImpl result = (SelectQueryImpl)ctx.dsl.selectQuery();
        if (distinct) {
            result.setDistinct(distinct);
        }
        if (select.size() > 0) {
            result.addSelect(select);
        }
        if (from != null) {
            result.addFrom(from);
        }
        if (connectBy != null) {
            if (connectByNoCycle) {
                result.addConnectByNoCycle(connectBy);
            } else {
                result.addConnectBy(connectBy);
            }
        }
        if (startWith != null) {
            result.setConnectByStartWith(startWith);
        }
        if (where != null) {
            result.addConditions(where);
        }
        if (groupBy != null) {
            result.addGroupBy(groupBy);
        }
        if (having != null) {
            result.addHaving(having);
        }
        if (limit != null) {
            if (offset != null) {
                result.addLimit((int)offset.longValue(), (int)limit.longValue());
            } else {
                result.addLimit((int)limit.longValue());
            }
        }
        return result;
    }

    private static final Delete<?> parseDelete(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "DELETE");
        ParserImpl.parseKeywordIf(ctx, "FROM");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        boolean where = ParserImpl.parseKeywordIf(ctx, "WHERE");
        Condition condition = where ? ParserImpl.parseCondition(ctx) : null;
        DeleteWhereStep<?> s1 = ctx.dsl.delete(tableName);
        DeleteWhereStep<?> s2 = where ? s1.where(condition) : s1;
        return s2;
    }

    private static final Insert<?> parseInsert(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "INSERT INTO");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        Field<?>[] fields = null;
        if (ParserImpl.parseIf(ctx, '(')) {
            fields = Tools.fieldsByName(ParserImpl.parseIdentifiers(ctx).toArray(Tools.EMPTY_STRING));
            ParserImpl.parse(ctx, ')');
        }
        if (ParserImpl.parseKeywordIf(ctx, "VALUES")) {
            ArrayList allValues = new ArrayList();
            do {
                ParserImpl.parse(ctx, '(');
                List<Field<?>> values = ParserImpl.parseFields(ctx);
                if (fields != null && fields.length != values.size()) {
                    throw ctx.exception();
                }
                allValues.add(values);
                ParserImpl.parse(ctx, ')');
            } while (ParserImpl.parseIf(ctx, ','));
            InsertSetStep<?> step1 = ctx.dsl.insertInto(tableName);
            InsertValuesStepN<?> step2 = fields != null ? step1.columns(fields) : (InsertValuesStepN<?>)((Object)step1);
            for (List list : allValues) {
                step2 = step2.values(list);
            }
            return step2;
        }
        if (ParserImpl.parseKeywordIf(ctx, "SET")) {
            Map<Field<?>, Object> map = ParserImpl.parseSetClauseList(ctx);
            return ctx.dsl.insertInto(tableName).set(map);
        }
        if (ParserImpl.peekKeyword(ctx, "SELECT")) {
            SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
            return fields == null ? ctx.dsl.insertInto(tableName).select(select) : ctx.dsl.insertInto(tableName).columns(fields).select(select);
        }
        if (ParserImpl.parseKeywordIf(ctx, "DEFAULT VALUES")) {
            if (fields != null) {
                throw ctx.exception();
            }
            return ctx.dsl.insertInto(tableName).defaultValues();
        }
        throw ctx.unexpectedToken();
    }

    private static final Update<?> parseUpdate(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "UPDATE");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        ParserImpl.parseKeyword(ctx, "SET");
        Map<Field<?>, Object> map = ParserImpl.parseSetClauseList(ctx);
        Condition condition = ParserImpl.parseKeywordIf(ctx, "WHERE") ? ParserImpl.parseCondition(ctx) : null;
        return condition == null ? ctx.dsl.update(tableName).set(map) : ctx.dsl.update(tableName).set(map).where(condition);
    }

    private static final Map<Field<?>, Object> parseSetClauseList(ParserContext ctx) {
        LinkedHashMap map = new LinkedHashMap();
        do {
            TableField<?, ?> field;
            if (map.containsKey(field = ParserImpl.parseFieldName(ctx))) {
                throw ctx.exception();
            }
            ParserImpl.parse(ctx, '=');
            Field<?> value = ParserImpl.parseField(ctx);
            map.put(field, value);
        } while (ParserImpl.parseIf(ctx, ','));
        return map;
    }

    private static final Merge<?> parseMerge(ParserContext ctx) {
        Map<Field<?>, Object> updateSet;
        List<Field<?>> insertValues;
        List<Field<?>> insertColumns;
        boolean insert;
        boolean update;
        Condition on;
        TableLike<Record> using;
        Table<?> target;
        block4: {
            ParserImpl.parseKeyword(ctx, "MERGE INTO");
            target = ParserImpl.parseTableName(ctx);
            ParserImpl.parseKeyword(ctx, "USING");
            ParserImpl.parse(ctx, '(');
            using = ParserImpl.parseSelect(ctx);
            ParserImpl.parse(ctx, ')');
            if (ParserImpl.parseKeywordIf(ctx, "AS")) {
                using = using.asTable(ParserImpl.parseIdentifier(ctx));
            }
            ParserImpl.parseKeyword(ctx, "ON");
            on = ParserImpl.parseCondition(ctx);
            update = false;
            insert = false;
            insertColumns = null;
            insertValues = null;
            updateSet = null;
            while (true) {
                if (!update && (update = ParserImpl.parseKeywordIf(ctx, "WHEN MATCHED THEN UPDATE SET"))) {
                    updateSet = ParserImpl.parseSetClauseList(ctx);
                    continue;
                }
                if (insert || !(insert = ParserImpl.parseKeywordIf(ctx, "WHEN NOT MATCHED THEN INSERT"))) break block4;
                ParserImpl.parse(ctx, '(');
                insertColumns = Arrays.asList(Tools.fieldsByName(ParserImpl.parseIdentifiers(ctx)));
                ParserImpl.parse(ctx, ')');
                ParserImpl.parseKeyword(ctx, "VALUES");
                ParserImpl.parse(ctx, '(');
                insertValues = ParserImpl.parseFields(ctx);
                ParserImpl.parse(ctx, ')');
                if (insertColumns.size() != insertValues.size()) break;
            }
            throw ctx.exception();
        }
        if (!update && !insert) {
            throw ctx.exception();
        }
        MergeOnConditionStep<?> s1 = ctx.dsl.mergeInto(target).using(using).on(on);
        MergeOnConditionStep<?> s2 = update ? s1.whenMatchedThenUpdate().set(updateSet) : s1;
        MergeOnConditionStep<?> s3 = insert ? s2.whenNotMatchedThenInsert(insertColumns).values(insertValues) : s2;
        return s3;
    }

    private static final DDLQuery parseCreate(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "CREATE");
        if (ParserImpl.parseKeywordIf(ctx, "TABLE")) {
            return ParserImpl.parseCreateTable(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "INDEX")) {
            return ParserImpl.parseCreateIndex(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
            return ParserImpl.parseCreateSchema(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "VIEW")) {
            return ParserImpl.parseCreateView(ctx);
        }
        throw ctx.unexpectedToken();
    }

    private static final DDLQuery parseAlter(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "ALTER");
        if (ParserImpl.parseKeywordIf(ctx, "TABLE")) {
            return ParserImpl.parseAlterTable(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "INDEX")) {
            return ParserImpl.parseAlterIndex(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
            return ParserImpl.parseAlterSchema(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "VIEW")) {
            return ParserImpl.parseAlterView(ctx);
        }
        throw ctx.unexpectedToken();
    }

    private static final DDLQuery parseDrop(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "DROP");
        if (ParserImpl.parseKeywordIf(ctx, "TABLE")) {
            return ParserImpl.parseDropTable(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "INDEX")) {
            return ParserImpl.parseDropIndex(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "VIEW")) {
            return ParserImpl.parseDropView(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SEQUENCE")) {
            return ParserImpl.parseDropSequence(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
            return ParserImpl.parseDropSchema(ctx);
        }
        throw ctx.unexpectedToken();
    }

    private static final Truncate<?> parseTruncate(ParserContext ctx) {
        TruncateCascadeStep<?> step2;
        ParserImpl.parseKeyword(ctx, "TRUNCATE");
        ParserImpl.parseKeyword(ctx, "TABLE");
        Table<?> table = ParserImpl.parseTableName(ctx);
        boolean continueIdentity = ParserImpl.parseKeywordIf(ctx, "CONTINUE IDENTITY");
        boolean restartIdentity = !continueIdentity && ParserImpl.parseKeywordIf(ctx, "RESTART IDENTITY");
        boolean cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE");
        boolean restrict = !cascade && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
        TruncateIdentityStep<?> step1 = ctx.dsl.truncate(table);
        TruncateCascadeStep<?> truncateCascadeStep = continueIdentity ? step1.continueIdentity() : (step2 = restartIdentity ? step1.restartIdentity() : step1);
        TruncateFinalStep<?> step3 = cascade ? step2.cascade() : (restrict ? step2.restrict() : step2);
        return step3;
    }

    private static final DDLQuery parseCreateView(ParserContext ctx) {
        boolean ifNotExists = ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Table<?> view = ParserImpl.parseTableName(ctx);
        Field<?>[] fields = Tools.EMPTY_FIELD;
        if (ParserImpl.parseIf(ctx, '(')) {
            fields = ParserImpl.parseFieldNames(ctx).toArray(fields);
            ParserImpl.parse(ctx, ')');
        }
        ParserImpl.parseKeyword(ctx, "AS");
        SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
        if (fields.length > 0 && fields.length != select.getSelect().size()) {
            throw ctx.exception();
        }
        return ifNotExists ? ctx.dsl.createViewIfNotExists(view, fields).as(select) : ctx.dsl.createView(view, fields).as(select);
    }

    private static final DDLQuery parseAlterView(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> oldName = ParserImpl.parseTableName(ctx);
        ParserImpl.parseKeyword(ctx, "RENAME TO");
        Table<?> newName = ParserImpl.parseTableName(ctx);
        return ifExists ? ctx.dsl.alterViewIfExists(oldName).renameTo(newName) : ctx.dsl.alterView(oldName).renameTo(newName);
    }

    private static final DDLQuery parseDropView(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        DropViewFinalStep s1 = ifExists ? ctx.dsl.dropViewIfExists(tableName) : ctx.dsl.dropView(tableName);
        return s1;
    }

    private static final DDLQuery parseDropSequence(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Sequence<?> sequenceName = ParserImpl.parseSequenceName(ctx);
        DropSequenceFinalStep s1 = ifExists ? ctx.dsl.dropSequenceIfExists(sequenceName) : ctx.dsl.dropSequence(sequenceName);
        return s1;
    }

    private static final DDLQuery parseCreateTable(ParserContext ctx) {
        boolean ifNotExists = ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "AS")) {
            SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
            CreateTableAsStep<Record> s1 = ifNotExists ? ctx.dsl.createTableIfNotExists(tableName) : ctx.dsl.createTable(tableName);
            CreateTableOnCommitStep s2 = s1.as(select);
            return s2;
        }
        ArrayList fields = new ArrayList();
        ArrayList<ConstraintFinalStep> constraints = new ArrayList<ConstraintFinalStep>();
        boolean primary = false;
        boolean noConstraint = true;
        ParserImpl.parse(ctx, '(');
        do {
            String fieldName = ParserImpl.parseIdentifier(ctx);
            DataType<?> type = ParserImpl.parseDataType(ctx);
            boolean nullable = false;
            boolean defaultValue = false;
            boolean unique = false;
            while (true) {
                if (!nullable) {
                    if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
                        type = type.nullable(true);
                        nullable = true;
                        continue;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "NOT NULL")) {
                        type = type.nullable(false);
                        nullable = true;
                        continue;
                    }
                }
                if (!defaultValue && ParserImpl.parseKeywordIf(ctx, "DEFAULT")) {
                    type = type.defaultValue(ParserImpl.parseField(ctx));
                    defaultValue = true;
                    continue;
                }
                if (!unique) {
                    if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
                        constraints.add(DSL.primaryKey(fieldName));
                        primary = true;
                        unique = true;
                        continue;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
                        constraints.add(DSL.unique(fieldName));
                        unique = true;
                        continue;
                    }
                }
                if (!ParserImpl.parseKeywordIf(ctx, "CHECK")) break;
                ParserImpl.parse(ctx, '(');
                constraints.add(DSL.check(ParserImpl.parseCondition(ctx)));
                ParserImpl.parse(ctx, ')');
            }
            fields.add(DSL.field(DSL.name(fieldName), type));
        } while (ParserImpl.parseIf(ctx, ',') && (noConstraint = !ParserImpl.peekKeyword(ctx, "PRIMARY KEY") && !ParserImpl.peekKeyword(ctx, "UNIQUE") && !ParserImpl.peekKeyword(ctx, "FOREIGN KEY") && !ParserImpl.peekKeyword(ctx, "CHECK") && !ParserImpl.peekKeyword(ctx, "CONSTRAINT")));
        if (!noConstraint) {
            do {
                Field<?>[] fieldNames;
                ConstraintTypeStep constraint = null;
                if (ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) {
                    constraint = DSL.constraint(ParserImpl.parseIdentifier(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
                    if (primary) {
                        throw ctx.exception();
                    }
                    primary = true;
                    ParserImpl.parse(ctx, '(');
                    fieldNames = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    constraints.add(constraint == null ? DSL.primaryKey(fieldNames) : constraint.primaryKey(fieldNames));
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
                    ParserImpl.parse(ctx, '(');
                    fieldNames = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    constraints.add(constraint == null ? DSL.unique(fieldNames) : constraint.unique(fieldNames));
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "FOREIGN KEY")) {
                    ParserImpl.parse(ctx, '(');
                    Field<?>[] referencing = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    ParserImpl.parseKeyword(ctx, "REFERENCES");
                    Table<?> referencedTable = ParserImpl.parseTableName(ctx);
                    ParserImpl.parse(ctx, '(');
                    Field<?>[] referencedFields = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    if (referencing.length != referencedFields.length) {
                        throw ctx.exception();
                    }
                    constraints.add(constraint == null ? DSL.foreignKey(referencing).references(referencedTable, referencedFields) : constraint.foreignKey(referencing).references(referencedTable, referencedFields));
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "CHECK")) {
                    ParserImpl.parse(ctx, '(');
                    Condition condition = ParserImpl.parseCondition(ctx);
                    ParserImpl.parse(ctx, ')');
                    constraints.add(constraint == null ? DSL.check(condition) : constraint.check(condition));
                    continue;
                }
                throw ctx.unexpectedToken();
            } while (ParserImpl.parseIf(ctx, ','));
        }
        ParserImpl.parse(ctx, ')');
        CreateTableAsStep<Record> s1 = ifNotExists ? ctx.dsl.createTableIfNotExists(tableName) : ctx.dsl.createTable(tableName);
        CreateTableColumnStep s2 = s1.columns(fields);
        CreateTableColumnStep s3 = constraints.isEmpty() ? s2 : s2.constraints(constraints);
        return s3;
    }

    private static final DDLQuery parseAlterTable(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        ParserImpl.parseWhitespaceIf(ctx);
        AlterTableStep s1 = ifExists ? ctx.dsl.alterTableIfExists(tableName) : ctx.dsl.alterTable(tableName);
        switch (ctx.character()) {
            case 'A': 
            case 'a': {
                if (!ParserImpl.parseKeywordIf(ctx, "ADD")) break;
                ConstraintTypeStep constraint = null;
                if (ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) {
                    constraint = DSL.constraint(ParserImpl.parseIdentifier(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
                    ParserImpl.parse(ctx, '(');
                    Field<?>[] fieldNames = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    return constraint == null ? s1.add(DSL.primaryKey(fieldNames)) : s1.add(constraint.primaryKey(fieldNames));
                }
                if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
                    ParserImpl.parse(ctx, '(');
                    Field<?>[] fieldNames = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    return constraint == null ? s1.add(DSL.unique(fieldNames)) : s1.add(constraint.unique(fieldNames));
                }
                if (ParserImpl.parseKeywordIf(ctx, "FOREIGN KEY")) {
                    ParserImpl.parse(ctx, '(');
                    Field<?>[] referencing = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    ParserImpl.parseKeyword(ctx, "REFERENCES");
                    Table<?> referencedTable = ParserImpl.parseTableName(ctx);
                    ParserImpl.parse(ctx, '(');
                    Field<?>[] referencedFields = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
                    ParserImpl.parse(ctx, ')');
                    if (referencing.length != referencedFields.length) {
                        throw ctx.exception();
                    }
                    return constraint == null ? s1.add(DSL.foreignKey(referencing).references(referencedTable, referencedFields)) : s1.add(constraint.foreignKey(referencing).references(referencedTable, referencedFields));
                }
                if (ParserImpl.parseKeywordIf(ctx, "CHECK")) {
                    ParserImpl.parse(ctx, '(');
                    Condition condition = ParserImpl.parseCondition(ctx);
                    ParserImpl.parse(ctx, ')');
                    return constraint == null ? s1.add(DSL.check(condition)) : s1.add(constraint.check(condition));
                }
                if (constraint != null) {
                    throw ctx.unexpectedToken();
                }
                ParserImpl.parseKeywordIf(ctx, "COLUMN");
                String fieldName = ParserImpl.parseIdentifier(ctx);
                DataType<?> type = ParserImpl.parseDataType(ctx);
                boolean nullable = false;
                boolean defaultValue = false;
                boolean unique = false;
                while (true) {
                    if (!nullable) {
                        if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
                            type = type.nullable(true);
                            nullable = true;
                            continue;
                        }
                        if (ParserImpl.parseKeywordIf(ctx, "NOT NULL")) {
                            type = type.nullable(false);
                            nullable = true;
                            continue;
                        }
                    }
                    if (defaultValue || !ParserImpl.parseKeywordIf(ctx, "DEFAULT")) break;
                    type = type.defaultValue(ParserImpl.parseField(ctx));
                    defaultValue = true;
                }
                if (!unique) {
                    if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
                        throw ctx.unexpectedToken();
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
                        throw ctx.unexpectedToken();
                    }
                }
                if (ParserImpl.parseKeywordIf(ctx, "CHECK")) {
                    throw ctx.unexpectedToken();
                }
                return s1.add(DSL.field(DSL.name(fieldName), type), type);
            }
            case 'D': 
            case 'd': {
                if (!ParserImpl.parseKeywordIf(ctx, "DROP")) break;
                if (ParserImpl.parseKeywordIf(ctx, "COLUMN")) {
                    TableField<?, ?> field = ParserImpl.parseFieldName(ctx);
                    boolean cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE");
                    boolean restrict = !cascade && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
                    AlterTableDropStep s2 = s1.dropColumn(field);
                    AlterTableFinalStep s3 = cascade ? s2.cascade() : (restrict ? s2.restrict() : s2);
                    return s3;
                }
                if (!ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) break;
                String constraint = ParserImpl.parseIdentifier(ctx);
                return s1.dropConstraint(constraint);
            }
            case 'R': 
            case 'r': {
                if (!ParserImpl.parseKeywordIf(ctx, "RENAME")) break;
                if (ParserImpl.parseKeywordIf(ctx, "TO")) {
                    String newName = ParserImpl.parseIdentifier(ctx);
                    return s1.renameTo(newName);
                }
                if (ParserImpl.parseKeywordIf(ctx, "COLUMN")) {
                    String oldName = ParserImpl.parseIdentifier(ctx);
                    ParserImpl.parseKeyword(ctx, "TO");
                    String newName = ParserImpl.parseIdentifier(ctx);
                    return s1.renameColumn(oldName).to(newName);
                }
                if (!ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) break;
                String oldName = ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "TO");
                String newName = ParserImpl.parseIdentifier(ctx);
                return s1.renameConstraint(oldName).to(newName);
            }
        }
        throw ctx.unexpectedToken();
    }

    private static final DDLQuery parseRename(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "RENAME");
        ParserImpl.parseWhitespaceIf(ctx);
        switch (ctx.character()) {
            case 'C': 
            case 'c': {
                if (!ParserImpl.parseKeywordIf(ctx, "COLUMN")) break;
                TableField<?, ?> oldName = ParserImpl.parseFieldName(ctx);
                ParserImpl.parseKeyword(ctx, "TO");
                TableField<?, ?> newName = ParserImpl.parseFieldName(ctx);
                return ctx.dsl.alterTable(oldName.getTable().getName()).renameColumn(oldName).to(newName);
            }
            case 'I': 
            case 'i': {
                if (!ParserImpl.parseKeywordIf(ctx, "INDEX")) break;
                Name oldName = ParserImpl.parseIndexName(ctx);
                ParserImpl.parseKeyword(ctx, "TO");
                Name newName = ParserImpl.parseIndexName(ctx);
                return ctx.dsl.alterIndex(oldName).renameTo(newName);
            }
            case 'S': 
            case 's': {
                if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
                    Schema oldName = ParserImpl.parseSchemaName(ctx);
                    ParserImpl.parseKeyword(ctx, "TO");
                    Schema newName = ParserImpl.parseSchemaName(ctx);
                    return ctx.dsl.alterSchema(oldName).renameTo(newName);
                }
                if (!ParserImpl.parseKeywordIf(ctx, "SEQUENCE")) break;
                Sequence<?> oldName = ParserImpl.parseSequenceName(ctx);
                ParserImpl.parseKeyword(ctx, "TO");
                Sequence<?> newName = ParserImpl.parseSequenceName(ctx);
                return ctx.dsl.alterSequence(oldName).renameTo(newName);
            }
            case 'V': 
            case 'v': {
                if (!ParserImpl.parseKeywordIf(ctx, "VIEW")) break;
                Table<?> oldName = ParserImpl.parseTableName(ctx);
                ParserImpl.parseKeyword(ctx, "TO");
                Table<?> newName = ParserImpl.parseTableName(ctx);
                return ctx.dsl.alterView(oldName).renameTo(newName);
            }
        }
        ParserImpl.parseKeywordIf(ctx, "TABLE");
        Table<?> oldName = ParserImpl.parseTableName(ctx);
        ParserImpl.parseKeyword(ctx, "TO");
        Table<?> newName = ParserImpl.parseTableName(ctx);
        return ctx.dsl.alterTable(oldName).renameTo(newName);
    }

    private static final DDLQuery parseDropTable(ParserContext ctx) {
        DropTableStep s1;
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        boolean cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE");
        boolean restrict = !cascade && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
        DropTableStep dropTableStep = s1 = ifExists ? ctx.dsl.dropTableIfExists(tableName) : ctx.dsl.dropTable(tableName);
        DropTableFinalStep s2 = cascade ? s1.cascade() : (restrict ? s1.restrict() : s1);
        return s2;
    }

    private static final DDLQuery parseCreateSchema(ParserContext ctx) {
        boolean ifNotExists = ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Schema schemaName = ParserImpl.parseSchemaName(ctx);
        return ifNotExists ? ctx.dsl.createSchemaIfNotExists(schemaName) : ctx.dsl.createSchema(schemaName);
    }

    private static final DDLQuery parseAlterSchema(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Schema schemaName = ParserImpl.parseSchemaName(ctx);
        ParserImpl.parseKeyword(ctx, "RENAME TO");
        Schema newName = ParserImpl.parseSchemaName(ctx);
        AlterSchemaStep s1 = ifExists ? ctx.dsl.alterSchemaIfExists(schemaName) : ctx.dsl.alterSchema(schemaName);
        AlterSchemaFinalStep s2 = s1.renameTo(newName);
        return s2;
    }

    private static final DDLQuery parseDropSchema(ParserContext ctx) {
        DropSchemaStep s1;
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Schema schemaName = ParserImpl.parseSchemaName(ctx);
        boolean cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE");
        boolean restrict = !cascade && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
        DropSchemaStep dropSchemaStep = s1 = ifExists ? ctx.dsl.dropSchemaIfExists(schemaName) : ctx.dsl.dropSchema(schemaName);
        DropSchemaFinalStep s2 = cascade ? s1.cascade() : (restrict ? s1.restrict() : s1);
        return s2;
    }

    private static final DDLQuery parseCreateIndex(ParserContext ctx) {
        boolean ifNotExists = ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Name indexName = ParserImpl.parseIndexName(ctx);
        ParserImpl.parseKeyword(ctx, "ON");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        ParserImpl.parse(ctx, '(');
        Field<?>[] fieldNames = Tools.fieldsByName(ParserImpl.parseIdentifiers(ctx));
        ParserImpl.parse(ctx, ')');
        Condition condition = ParserImpl.parseKeywordIf(ctx, "WHERE") ? ParserImpl.parseCondition(ctx) : null;
        CreateIndexStep s1 = ifNotExists ? ctx.dsl.createIndexIfNotExists(indexName) : ctx.dsl.createIndex(indexName);
        CreateIndexWhereStep s2 = s1.on(tableName, fieldNames);
        CreateIndexWhereStep s3 = condition != null ? s2.where(condition) : s2;
        return s3;
    }

    private static final DDLQuery parseAlterIndex(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Name indexName = ParserImpl.parseIndexName(ctx);
        ParserImpl.parseKeyword(ctx, "RENAME TO");
        Name newName = ParserImpl.parseIndexName(ctx);
        AlterIndexStep s1 = ifExists ? ctx.dsl.alterIndexIfExists(indexName) : ctx.dsl.alterIndex(indexName);
        AlterIndexFinalStep s2 = s1.renameTo(newName);
        return s2;
    }

    private static final DDLQuery parseDropIndex(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Name indexName = ParserImpl.parseIndexName(ctx);
        boolean on = ParserImpl.parseKeywordIf(ctx, "ON");
        Table<?> onTable = on ? ParserImpl.parseTableName(ctx) : null;
        DropIndexOnStep s1 = ifExists ? ctx.dsl.dropIndexIfExists(indexName) : ctx.dsl.dropIndex(indexName);
        DropIndexOnStep s2 = on ? s1.on(onTable) : s1;
        return s2;
    }

    static final Condition parseCondition(ParserContext ctx) {
        Condition condition = ParserImpl.parseBooleanTerm(ctx);
        while (ParserImpl.parseKeywordIf(ctx, "OR")) {
            condition = condition.or(ParserImpl.parseBooleanTerm(ctx));
        }
        return condition;
    }

    private static final Condition parseBooleanTerm(ParserContext ctx) {
        Condition condition = ParserImpl.parseBooleanFactor(ctx);
        while (ParserImpl.parseKeywordIf(ctx, "AND")) {
            condition = condition.and(ParserImpl.parseBooleanFactor(ctx));
        }
        return condition;
    }

    private static final Condition parseBooleanFactor(ParserContext ctx) {
        boolean not = ParserImpl.parseKeywordIf(ctx, "NOT");
        Condition condition = ParserImpl.parseBooleanTest(ctx);
        return not ? condition.not() : condition;
    }

    private static final Condition parseBooleanTest(ParserContext ctx) {
        Condition condition = ParserImpl.parseBooleanPrimary(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "IS")) {
            Field<Boolean> field = DSL.field(condition);
            boolean not = ParserImpl.parseKeywordIf(ctx, "NOT");
            TruthValue truth = ParserImpl.parseTruthValue(ctx);
            switch (truth) {
                case FALSE: {
                    return not ? field.ne(DSL.inline(false)) : field.eq(DSL.inline(false));
                }
                case TRUE: {
                    return not ? field.ne(DSL.inline(true)) : field.eq(DSL.inline(true));
                }
                case NULL: {
                    return not ? field.isNotNull() : field.isNull();
                }
            }
            throw ctx.internalError();
        }
        return condition;
    }

    private static final Condition parseBooleanPrimary(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, '(')) {
            Condition result = ParserImpl.parseCondition(ctx);
            ParserImpl.parse(ctx, ')');
            return result;
        }
        TruthValue truth = ParserImpl.parseTruthValueIf(ctx);
        if (truth != null) {
            Comparator comp = ParserImpl.parseComparatorIf(ctx);
            switch (truth) {
                case TRUE: {
                    return comp == null ? DSL.condition(true) : DSL.inline(true).compare(comp, ParserImpl.parseField(ctx));
                }
                case FALSE: {
                    return comp == null ? DSL.condition(false) : DSL.inline(false).compare(comp, ParserImpl.parseField(ctx));
                }
                case NULL: {
                    return comp == null ? DSL.condition((Boolean)null) : DSL.inline((Boolean)null).compare(comp, ParserImpl.parseField(ctx));
                }
            }
            throw ctx.exception();
        }
        return ParserImpl.parsePredicate(ctx);
    }

    private static final Condition parsePredicate(ParserContext ctx) {
        Comparator comp;
        if (ParserImpl.parseKeywordIf(ctx, "EXISTS")) {
            ParserImpl.parse(ctx, '(');
            SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.exists(select);
        }
        Field<Field<?>> left = ParserImpl.parseFieldConcat(ctx, null);
        boolean not = ParserImpl.parseKeywordIf(ctx, "NOT");
        if (!not && (comp = ParserImpl.parseComparatorIf(ctx)) != null) {
            Condition result;
            boolean any;
            boolean all = ParserImpl.parseKeywordIf(ctx, "ALL");
            boolean bl = any = !all && (ParserImpl.parseKeywordIf(ctx, "ANY") || ParserImpl.parseKeywordIf(ctx, "SOME"));
            if (all || any) {
                ParserImpl.parse(ctx, '(');
            }
            Condition condition = all ? left.compare(comp, DSL.all(ParserImpl.parseSelect(ctx))) : (result = any ? left.compare(comp, DSL.any(ParserImpl.parseSelect(ctx))) : left.compare(comp, (Field<Field<?>>)ParserImpl.parseFieldConcat(ctx, null)));
            if (all || any) {
                ParserImpl.parse(ctx, ')');
            }
            return result;
        }
        if (!not && ParserImpl.parseKeywordIf(ctx, "IS")) {
            not = ParserImpl.parseKeywordIf(ctx, "NOT");
            if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
                return not ? left.isNotNull() : left.isNull();
            }
            ParserImpl.parseKeyword(ctx, "DISTINCT FROM");
            Field<?> right = ParserImpl.parseFieldConcat(ctx, null);
            return not ? left.isNotDistinctFrom((Field<Field<?>>)right) : left.isDistinctFrom((Field<Field<?>>)right);
        }
        if (ParserImpl.parseKeywordIf(ctx, "IN")) {
            ParserImpl.parse(ctx, '(');
            Condition result = ParserImpl.peekKeyword(ctx, "SELECT") ? (not ? left.notIn((Select<Record1<Field<?>>>)ParserImpl.parseSelect(ctx)) : left.in((Select<Record1<Field<?>>>)ParserImpl.parseSelect(ctx))) : (not ? left.notIn((Collection<?>)ParserImpl.parseFields(ctx)) : left.in((Collection<?>)ParserImpl.parseFields(ctx)));
            ParserImpl.parse(ctx, ')');
            return result;
        }
        if (ParserImpl.parseKeywordIf(ctx, "BETWEEN")) {
            boolean symmetric = ParserImpl.parseKeywordIf(ctx, "SYMMETRIC");
            Field<?> r1 = ParserImpl.parseFieldConcat(ctx, null);
            ParserImpl.parseKeyword(ctx, "AND");
            Field<?> r2 = ParserImpl.parseFieldConcat(ctx, null);
            return symmetric ? (not ? left.notBetweenSymmetric((Field<Field<?>>)r1, (Field<Field<?>>)r2) : left.betweenSymmetric((Field<Field<?>>)r1, (Field<Field<?>>)r2)) : (not ? left.notBetween((Field<Field<?>>)r1, (Field<Field<?>>)r2) : left.between((Field<Field<?>>)r1, (Field<Field<?>>)r2));
        }
        if (ParserImpl.parseKeywordIf(ctx, "LIKE")) {
            char character;
            Field<String> right = ParserImpl.parseFieldConcat(ctx, null);
            boolean escape = ParserImpl.parseKeywordIf(ctx, "ESCAPE");
            char c = character = escape ? (char)ParserImpl.parseCharacterLiteral(ctx) : (char)' ';
            return escape ? (not ? left.notLike(right, character) : left.like(right, character)) : (not ? left.notLike(right) : left.like(right));
        }
        throw ctx.exception();
    }

    private static final List<Table<?>> parseTables(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        ArrayList result = new ArrayList();
        do {
            result.add(ParserImpl.parseTable(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final Table<?> parseTable(ParserContext ctx) {
        Table<?> result = ParserImpl.parseTableFactor(ctx);
        Table<?> joined;
        while ((joined = ParserImpl.parseJoinedTableIf(ctx, result)) != null) {
            result = joined;
        }
        return result;
    }

    private static final Table<?> parseTableFactor(ParserContext ctx) {
        return ParserImpl.parseTablePrimary(ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Table<?> parseTablePrimary(ParserContext ctx) {
        Table<Attachable> result;
        block13: {
            result = null;
            if (ParserImpl.parseKeywordIf(ctx, "LATERAL")) {
                ParserImpl.parse(ctx, '(');
                result = DSL.lateral(ParserImpl.parseSelect(ctx));
                ParserImpl.parse(ctx, ')');
            } else {
                if (ParserImpl.parseKeywordIf(ctx, "UNNEST")) {
                    throw ctx.exception();
                }
                if (ParserImpl.parseIf(ctx, '(')) {
                    if (ParserImpl.peekKeyword(ctx, "SELECT")) {
                        result = DSL.table(ParserImpl.parseSelect(ctx));
                        ParserImpl.parse(ctx, ')');
                        break block13;
                    } else {
                        int parens = 0;
                        while (ParserImpl.parseIf(ctx, '(')) {
                            ++parens;
                        }
                        result = ParserImpl.parseJoinedTable(ctx);
                        while (true) {
                            if (parens-- <= 0) {
                                ParserImpl.parse(ctx, ')');
                                return result;
                            }
                            ParserImpl.parse(ctx, ')');
                        }
                    }
                }
                result = ParserImpl.parseTableName(ctx);
            }
        }
        String alias = null;
        List<String> columnAliases = null;
        if (ParserImpl.parseKeywordIf(ctx, "AS")) {
            alias = ParserImpl.parseIdentifier(ctx);
        } else if (!ParserImpl.peekKeyword(ctx, SELECT_KEYWORDS)) {
            alias = ParserImpl.parseIdentifierIf(ctx);
        }
        if (alias == null) return result;
        if (ParserImpl.parseIf(ctx, '(')) {
            columnAliases = ParserImpl.parseIdentifiers(ctx);
            ParserImpl.parse(ctx, ')');
        }
        if (columnAliases == null) return result.as(alias);
        return result.as(alias, columnAliases.toArray(Tools.EMPTY_STRING));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Table<?> parseJoinedTable(ParserContext ctx) {
        Table<?> result = ParserImpl.parseTableFactor(ctx);
        int i = 0;
        while (true) {
            Table<?> joined;
            if ((joined = ParserImpl.parseJoinedTableIf(ctx, result)) == null) {
                if (i != 0) return result;
                ctx.unexpectedToken();
            } else {
                result = joined;
            }
            ++i;
        }
    }

    private static final Table<?> parseJoinedTableIf(ParserContext ctx, Table<?> left) {
        TableOptionalOnStep<Record> result1;
        JoinType joinType = ParserImpl.parseJoinTypeIf(ctx);
        if (joinType == null) {
            return null;
        }
        Table<?> right = ParserImpl.parseTableFactor(ctx);
        Table<Record> result2 = result1 = left.join(right, joinType);
        switch (joinType) {
            case JOIN: 
            case LEFT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case OUTER_APPLY: {
                boolean on = ParserImpl.parseKeywordIf(ctx, "ON");
                if (on) {
                    result2 = result1.on(ParserImpl.parseCondition(ctx));
                    break;
                }
                ParserImpl.parseKeyword(ctx, "USING");
                ParserImpl.parse(ctx, '(');
                result2 = result1.using(Tools.fieldsByName(ParserImpl.parseIdentifiers(ctx).toArray(Tools.EMPTY_STRING)));
                ParserImpl.parse(ctx, ')');
                break;
            }
        }
        return result2;
    }

    private static final List<Field<?>> parseSelectList(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        if (ParserImpl.parseIf(ctx, '*')) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        do {
            Field<?> field = ParserImpl.parseField(ctx);
            String alias = null;
            if (ParserImpl.parseKeywordIf(ctx, "AS")) {
                alias = ParserImpl.parseIdentifier(ctx);
            } else if (!ParserImpl.peekKeyword(ctx, SELECT_KEYWORDS)) {
                alias = ParserImpl.parseIdentifierIf(ctx);
            }
            result.add(alias == null ? field : field.as(alias));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final List<SortField<?>> parseSortSpecification(ParserContext ctx) {
        ArrayList result = new ArrayList();
        do {
            SortField<?> sort;
            Field<?> field = ParserImpl.parseField(ctx);
            if (ParserImpl.parseKeywordIf(ctx, "DESC")) {
                sort = field.desc();
            } else {
                if (!ParserImpl.parseKeywordIf(ctx, "ASC")) {
                    // empty if block
                }
                sort = field.asc();
            }
            if (ParserImpl.parseKeywordIf(ctx, "NULLS FIRST")) {
                sort = sort.nullsFirst();
            } else if (ParserImpl.parseKeywordIf(ctx, "NULLS LAST")) {
                sort = sort.nullsLast();
            }
            result.add(sort);
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final List<Field<?>> parseFields(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        ArrayList result = new ArrayList();
        do {
            result.add(ParserImpl.parseField(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    static final Field<?> parseField(ParserContext ctx) {
        return ParserImpl.parseField(ctx, null);
    }

    private static final Field<?> parseField(ParserContext ctx, Type type) {
        if (Type.B.is(type)) {
            Field<Boolean> r = ParserImpl.parseFieldAnd(ctx);
            Condition c = null;
            while (ParserImpl.parseKeywordIf(ctx, "OR")) {
                c = (c == null ? DSL.condition(r) : c).or(ParserImpl.parseFieldAnd(ctx));
            }
            return c == null ? r : DSL.field(c);
        }
        return ParserImpl.parseFieldConcat(ctx, type);
    }

    private static final Field<?> parseFieldConcat(ParserContext ctx, Type type) {
        Field<Object> r = ParserImpl.parseFieldSum(ctx, type);
        if (Type.S.is(type)) {
            while (ParserImpl.parseIf(ctx, "||")) {
                r = DSL.concat(r, ParserImpl.parseFieldSum(ctx, type));
            }
        }
        return r;
    }

    private static final Field<?> parseFieldSumParenthesised(ParserContext ctx) {
        ParserImpl.parse(ctx, '(');
        Field<?> r = ParserImpl.parseFieldSum(ctx, Type.N);
        ParserImpl.parse(ctx, ')');
        return r;
    }

    private static final Field<?> parseFieldSum(ParserContext ctx, Type type) {
        Field<?> r = ParserImpl.parseFieldFactor(ctx, type);
        if (Type.N.is(type)) {
            while (true) {
                if (ParserImpl.parseIf(ctx, '+')) {
                    r = r.add(ParserImpl.parseFieldFactor(ctx, type));
                    continue;
                }
                if (!ParserImpl.parseIf(ctx, '-')) break;
                r = r.sub(ParserImpl.parseFieldFactor(ctx, type));
            }
        }
        return r;
    }

    private static final Field<?> parseFieldFactor(ParserContext ctx, Type type) {
        Field<?> r = ParserImpl.parseFieldTerm(ctx, type);
        if (Type.N.is(type)) {
            while (true) {
                if (ParserImpl.parseIf(ctx, '*')) {
                    r = r.mul(ParserImpl.parseFieldTerm(ctx, type));
                    continue;
                }
                if (ParserImpl.parseIf(ctx, '/')) {
                    r = r.div(ParserImpl.parseFieldTerm(ctx, type));
                    continue;
                }
                if (!ParserImpl.parseIf(ctx, '%')) break;
                r = r.mod(ParserImpl.parseFieldTerm(ctx, type));
            }
        }
        return r;
    }

    private static final Field<?> parseFieldAnd(ParserContext ctx) {
        Field<Boolean> r = ParserImpl.parseFieldCondition(ctx);
        Condition c = null;
        while (ParserImpl.parseKeywordIf(ctx, "AND")) {
            c = (c == null ? DSL.condition(r) : c).and(ParserImpl.parseFieldCondition(ctx));
        }
        return c == null ? r : DSL.field(c);
    }

    private static final Field<?> parseFieldCondition(ParserContext ctx) {
        return ParserImpl.parseFieldConcat(ctx, null);
    }

    private static final Field<?> parseFieldTerm(ParserContext ctx, Type type) {
        Field<Object> field;
        ParserImpl.parseWhitespaceIf(ctx);
        switch (ctx.character()) {
            case ':': 
            case '?': {
                return ParserImpl.parseBindVariable(ctx);
            }
            case '\'': {
                return DSL.inline(ParserImpl.parseStringLiteral(ctx));
            }
            case 'A': 
            case 'a': {
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldAsciiIf(ctx);
                if (field != null) {
                    return field;
                }
                if (ParserImpl.parseKeywordIf(ctx, "ACOS")) {
                    return DSL.acos(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "ASIN")) {
                    return DSL.asin(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "ATAN")) {
                    return DSL.atan(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                field = ParserImpl.parseFieldAtan2If(ctx);
                if (field == null) break;
                return field;
            }
            case 'B': 
            case 'b': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldBitLengthIf(ctx)) == null) break;
                return field;
            }
            case 'C': 
            case 'c': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldConcatIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_SCHEMA")) {
                        return DSL.currentSchema();
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_USER")) {
                        return DSL.currentUser();
                    }
                }
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldCharIndexIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldCharLengthIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CEILING") || ParserImpl.parseKeywordIf(ctx, "CEIL")) {
                        return DSL.ceil(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "COSH")) {
                        return DSL.cosh(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "COS")) {
                        return DSL.cos(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "COTH")) {
                        return DSL.coth(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "COT")) {
                        return DSL.cot(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                }
                if (Type.D.is(type)) {
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_TIMESTAMP")) {
                        return DSL.currentTimestamp();
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_TIME")) {
                        return DSL.currentTime();
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_DATE")) {
                        return DSL.currentDate();
                    }
                }
                if ((field = ParserImpl.parseFieldCaseIf(ctx)) != null) {
                    return field;
                }
                field = ParserImpl.parseCastIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldCoalesceIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldCumeDistIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'D': 
            case 'd': {
                if (Type.D.is(type) && (field = ParserImpl.parseFieldDateLiteralIf(ctx)) != null) {
                    return field;
                }
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldDenseRankIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldDayIf(ctx);
                if (field != null) {
                    return field;
                }
                if (!ParserImpl.parseKeywordIf(ctx, "DEGREE") && !ParserImpl.parseKeywordIf(ctx, "DEG")) break;
                return DSL.deg(ParserImpl.parseFieldSumParenthesised(ctx));
            }
            case 'E': 
            case 'e': {
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldExtractIf(ctx);
                if (field != null) {
                    return field;
                }
                if (!ParserImpl.parseKeywordIf(ctx, "EXP")) break;
                return DSL.exp(ParserImpl.parseFieldSumParenthesised(ctx));
            }
            case 'F': 
            case 'f': {
                if (Type.N.is(type) && ParserImpl.parseKeywordIf(ctx, "FLOOR")) {
                    return DSL.floor(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                field = ParserImpl.parseFieldFirstValueIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'G': 
            case 'g': {
                field = ParserImpl.parseFieldGreatestIf(ctx);
                if (field != null) {
                    return field;
                }
                if (Type.N.is(type) && (field = ParserImpl.parseFieldGroupingIdIf(ctx)) != null) {
                    return field;
                }
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldGroupingIf(ctx)) == null) break;
                return field;
            }
            case 'H': 
            case 'h': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldHourIf(ctx)) == null) break;
                return field;
            }
            case 'I': 
            case 'i': {
                if (Type.N.is(type) && (field = ParserImpl.parseFieldInstrIf(ctx)) != null) {
                    return field;
                }
                field = ParserImpl.parseFieldIfnullIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldIsnullIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'L': 
            case 'l': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldLowerIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldLpadIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldLtrimIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldLeftIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldLengthIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "LN")) {
                        return DSL.ln(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    field = ParserImpl.parseFieldLogIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "LEVEL")) {
                        return DSL.level();
                    }
                }
                if ((field = ParserImpl.parseFieldLeastIf(ctx)) != null) {
                    return field;
                }
                field = ParserImpl.parseFieldLeadLagIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldLastValueIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'M': 
            case 'm': {
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldModIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldMonthIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldMinuteIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!Type.S.is(type)) break;
                field = ParserImpl.parseFieldMidIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldMd5If(ctx);
                if (field == null) break;
                return field;
            }
            case 'N': 
            case 'n': {
                field = ParserImpl.parseFieldNvl2If(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNvlIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNullifIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNtileIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNthValueIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'O': 
            case 'o': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldOctetLengthIf(ctx)) == null) break;
                return field;
            }
            case 'P': 
            case 'p': {
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldPositionIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldPercentRankIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldPowerIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!ParserImpl.parseKeywordIf(ctx, "PRIOR")) break;
                return DSL.prior(ParserImpl.parseField(ctx));
            }
            case 'R': 
            case 'r': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldReplaceIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRepeatIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldReverseIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRpadIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRtrimIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRightIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldRowNumberIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldRankIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldRoundIf(ctx);
                if (field != null) {
                    return field;
                }
                if (ParserImpl.parseKeywordIf(ctx, "ROWNUM")) {
                    return DSL.rownum();
                }
                if (!ParserImpl.parseKeywordIf(ctx, "RADIAN") && !ParserImpl.parseKeywordIf(ctx, "RAD")) break;
                return DSL.rad(ParserImpl.parseFieldSumParenthesised(ctx));
            }
            case 'S': 
            case 's': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldSubstringIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldSpaceIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldSecondIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldSignIf(ctx);
                if (field != null) {
                    return field;
                }
                if (ParserImpl.parseKeywordIf(ctx, "SQRT") || ParserImpl.parseKeywordIf(ctx, "SQR")) {
                    return DSL.sqrt(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "SINH")) {
                    return DSL.sinh(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                if (!ParserImpl.parseKeywordIf(ctx, "SIN")) break;
                return DSL.sin(ParserImpl.parseFieldSumParenthesised(ctx));
            }
            case 'T': 
            case 't': {
                if (Type.S.is(type) && (field = ParserImpl.parseFieldTrimIf(ctx)) != null) {
                    return field;
                }
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldTruncIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "TANH")) {
                        return DSL.tanh(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "TAN")) {
                        return DSL.tan(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                }
                if (!Type.D.is(type)) break;
                field = ParserImpl.parseFieldTimestampLiteralIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldTimeLiteralIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'U': 
            case 'u': {
                if (!Type.S.is(type) || (field = ParserImpl.parseFieldUpperIf(ctx)) == null) break;
                return field;
            }
            case 'Y': 
            case 'y': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldYearIf(ctx)) == null) break;
                return field;
            }
            case '+': {
                ParserImpl.parse(ctx, '+');
                if (!Type.N.is(type)) break;
                return ParserImpl.parseFieldTerm(ctx, type);
            }
            case '-': {
                ParserImpl.parse(ctx, '-');
                if (!Type.N.is(type)) break;
                Field<?> field2 = ParserImpl.parseFieldUnsignedNumericLiteralIf(ctx, true);
                if (field2 != null) {
                    return field2;
                }
                return ParserImpl.parseFieldTerm(ctx, type).neg();
            }
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldUnsignedNumericLiteralIf(ctx, false)) == null) break;
                return field;
            }
            case '(': {
                ParserImpl.parse(ctx, '(');
                if (ParserImpl.peekKeyword(ctx, "SELECT")) {
                    SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
                    if (select.getSelect().size() > 1) {
                        throw ctx.exception();
                    }
                    Field field3 = DSL.field(select);
                    ParserImpl.parse(ctx, ')');
                    return field3;
                }
                Field<?> r = ParserImpl.parseField(ctx, type);
                ParserImpl.parse(ctx, ')');
                return r;
            }
        }
        field = ParserImpl.parseAggregateFunctionIf(ctx);
        if (field != null) {
            return field;
        }
        field = ParserImpl.parseBooleanValueExpressionIf(ctx);
        if (field != null) {
            return field;
        }
        return ParserImpl.parseFieldName(ctx);
    }

    private static final Field<?> parseFieldAtan2If(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "ATN2") || ParserImpl.parseKeywordIf(ctx, "ATAN2")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.parseFieldSum(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.parseFieldSum(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.atan2(x, y);
        }
        return null;
    }

    private static final Field<?> parseFieldLogIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LOG")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg1 = ParserImpl.parseFieldSum(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            long arg2 = ParserImpl.parseUnsignedInteger(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.log(arg1, (int)arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldTruncIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "TRUNC")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg1 = ParserImpl.parseFieldSum(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<Integer> arg2 = ParserImpl.parseFieldSum(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.trunc(arg1, arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldRoundIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "ROUND")) {
            Field<?> arg1 = null;
            Integer arg2 = null;
            ParserImpl.parse(ctx, '(');
            arg1 = ParserImpl.parseFieldSum(ctx, Type.N);
            if (ParserImpl.parseIf(ctx, ',')) {
                arg2 = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            }
            ParserImpl.parse(ctx, ')');
            return arg2 == null ? DSL.round(arg1) : DSL.round(arg1, (int)arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldPowerIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "POWER") || ParserImpl.parseKeywordIf(ctx, "POW")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg1 = ParserImpl.parseFieldSum(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> arg2 = ParserImpl.parseFieldSum(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.power(arg1, arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldModIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "MOD")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return f1.mod(f2);
        }
        return null;
    }

    private static Field<?> parseFieldLeastIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LEAST")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.least(fields.get(0), fields.size() > 1 ? fields.subList(1, fields.size()).toArray(Tools.EMPTY_FIELD) : Tools.EMPTY_FIELD);
        }
        return null;
    }

    private static Field<?> parseFieldGreatestIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "GREATEST")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.greatest(fields.get(0), fields.size() > 1 ? fields.subList(1, fields.size()).toArray(Tools.EMPTY_FIELD) : Tools.EMPTY_FIELD);
        }
        return null;
    }

    private static final Field<?> parseFieldGroupingIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "GROUPING")) {
            ParserImpl.parse(ctx, '(');
            Field<?> field = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.grouping(field);
        }
        return null;
    }

    private static final Field<?> parseFieldGroupingIdIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "GROUPING_ID")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.groupingId(fields.toArray(Tools.EMPTY_FIELD));
        }
        return null;
    }

    private static final Field<?> parseFieldTimestampLiteralIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "TIMESTAMP")) {
            if (ParserImpl.parseKeywordIf(ctx, "WITHOUT TIME ZONE")) {
                return DSL.inline(ParserImpl.parseTimestampLiteral(ctx));
            }
            if (ParserImpl.parseIf(ctx, '(')) {
                Field<?> f = ParserImpl.parseField(ctx, Type.S);
                ParserImpl.parse(ctx, ')');
                return DSL.timestamp(f);
            }
            return DSL.inline(ParserImpl.parseTimestampLiteral(ctx));
        }
        return null;
    }

    private static final Timestamp parseTimestampLiteral(ParserContext ctx) {
        try {
            return Timestamp.valueOf(ParserImpl.parseStringLiteral(ctx));
        }
        catch (IllegalArgumentException e) {
            throw ctx.exception();
        }
    }

    private static final Field<?> parseFieldTimeLiteralIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "TIME")) {
            if (ParserImpl.parseKeywordIf(ctx, "WITHOUT TIME ZONE")) {
                return DSL.inline(ParserImpl.parseTimeLiteral(ctx));
            }
            if (ParserImpl.parseIf(ctx, '(')) {
                Field<?> f = ParserImpl.parseField(ctx, Type.S);
                ParserImpl.parse(ctx, ')');
                return DSL.time(f);
            }
            return DSL.inline(ParserImpl.parseTimeLiteral(ctx));
        }
        return null;
    }

    private static final Time parseTimeLiteral(ParserContext ctx) {
        try {
            return Time.valueOf(ParserImpl.parseStringLiteral(ctx));
        }
        catch (IllegalArgumentException e) {
            throw ctx.exception();
        }
    }

    private static final Field<?> parseFieldDateLiteralIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "DATE")) {
            if (ParserImpl.parseIf(ctx, '(')) {
                Field<?> f = ParserImpl.parseField(ctx, Type.S);
                ParserImpl.parse(ctx, ')');
                return DSL.date(f);
            }
            return DSL.inline(ParserImpl.parseDateLiteral(ctx));
        }
        return null;
    }

    private static final Date parseDateLiteral(ParserContext ctx) {
        try {
            return Date.valueOf(ParserImpl.parseStringLiteral(ctx));
        }
        catch (IllegalArgumentException e) {
            throw ctx.exception();
        }
    }

    private static final Field<?> parseFieldExtractIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "EXTRACT")) {
            ParserImpl.parse(ctx, '(');
            DatePart part = ParserImpl.parseDatePart(ctx);
            ParserImpl.parseKeyword(ctx, "FROM");
            Field<?> field = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.extract(field, part);
        }
        return null;
    }

    private static final DatePart parseDatePart(ParserContext ctx) {
        for (DatePart part : DatePart.values()) {
            if (!ParserImpl.parseKeywordIf(ctx, part.name())) continue;
            return part;
        }
        throw ctx.unexpectedToken();
    }

    private static final Field<?> parseFieldAsciiIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "ASCII")) {
            ParserImpl.parse(ctx, '(');
            Field<String> arg = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.ascii(arg);
        }
        return null;
    }

    private static final Field<?> parseFieldConcatIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CONCAT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> result = DSL.concat(ParserImpl.parseFields(ctx).toArray(Tools.EMPTY_FIELD));
            ParserImpl.parse(ctx, ')');
            return result;
        }
        return null;
    }

    private static final Field<?> parseFieldInstrIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "INSTR")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.position(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldCharIndexIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CHARINDEX")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.position(f2, f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLpadIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LPAD")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            Field<String> f3 = ParserImpl.parseIf(ctx, ',') ? ParserImpl.parseField(ctx, Type.S) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.lpad(f1, f2) : DSL.lpad(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldRpadIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "RPAD")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            Field<String> f3 = ParserImpl.parseIf(ctx, ',') ? ParserImpl.parseField(ctx, Type.S) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.rpad(f1, f2) : DSL.rpad(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldPositionIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "POSITION")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parseKeyword(ctx, "IN");
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.position(f2, f1);
        }
        return null;
    }

    private static final Field<?> parseFieldRepeatIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "REPEAT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> field = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> count = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.repeat(field, count);
        }
        return null;
    }

    private static final Field<?> parseFieldReplaceIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "REPLACE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            Field<String> f3 = ParserImpl.parseIf(ctx, ',') ? ParserImpl.parseField(ctx, Type.S) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.replace(f1, f2) : DSL.replace(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldReverseIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "REVERSE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.reverse(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSpaceIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "SPACE")) {
            ParserImpl.parse(ctx, '(');
            Field<Integer> f1 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.space(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSubstringIf(ParserContext ctx) {
        boolean substr;
        boolean substring = ParserImpl.parseKeywordIf(ctx, "SUBSTRING");
        boolean bl = substr = !substring && ParserImpl.parseKeywordIf(ctx, "SUBSTR");
        if (substring || substr) {
            boolean keywords = !substr;
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseFieldConcat(ctx, Type.S);
            if (substr || !(keywords = ParserImpl.parseKeywordIf(ctx, "FROM"))) {
                ParserImpl.parse(ctx, ',');
            }
            Field<?> f2 = ParserImpl.parseFieldSum(ctx, Type.N);
            Field<?> f3 = keywords && ParserImpl.parseKeywordIf(ctx, "FOR") || !keywords && ParserImpl.parseIf(ctx, ',') ? ParserImpl.parseFieldSum(ctx, Type.N) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.substring(f1, f2) : DSL.substring(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldTrimIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "TRIM")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.trim(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldRtrimIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "RTRIM")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.rtrim(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLtrimIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LTRIM")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.ltrim(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldMidIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "MID")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> f3 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.mid(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldLeftIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LEFT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.left(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldRightIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "RIGHT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.right(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldMd5If(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "MD5")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.md5(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLengthIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LENGTH")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.length(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldCharLengthIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CHAR_LENGTH")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.charLength(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldBitLengthIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "BIT_LENGTH")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.bitLength(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldOctetLengthIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "OCTET_LENGTH")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.octetLength(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLowerIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LOWER")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.lower(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldUpperIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "UPPER")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.upper(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldYearIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "YEAR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.year(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldMonthIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "MONTH")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.month(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldDayIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "DAY")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.day(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldHourIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "HOUR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.hour(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldMinuteIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "MINUTE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.minute(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSecondIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "SECOND")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.second(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSignIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "SIGN")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.sign(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldIfnullIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "IFNULL")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.ifnull(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldIsnullIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "ISNULL")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.isnull(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldNvlIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "NVL")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.nvl(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldNvl2If(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "NVL2")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f3 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.nvl2(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldNullifIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "NULLIF")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.nullif(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldCoalesceIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "COALESCE")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            Field<?>[] a = Tools.EMPTY_FIELD;
            return DSL.coalesce(fields.get(0), fields.size() == 1 ? a : fields.subList(1, fields.size()).toArray(a));
        }
        return null;
    }

    private static final Field<?> parseFieldCaseIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CASE")) {
            if (ParserImpl.parseKeywordIf(ctx, "WHEN")) {
                CaseConditionStep<?> step = null;
                do {
                    Condition condition = ParserImpl.parseCondition(ctx);
                    ParserImpl.parseKeyword(ctx, "THEN");
                    Field<?> value = ParserImpl.parseField(ctx);
                    CaseConditionStep<?> caseConditionStep = step = step == null ? DSL.when(condition, value) : step.when(condition, value);
                } while (ParserImpl.parseKeywordIf(ctx, "WHEN"));
                Field<?> result = ParserImpl.parseKeywordIf(ctx, "ELSE") ? step.otherwise(ParserImpl.parseField(ctx)) : step;
                ParserImpl.parseKeyword(ctx, "END");
                return result;
            }
            CaseValueStep<?> init = DSL.choose(ParserImpl.parseField(ctx));
            CaseWhenStep<?, ?> step = null;
            ParserImpl.parseKeyword(ctx, "WHEN");
            do {
                Field<?> when = ParserImpl.parseField(ctx);
                ParserImpl.parseKeyword(ctx, "THEN");
                Field<?> then = ParserImpl.parseField(ctx);
                CaseWhenStep<?, ?> caseWhenStep = step = step == null ? init.when(when, then) : step.when(when, then);
            } while (ParserImpl.parseKeywordIf(ctx, "WHEN"));
            Field<Object> result = ParserImpl.parseKeywordIf(ctx, "ELSE") ? step.otherwise(ParserImpl.parseField(ctx)) : step;
            ParserImpl.parseKeyword(ctx, "END");
            return result;
        }
        return null;
    }

    private static final Field<?> parseCastIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CAST")) {
            ParserImpl.parse(ctx, '(');
            Field<?> field = ParserImpl.parseField(ctx);
            ParserImpl.parseKeyword(ctx, "AS");
            DataType<?> type = ParserImpl.parseDataType(ctx);
            return DSL.cast(field, type);
        }
        return null;
    }

    private static final Field<Boolean> parseBooleanValueExpressionIf(ParserContext ctx) {
        TruthValue truth = ParserImpl.parseTruthValueIf(ctx);
        if (truth != null) {
            switch (truth) {
                case TRUE: {
                    return DSL.inline(true);
                }
                case FALSE: {
                    return DSL.inline(false);
                }
                case NULL: {
                    return DSL.inline((Boolean)null);
                }
            }
            throw ctx.exception();
        }
        return null;
    }

    private static final Field<?> parseAggregateFunctionIf(ParserContext ctx) {
        Field<Object> result;
        WindowBeforeOverStep<Object> over;
        AggregateFunction<?> agg = ParserImpl.parseCountIf(ctx);
        if (agg == null) {
            agg = ParserImpl.parseGeneralSetFunctionIf(ctx);
        }
        if (agg == null) {
            agg = ParserImpl.parseBinarySetFunctionIf(ctx);
        }
        if (agg == null) {
            return null;
        }
        if (ParserImpl.parseKeywordIf(ctx, "FILTER")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parseKeyword(ctx, "WHERE");
            Condition filter = ParserImpl.parseCondition(ctx);
            ParserImpl.parse(ctx, ')');
            result = over = agg.filterWhere(filter);
        } else {
            result = over = agg;
        }
        if (ParserImpl.parseKeywordIf(ctx, "OVER")) {
            Object nameOrSpecification = ParserImpl.parseWindowNameOrSpecification(ctx);
            result = nameOrSpecification instanceof Name ? over.over((Name)nameOrSpecification) : (nameOrSpecification instanceof WindowSpecification ? over.over((WindowSpecification)nameOrSpecification) : over.over());
        }
        return result;
    }

    private static Object parseWindowNameOrSpecification(ParserContext ctx) {
        QueryPart result;
        if (ParserImpl.parseIf(ctx, '(')) {
            WindowSpecificationOrderByStep s1 = null;
            WindowSpecificationOrderByStep s2 = null;
            WindowSpecificationRowsAndStep s3 = null;
            WindowSpecificationOrderByStep windowSpecificationOrderByStep = s1 = ParserImpl.parseKeywordIf(ctx, "PARTITION BY") ? DSL.partitionBy(ParserImpl.parseFields(ctx)) : null;
            s2 = ParserImpl.parseKeywordIf(ctx, "ORDER BY") ? (s1 == null ? DSL.orderBy(ParserImpl.parseSortSpecification(ctx)) : s1.orderBy(ParserImpl.parseSortSpecification(ctx))) : s1;
            boolean rows = ParserImpl.parseKeywordIf(ctx, "ROWS");
            if (rows || ParserImpl.parseKeywordIf(ctx, "RANGE")) {
                if (ParserImpl.parseKeywordIf(ctx, "BETWEEN")) {
                    int number;
                    if (ParserImpl.parseKeywordIf(ctx, "UNBOUNDED")) {
                        if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                            s3 = s2 == null ? (rows ? DSL.rowsBetweenUnboundedPreceding() : DSL.rangeBetweenUnboundedPreceding()) : (rows ? s2.rowsBetweenUnboundedPreceding() : s2.rangeBetweenUnboundedPreceding());
                        } else {
                            ParserImpl.parseKeyword(ctx, "FOLLOWING");
                            s3 = s2 == null ? (rows ? DSL.rowsBetweenUnboundedFollowing() : DSL.rangeBetweenUnboundedFollowing()) : (rows ? s2.rowsBetweenUnboundedFollowing() : s2.rangeBetweenUnboundedFollowing());
                        }
                    } else if (ParserImpl.parseKeywordIf(ctx, "CURRENT ROW")) {
                        s3 = s2 == null ? (rows ? DSL.rowsBetweenCurrentRow() : DSL.rangeBetweenCurrentRow()) : (rows ? s2.rowsBetweenCurrentRow() : s2.rangeBetweenCurrentRow());
                    } else {
                        number = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
                        if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                            s3 = s2 == null ? (rows ? DSL.rowsBetweenPreceding(number) : DSL.rangeBetweenPreceding(number)) : (rows ? s2.rowsBetweenPreceding(number) : s2.rangeBetweenPreceding(number));
                        } else {
                            ParserImpl.parseKeyword(ctx, "FOLLOWING");
                            s3 = s2 == null ? (rows ? DSL.rowsBetweenFollowing(number) : DSL.rangeBetweenFollowing(number)) : (rows ? s2.rowsBetweenFollowing(number) : s2.rangeBetweenFollowing(number));
                        }
                    }
                    ParserImpl.parseKeyword(ctx, "AND");
                    if (ParserImpl.parseKeywordIf(ctx, "UNBOUNDED")) {
                        if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                            result = s3.andUnboundedPreceding();
                        } else {
                            ParserImpl.parseKeyword(ctx, "FOLLOWING");
                            result = s3.andUnboundedFollowing();
                        }
                    } else if (ParserImpl.parseKeywordIf(ctx, "CURRENT ROW")) {
                        result = s3.andCurrentRow();
                    } else {
                        number = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
                        if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                            result = s3.andPreceding(number);
                        } else {
                            ParserImpl.parseKeyword(ctx, "FOLLOWING");
                            result = s3.andFollowing(number);
                        }
                    }
                } else if (ParserImpl.parseKeywordIf(ctx, "UNBOUNDED")) {
                    if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                        result = s2 == null ? (rows ? DSL.rowsUnboundedPreceding() : DSL.rangeUnboundedPreceding()) : (rows ? s2.rowsUnboundedPreceding() : s2.rangeUnboundedPreceding());
                    } else {
                        ParserImpl.parseKeyword(ctx, "FOLLOWING");
                        result = s2 == null ? (rows ? DSL.rowsUnboundedFollowing() : DSL.rangeUnboundedFollowing()) : (rows ? s2.rowsUnboundedFollowing() : s2.rangeUnboundedFollowing());
                    }
                } else if (ParserImpl.parseKeywordIf(ctx, "CURRENT ROW")) {
                    result = s2 == null ? (rows ? DSL.rowsCurrentRow() : DSL.rangeCurrentRow()) : (rows ? s2.rowsCurrentRow() : s2.rangeCurrentRow());
                } else {
                    int number = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
                    if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                        result = s2 == null ? (rows ? DSL.rowsPreceding(number) : DSL.rangePreceding(number)) : (rows ? s2.rowsPreceding(number) : s2.rangePreceding(number));
                    } else {
                        ParserImpl.parseKeyword(ctx, "FOLLOWING");
                        result = s2 == null ? (rows ? DSL.rowsFollowing(number) : DSL.rangeFollowing(number)) : (rows ? s2.rowsFollowing(number) : s2.rangeFollowing(number));
                    }
                }
            } else {
                result = s2;
            }
            ParserImpl.parse(ctx, ')');
        } else {
            result = DSL.name(ParserImpl.parseIdentifier(ctx));
        }
        return result;
    }

    private static final Field<?> parseFieldRankIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "RANK")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.rank());
        }
        return null;
    }

    private static final Field<?> parseFieldDenseRankIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "DENSE_RANK")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.denseRank());
        }
        return null;
    }

    private static final Field<?> parseFieldPercentRankIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "PERCENT_RANK")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.percentRank());
        }
        return null;
    }

    private static final Field<?> parseFieldCumeDistIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CUME_DIST")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.cumeDist());
        }
        return null;
    }

    private static final Field<?> parseFieldRowNumberIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "ROW_NUMBER")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.rowNumber());
        }
        return null;
    }

    private static final Field<?> parseFieldNtileIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "NTILE")) {
            ParserImpl.parse(ctx, '(');
            int number = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.ntile(number));
        }
        return null;
    }

    private static final Field<?> parseFieldLeadLagIf(ParserContext ctx) {
        boolean lag;
        boolean lead = ParserImpl.parseKeywordIf(ctx, "LEAD");
        boolean bl = lag = !lead && ParserImpl.parseKeywordIf(ctx, "LAG");
        if (lead || lag) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            Integer f2 = null;
            Field<?> f3 = null;
            if (ParserImpl.parseIf(ctx, ',')) {
                f2 = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
                if (ParserImpl.parseIf(ctx, ',')) {
                    f3 = ParserImpl.parseField(ctx);
                }
            }
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, lead ? (f2 == null ? DSL.lead(f1) : (f3 == null ? DSL.lead(f1, f2) : DSL.lead(f1, (int)f2, f3))) : (f2 == null ? DSL.lag(f1) : (f3 == null ? DSL.lag(f1, f2) : DSL.lag(f1, (int)f2, f3))), null);
        }
        return null;
    }

    private static final Field<?> parseFieldFirstValueIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "FIRST_VALUE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, DSL.firstValue(arg), null);
        }
        return null;
    }

    private static final Field<?> parseFieldLastValueIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LAST_VALUE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, DSL.lastValue(arg), null);
        }
        return null;
    }

    private static final Field<?> parseFieldNthValueIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "NTH_VALUE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            int f2 = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, DSL.nthValue(f1, f2), null);
        }
        return null;
    }

    private static final Field<?> parseWindowFunction(ParserContext ctx, WindowIgnoreNullsStep s1, WindowOverStep<?> s2) {
        if (s1 != null) {
            s2 = s1;
        }
        ParserImpl.parseKeyword(ctx, "OVER");
        Object nameOrSpecification = ParserImpl.parseWindowNameOrSpecification(ctx);
        WindowFinalStep result = nameOrSpecification instanceof Name ? s2.over((Name)nameOrSpecification) : (nameOrSpecification instanceof WindowSpecification ? s2.over((WindowSpecification)nameOrSpecification) : s2.over());
        return result;
    }

    private static final AggregateFunction<?> parseBinarySetFunctionIf(ParserContext ctx) {
        BinarySetFunctionType type = ParserImpl.parseBinarySetFunctionTypeIf(ctx);
        if (type == null) {
            return null;
        }
        ParserImpl.parse(ctx, '(');
        Field<?> arg1 = ParserImpl.parseFieldSum(ctx, Type.N);
        ParserImpl.parse(ctx, ',');
        Field<?> arg2 = ParserImpl.parseFieldSum(ctx, Type.N);
        ParserImpl.parse(ctx, ')');
        switch (type) {
            case REGR_AVGX: {
                return DSL.regrAvgX(arg1, arg2);
            }
            case REGR_AVGY: {
                return DSL.regrAvgY(arg1, arg2);
            }
            case REGR_COUNT: {
                return DSL.regrCount(arg1, arg2);
            }
            case REGR_INTERCEPT: {
                return DSL.regrIntercept(arg1, arg2);
            }
            case REGR_R2: {
                return DSL.regrR2(arg1, arg2);
            }
            case REGR_SLOPE: {
                return DSL.regrSlope(arg1, arg2);
            }
            case REGR_SXX: {
                return DSL.regrSXX(arg1, arg2);
            }
            case REGR_SXY: {
                return DSL.regrSXY(arg1, arg2);
            }
            case REGR_SYY: {
                return DSL.regrSYY(arg1, arg2);
            }
        }
        throw ctx.exception();
    }

    private static final AggregateFunction<?> parseGeneralSetFunctionIf(ParserContext ctx) {
        ComputationalOperation operation = ParserImpl.parseComputationalOperationIf(ctx);
        if (operation == null) {
            return null;
        }
        ParserImpl.parse(ctx, '(');
        boolean distinct = ParserImpl.parseSetQuantifier(ctx);
        Field<Boolean> arg = ParserImpl.parseField(ctx);
        ParserImpl.parse(ctx, ')');
        switch (operation) {
            case AVG: {
                return distinct ? DSL.avgDistinct(arg) : DSL.avg(arg);
            }
            case MAX: {
                return distinct ? DSL.maxDistinct(arg) : DSL.max(arg);
            }
            case MIN: {
                return distinct ? DSL.minDistinct(arg) : DSL.min(arg);
            }
            case SUM: {
                return distinct ? DSL.sumDistinct(arg) : DSL.sum(arg);
            }
            case EVERY: {
                return DSL.every(arg);
            }
            case ANY: {
                return DSL.boolOr(arg);
            }
            case STDDEV_POP: {
                return DSL.stddevPop(arg);
            }
            case STDDEV_SAMP: {
                return DSL.stddevSamp(arg);
            }
            case VAR_POP: {
                return DSL.varPop(arg);
            }
            case VAR_SAMP: {
                return DSL.varSamp(arg);
            }
        }
        throw ctx.unexpectedToken();
    }

    private static final AggregateFunction<?> parseCountIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "COUNT")) {
            ParserImpl.parse(ctx, '(');
            if (ParserImpl.parseIf(ctx, '*')) {
                ParserImpl.parse(ctx, ')');
                return DSL.count();
            }
            boolean distinct = ParserImpl.parseSetQuantifier(ctx);
            List<Field<?>> fields = distinct ? ParserImpl.parseFields(ctx) : Collections.singletonList(ParserImpl.parseField(ctx));
            ParserImpl.parse(ctx, ')');
            if (distinct) {
                if (fields.size() > 0) {
                    return DSL.countDistinct(fields.toArray(Tools.EMPTY_FIELD));
                }
                return DSL.countDistinct(fields.get(0));
            }
            return DSL.count(fields.get(0));
        }
        return null;
    }

    private static final boolean parseSetQuantifier(ParserContext ctx) {
        boolean distinct = ParserImpl.parseKeywordIf(ctx, "DISTINCT");
        if (!distinct) {
            ParserImpl.parseKeywordIf(ctx, "ALL");
        }
        return distinct;
    }

    private static final Schema parseSchemaName(ParserContext ctx) {
        return DSL.schema(ParserImpl.parseName(ctx));
    }

    private static final Table<?> parseTableName(ParserContext ctx) {
        return DSL.table(ParserImpl.parseName(ctx));
    }

    private static final TableField<?, ?> parseFieldName(ParserContext ctx) {
        return (TableField)DSL.field(ParserImpl.parseName(ctx));
    }

    private static final List<Field<?>> parseFieldNames(ParserContext ctx) {
        ArrayList result = new ArrayList();
        do {
            result.add(ParserImpl.parseFieldName(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final Sequence<?> parseSequenceName(ParserContext ctx) {
        return DSL.sequence(ParserImpl.parseName(ctx));
    }

    private static final Name parseIndexName(ParserContext ctx) {
        return ParserImpl.parseName(ctx);
    }

    static final Name parseName(ParserContext ctx) {
        int i;
        ArrayList<String> name;
        block8: {
            ParserImpl.parseWhitespaceIf(ctx);
            if (ctx.done()) {
                throw ctx.exception();
            }
            name = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            i = ctx.position;
            boolean identifierStart = true;
            boolean identifierEnd = false;
            do {
                char c;
                if ((c = ctx.character(i)) == '.') {
                    if (identifierStart) {
                        throw new ParserException(ctx);
                    }
                    name.add(sb.toString());
                    sb = new StringBuilder();
                    identifierStart = true;
                    identifierEnd = false;
                    continue;
                }
                if (!identifierEnd && Character.isJavaIdentifierPart(c)) {
                    sb.append(c);
                    identifierStart = false;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    identifierEnd = !identifierStart;
                    continue;
                }
                name.add(sb.toString());
                identifierEnd = !identifierStart;
                break block8;
            } while (++i != ctx.sql.length);
            if (identifierStart) {
                throw ctx.exception();
            }
            name.add(sb.toString());
            identifierEnd = !identifierStart;
        }
        if (ctx.position == i) {
            throw ctx.exception();
        }
        ctx.position = i;
        return DSL.name(name.toArray(Tools.EMPTY_STRING));
    }

    private static final List<String> parseIdentifiers(ParserContext ctx) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        do {
            if (result.add(ParserImpl.parseIdentifier(ctx))) continue;
            throw ctx.exception();
        } while (ParserImpl.parseIf(ctx, ','));
        return new ArrayList<String>(result);
    }

    private static final String parseIdentifier(ParserContext ctx) {
        String alias = ParserImpl.parseIdentifierIf(ctx);
        if (alias == null) {
            throw ctx.exception();
        }
        return alias;
    }

    private static final String parseIdentifierIf(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        int start = ctx.position;
        while (ctx.isIdentifierPart()) {
            ++ctx.position;
        }
        if (ctx.position == start) {
            return null;
        }
        return new String(ctx.sql, start, ctx.position - start);
    }

    private static final DataType<?> parseDataType(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        switch (ctx.character()) {
            case 'B': 
            case 'b': {
                if (ParserImpl.parseKeywordIf(ctx, "BIGINT")) {
                    return SQLDataType.BIGINT;
                }
                if (ParserImpl.parseKeywordIf(ctx, "BINARY")) {
                    return ParserImpl.parseDataTypeLength(ctx, SQLDataType.BINARY);
                }
                if (ParserImpl.parseKeywordIf(ctx, "BIT")) {
                    return SQLDataType.BIT;
                }
                if (ParserImpl.parseKeywordIf(ctx, "BLOB")) {
                    return SQLDataType.BLOB;
                }
                if (ParserImpl.parseKeywordIf(ctx, "BOOLEAN")) {
                    return SQLDataType.BOOLEAN;
                }
            }
            case 'C': 
            case 'c': {
                if (ParserImpl.parseKeywordIf(ctx, "CHAR")) {
                    return ParserImpl.parseDataTypeLength(ctx, SQLDataType.CHAR);
                }
                if (ParserImpl.parseKeywordIf(ctx, "CLOB")) {
                    return ParserImpl.parseDataTypeLength(ctx, SQLDataType.CLOB);
                }
            }
            case 'I': 
            case 'i': {
                if (ParserImpl.parseKeywordIf(ctx, "INT") || ParserImpl.parseKeywordIf(ctx, "INTEGER")) {
                    return SQLDataType.INTEGER;
                }
            }
            case 'V': 
            case 'v': {
                if (ParserImpl.parseKeywordIf(ctx, "VARCHAR") || ParserImpl.parseKeywordIf(ctx, "VARCHAR2") || ParserImpl.parseKeywordIf(ctx, "CHARACTER VARYING")) {
                    return ParserImpl.parseDataTypeLength(ctx, SQLDataType.VARCHAR);
                }
                if (!ParserImpl.parseKeywordIf(ctx, "VARBINARY")) break;
                return ParserImpl.parseDataTypeLength(ctx, SQLDataType.VARBINARY);
            }
        }
        throw ctx.unexpectedToken();
    }

    private static final DataType<?> parseDataTypeLength(ParserContext ctx, DataType<?> result) {
        if (ParserImpl.parseIf(ctx, '(')) {
            result = result.length((int)ParserImpl.parseUnsignedInteger(ctx).longValue());
            ParserImpl.parse(ctx, ')');
        }
        return result;
    }

    static final char parseCharacterLiteral(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        ParserImpl.parse(ctx, '\'');
        char c = ctx.character();
        if (c == '\'') {
            ParserImpl.parse(ctx, '\'');
        }
        ++ctx.position;
        ParserImpl.parse(ctx, '\'');
        return c;
    }

    static final Field<?> parseBindVariable(ParserContext ctx) {
        switch (ctx.character()) {
            case '?': {
                ParserImpl.parse(ctx, '?');
                return DSL.val(null, Object.class);
            }
            case ':': {
                ParserImpl.parse(ctx, ':');
                return DSL.param(ParserImpl.parseIdentifier(ctx));
            }
        }
        throw ctx.exception();
    }

    static final String parseStringLiteral(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        ParserImpl.parse(ctx, '\'');
        StringBuilder sb = new StringBuilder();
        for (int i = ctx.position; i < ctx.sql.length; ++i) {
            char c = ctx.character(i);
            if (c == '\'') {
                if (ctx.character(i + 1) == '\'') {
                    ++i;
                } else {
                    ctx.position = i + 1;
                    return sb.toString();
                }
            }
            sb.append(c);
        }
        throw ctx.exception();
    }

    private static final Field<?> parseFieldUnsignedNumericLiteralIf(ParserContext ctx, boolean minus) {
        Number r = ParserImpl.parseUnsignedNumericLiteralIf(ctx, minus);
        return r == null ? null : DSL.inline(r);
    }

    private static final Number parseUnsignedNumericLiteralIf(ParserContext ctx, boolean minus) {
        char c;
        StringBuilder sb = new StringBuilder();
        while ((c = ctx.character()) >= '0' && c <= '9') {
            sb.append(c);
            ++ctx.position;
        }
        if (c == '.') {
            sb.append(c);
            ++ctx.position;
        } else {
            if (sb.length() == 0) {
                return null;
            }
            try {
                return minus ? -Long.valueOf(sb.toString()).longValue() : Long.valueOf(sb.toString());
            }
            catch (Exception e1) {
                return minus ? new BigInteger(sb.toString()).negate() : new BigInteger(sb.toString());
            }
        }
        while ((c = ctx.character()) >= '0' && c <= '9') {
            sb.append(c);
            ++ctx.position;
        }
        if (sb.length() == 0) {
            return null;
        }
        return minus ? new BigDecimal(sb.toString()).negate() : new BigDecimal(sb.toString());
    }

    private static final Long parseUnsignedInteger(ParserContext ctx) {
        Long result = ParserImpl.parseUnsignedIntegerIf(ctx);
        if (result == null) {
            throw ctx.exception();
        }
        return result;
    }

    private static final Field<?> parseFieldUnsignedIntegerIf(ParserContext ctx, boolean minus) {
        Long r = ParserImpl.parseUnsignedIntegerIf(ctx);
        return r == null ? null : (minus ? DSL.inline(-r.longValue()) : DSL.inline(r));
    }

    private static final Long parseUnsignedIntegerIf(ParserContext ctx) {
        char c;
        ParserImpl.parseWhitespaceIf(ctx);
        StringBuilder sb = new StringBuilder();
        while ((c = ctx.character()) >= '0' && c <= '9') {
            sb.append(c);
            ++ctx.position;
        }
        if (sb.length() == 0) {
            return null;
        }
        return Long.valueOf(sb.toString());
    }

    private static final JoinType parseJoinType(ParserContext ctx) {
        JoinType result = ParserImpl.parseJoinTypeIf(ctx);
        if (result == null) {
            ctx.unexpectedToken();
        }
        return result;
    }

    private static final JoinType parseJoinTypeIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CROSS JOIN")) {
            return JoinType.CROSS_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "CROSS APPLY")) {
            return JoinType.CROSS_APPLY;
        }
        if (ParserImpl.parseKeywordIf(ctx, "CROSS JOIN")) {
            return JoinType.CROSS_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "INNER")) {
            ParserImpl.parseKeyword(ctx, "JOIN");
            return JoinType.JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "JOIN")) {
            return JoinType.JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "LEFT")) {
            ParserImpl.parseKeywordIf(ctx, "OUTER");
            ParserImpl.parseKeyword(ctx, "JOIN");
            return JoinType.LEFT_OUTER_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "RIGHT")) {
            ParserImpl.parseKeywordIf(ctx, "OUTER");
            ParserImpl.parseKeyword(ctx, "JOIN");
            return JoinType.RIGHT_OUTER_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "FULL OUTER JOIN")) {
            return JoinType.FULL_OUTER_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "OUTER APPLY")) {
            return JoinType.OUTER_APPLY;
        }
        if (ParserImpl.parseKeywordIf(ctx, "NATURAL")) {
            if (ParserImpl.parseKeywordIf(ctx, "LEFT")) {
                ParserImpl.parseKeywordIf(ctx, "OUTER");
                ParserImpl.parseKeyword(ctx, "JOIN");
                return JoinType.NATURAL_LEFT_OUTER_JOIN;
            }
            if (ParserImpl.parseKeywordIf(ctx, "RIGHT")) {
                ParserImpl.parseKeywordIf(ctx, "OUTER");
                ParserImpl.parseKeyword(ctx, "JOIN");
                return JoinType.NATURAL_RIGHT_OUTER_JOIN;
            }
            if (ParserImpl.parseKeywordIf(ctx, "JOIN")) {
                return JoinType.NATURAL_JOIN;
            }
        }
        return null;
    }

    static final TruthValue parseTruthValue(ParserContext ctx) {
        TruthValue result = ParserImpl.parseTruthValueIf(ctx);
        if (result == null) {
            throw ctx.exception();
        }
        return result;
    }

    static final TruthValue parseTruthValueIf(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "TRUE")) {
            return TruthValue.TRUE;
        }
        if (ParserImpl.parseKeywordIf(ctx, "FALSE")) {
            return TruthValue.FALSE;
        }
        if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
            return TruthValue.NULL;
        }
        return null;
    }

    private static final CombineOperator parseCombineOperatorIf(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "UNION")) {
            if (ParserImpl.parseKeywordIf(ctx, "ALL")) {
                return CombineOperator.UNION_ALL;
            }
            if (ParserImpl.parseKeywordIf(ctx, "DISTINCT")) {
                return CombineOperator.UNION;
            }
            return CombineOperator.UNION;
        }
        if (ParserImpl.parseKeywordIf(ctx, "EXCEPT") || ParserImpl.parseKeywordIf(ctx, "MINUS")) {
            if (ParserImpl.parseKeywordIf(ctx, "ALL")) {
                return CombineOperator.EXCEPT_ALL;
            }
            if (ParserImpl.parseKeywordIf(ctx, "DISTINCT")) {
                return CombineOperator.EXCEPT;
            }
            return CombineOperator.EXCEPT;
        }
        if (ParserImpl.parseKeywordIf(ctx, "INTERSECT")) {
            if (ParserImpl.parseKeywordIf(ctx, "ALL")) {
                return CombineOperator.INTERSECT_ALL;
            }
            if (ParserImpl.parseKeywordIf(ctx, "DISTINCT")) {
                return CombineOperator.INTERSECT;
            }
            return CombineOperator.INTERSECT;
        }
        return null;
    }

    private static final ComputationalOperation parseComputationalOperationIf(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "AVG")) {
            return ComputationalOperation.AVG;
        }
        if (ParserImpl.parseKeywordIf(ctx, "MAX")) {
            return ComputationalOperation.MAX;
        }
        if (ParserImpl.parseKeywordIf(ctx, "MIN")) {
            return ComputationalOperation.MIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "SUM")) {
            return ComputationalOperation.SUM;
        }
        if (ParserImpl.parseKeywordIf(ctx, "EVERY") || ParserImpl.parseKeywordIf(ctx, "BOOL_AND")) {
            return ComputationalOperation.EVERY;
        }
        if (ParserImpl.parseKeywordIf(ctx, "ANY") || ParserImpl.parseKeywordIf(ctx, "SOME") || ParserImpl.parseKeywordIf(ctx, "BOOL_OR")) {
            return ComputationalOperation.ANY;
        }
        if (ParserImpl.parseKeywordIf(ctx, "STDDEV_POP")) {
            return ComputationalOperation.STDDEV_POP;
        }
        if (ParserImpl.parseKeywordIf(ctx, "STDDEV_SAMP")) {
            return ComputationalOperation.STDDEV_SAMP;
        }
        if (ParserImpl.parseKeywordIf(ctx, "VAR_POP")) {
            return ComputationalOperation.VAR_POP;
        }
        if (ParserImpl.parseKeywordIf(ctx, "VAR_SAMP")) {
            return ComputationalOperation.VAR_SAMP;
        }
        return null;
    }

    private static final BinarySetFunctionType parseBinarySetFunctionTypeIf(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        for (BinarySetFunctionType type : BinarySetFunctionType.values()) {
            if (!ParserImpl.parseKeywordIf(ctx, type.name())) continue;
            return type;
        }
        return null;
    }

    private static final Comparator parseComparatorIf(ParserContext ctx) {
        ParserImpl.parseWhitespaceIf(ctx);
        if (ParserImpl.parseIf(ctx, "=")) {
            return Comparator.EQUALS;
        }
        if (ParserImpl.parseIf(ctx, "!=") || ParserImpl.parseIf(ctx, "<>")) {
            return Comparator.NOT_EQUALS;
        }
        if (ParserImpl.parseIf(ctx, ">=")) {
            return Comparator.GREATER_OR_EQUAL;
        }
        if (ParserImpl.parseIf(ctx, ">")) {
            return Comparator.GREATER;
        }
        if (ParserImpl.parseIf(ctx, "<=")) {
            return Comparator.LESS_OR_EQUAL;
        }
        if (ParserImpl.parseIf(ctx, "<")) {
            return Comparator.LESS;
        }
        return null;
    }

    private static final boolean parseIf(ParserContext ctx, String string) {
        ParserImpl.parseWhitespaceIf(ctx);
        int length = string.length();
        ctx.expectedTokens.add(string);
        if (ctx.sql.length < ctx.position + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (ctx.sql[ctx.position + i] == c) continue;
            return false;
        }
        ctx.position += length;
        ctx.expectedTokens.clear();
        return true;
    }

    private static final boolean parseIf(ParserContext ctx, char c) {
        ParserImpl.parseWhitespaceIf(ctx);
        if (ctx.character() != c) {
            return false;
        }
        ++ctx.position;
        return true;
    }

    private static final void parse(ParserContext ctx, char c) {
        if (!ParserImpl.parseIf(ctx, c)) {
            throw ctx.unexpectedToken();
        }
    }

    static final void parseKeyword(ParserContext ctx, String string) {
        if (!ParserImpl.parseKeywordIf(ctx, string)) {
            throw ctx.unexpectedToken();
        }
    }

    static final boolean parseKeywordIf(ParserContext ctx, String string) {
        ctx.expectedTokens.add(string);
        if (!ParserImpl.peekKeyword(ctx, string, true)) {
            return false;
        }
        ctx.expectedTokens.clear();
        return true;
    }

    private static final boolean peekKeyword(ParserContext ctx, String ... keywords) {
        for (String keyword : keywords) {
            if (!ParserImpl.peekKeyword(ctx, keyword)) continue;
            return true;
        }
        return false;
    }

    private static final boolean peekKeyword(ParserContext ctx, String keyword) {
        return ParserImpl.peekKeyword(ctx, keyword, false);
    }

    private static final boolean peekKeyword(ParserContext ctx, String keyword, boolean updatePosition) {
        ParserImpl.parseWhitespaceIf(ctx);
        int length = keyword.length();
        if (ctx.sql.length < ctx.position + length) {
            return false;
        }
        int skip = 0;
        block6: while (ctx.position + skip < ctx.sql.length) {
            char c = ctx.character(ctx.position + skip);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '(': {
                    break;
                }
                default: {
                    break block6;
                }
            }
            ++skip;
        }
        block7: for (int i = 0; i < length; ++i) {
            char c = keyword.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    skip += ParserImpl.afterWhitespace(ctx, ctx.position + i + skip) - ctx.position - i - 1;
                    continue block7;
                }
                default: {
                    if (ParserImpl.upper(ctx.sql[ctx.position + i + skip]) == keyword.charAt(i)) continue block7;
                    return false;
                }
            }
        }
        if (ctx.isIdentifierPart(ctx.position + length + skip)) {
            return false;
        }
        if (updatePosition) {
            ctx.position = ctx.position + length + skip;
        }
        return true;
    }

    static final boolean parseWhitespaceIf(ParserContext ctx) {
        int position = ctx.position;
        ctx.position = ParserImpl.afterWhitespace(ctx, ctx.position);
        return position != ctx.position;
    }

    private static final int afterWhitespace(ParserContext ctx, int position) {
        block3: for (int i = position; i < ctx.sql.length; ++i) {
            switch (ctx.sql[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    position = i + 1;
                    continue block3;
                }
            }
        }
        return position;
    }

    private static final char upper(char c) {
        return c >= 'a' && c <= 'z' ? (char)(c - 32) : c;
    }

    public static void main(String[] args) {
        System.out.println(new ParserImpl(new DefaultConfiguration()).parse("DROP INDEX   y on a.b.c"));
    }

    static enum BinarySetFunctionType {
        REGR_SLOPE,
        REGR_INTERCEPT,
        REGR_COUNT,
        REGR_R2,
        REGR_AVGX,
        REGR_AVGY,
        REGR_SXX,
        REGR_SYY,
        REGR_SXY;

    }

    static enum ComputationalOperation {
        AVG,
        MAX,
        MIN,
        SUM,
        EVERY,
        ANY,
        SOME,
        COUNT,
        STDDEV_POP,
        STDDEV_SAMP,
        VAR_SAMP,
        VAR_POP;

    }

    static enum TruthValue {
        TRUE,
        FALSE,
        NULL;

    }

    static class ParserException
    extends DataAccessException {
        private static final long serialVersionUID = -724913199583039157L;
        private final ParserContext ctx;

        public ParserException(ParserContext ctx) {
            this(ctx, null);
        }

        public ParserException(ParserContext ctx, String message) {
            this(ctx, message, SQLStateSubclass.C42000_NO_SUBCLASS);
        }

        public ParserException(ParserContext ctx, String message, SQLStateSubclass state) {
            this(ctx, message, state, null);
        }

        public ParserException(ParserContext ctx, String message, SQLStateSubclass state, Throwable cause) {
            super((Object)((Object)state) + ": " + (message == null ? "" : message + ": ") + ctx.mark(), cause);
            this.ctx = ctx;
        }
    }

    static class ParserContext {
        final DSLContext dsl;
        final String sqlString;
        final char[] sql;
        final List<String> expectedTokens;
        int position = 0;

        ParserContext(DSLContext dsl, String sqlString) {
            this.dsl = dsl;
            this.sqlString = sqlString;
            this.sql = sqlString.toCharArray();
            this.expectedTokens = new ArrayList<String>();
        }

        ParserException internalError() {
            return new ParserException(this, "Internal Error");
        }

        ParserException exception() {
            return new ParserException(this);
        }

        ParserException unexpectedToken() {
            return new ParserException(this, "Expected tokens: " + new TreeSet<String>(this.expectedTokens));
        }

        char character() {
            return this.character(this.position);
        }

        char character(int pos) {
            return pos >= 0 && pos < this.sql.length ? this.sql[pos] : (char)' ';
        }

        boolean isWhitespace() {
            return Character.isWhitespace(this.character());
        }

        boolean isWhitespace(int pos) {
            return Character.isWhitespace(this.character(pos));
        }

        boolean isIdentifierPart() {
            return Character.isJavaIdentifierPart(this.character());
        }

        boolean isIdentifierPart(int pos) {
            return Character.isJavaIdentifierPart(this.character(pos));
        }

        boolean done() {
            return this.position >= this.sql.length;
        }

        String mark() {
            return this.sqlString.substring(0, this.position) + "[*]" + this.sqlString.substring(this.position);
        }

        public String toString() {
            return this.mark();
        }
    }

    static enum Type {
        D,
        S,
        N,
        B;


        boolean is(Type type) {
            return type == null || type == this;
        }
    }
}

