/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.ForeignKey;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.UniqueKeyImpl;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;

final class InformationSchemaMetaImpl
implements Meta {
    private final Configuration configuration;
    private final InformationSchema source;
    private final List<Catalog> catalogs;
    private final List<Schema> schemas;
    private final Map<Name, Schema> schemasByName;
    private final Map<Catalog, List<Schema>> schemasPerCatalog;
    private final List<InformationSchemaTable> tables;
    private final Map<Name, InformationSchemaTable> tablesByName;
    private final Map<Schema, List<InformationSchemaTable>> tablesPerSchema;
    private final List<Sequence<?>> sequences;
    private final Map<Schema, List<Sequence<?>>> sequencesPerSchema;
    private final List<UniqueKeyImpl<Record>> primaryKeys;
    private final Map<Name, UniqueKeyImpl<Record>> uniqueKeysByName;
    private final Map<Name, Name> referentialKeys;

    InformationSchemaMetaImpl(Configuration configuration, InformationSchema source) {
        this.configuration = configuration;
        this.source = source;
        this.catalogs = new ArrayList<Catalog>();
        this.schemas = new ArrayList<Schema>();
        this.schemasByName = new HashMap<Name, Schema>();
        this.schemasPerCatalog = new HashMap<Catalog, List<Schema>>();
        this.tables = new ArrayList<InformationSchemaTable>();
        this.tablesByName = new HashMap<Name, InformationSchemaTable>();
        this.tablesPerSchema = new HashMap<Schema, List<InformationSchemaTable>>();
        this.sequences = new ArrayList();
        this.sequencesPerSchema = new HashMap();
        this.primaryKeys = new ArrayList<UniqueKeyImpl<Record>>();
        this.uniqueKeysByName = new HashMap<Name, UniqueKeyImpl<Record>>();
        this.referentialKeys = new HashMap<Name, Name>();
        this.init(source);
    }

    public static void main(String[] args) {
        System.out.println(String.format("x y %0$s", "abc"));
    }

    private final void init(InformationSchema meta) {
        List c;
        ArrayList<String> errors = new ArrayList<String>();
        for (org.jooq.util.xml.jaxb.Schema schema : meta.getSchemata()) {
            InformationSchemaCatalog catalog = new InformationSchemaCatalog(schema.getCatalogName());
            if (!this.catalogs.contains(catalog)) {
                this.catalogs.add(catalog);
            }
            InformationSchemaSchema is = new InformationSchemaSchema(schema.getSchemaName(), catalog);
            this.schemas.add(is);
            this.schemasByName.put(DSL.name(schema.getCatalogName(), schema.getSchemaName()), is);
        }
        for (org.jooq.util.xml.jaxb.Table table : meta.getTables()) {
            Name schemaName = DSL.name(table.getTableCatalog(), table.getTableSchema());
            Schema schema = this.schemasByName.get(schemaName);
            if (schema == null) {
                errors.add(String.format("Schema " + schemaName + " not defined for table " + table.getTableName(), new Object[0]));
                continue;
            }
            InformationSchemaTable informationSchemaTable = new InformationSchemaTable(table.getTableName(), schema);
            this.tables.add(informationSchemaTable);
            this.tablesByName.put(DSL.name(table.getTableCatalog(), table.getTableSchema(), table.getTableName()), informationSchemaTable);
        }
        ArrayList<Column> columns = new ArrayList<Column>(meta.getColumns());
        Collections.sort(columns, new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                Integer p2;
                Integer p1 = o1.getOrdinalPosition();
                if (p1 == (p2 = o2.getOrdinalPosition())) {
                    return 0;
                }
                if (p1 == null) {
                    return -1;
                }
                if (p2 == null) {
                    return 1;
                }
                return p1.compareTo(p2);
            }
        });
        for (Column xc : columns) {
            String typeName = xc.getDataType();
            int n = xc.getCharacterMaximumLength() == null ? 0 : xc.getCharacterMaximumLength();
            int precision = xc.getNumericPrecision() == null ? 0 : xc.getNumericPrecision();
            int scale = xc.getNumericScale() == null ? 0 : xc.getNumericScale();
            boolean nullable = xc.isIsNullable() == null ? true : xc.isIsNullable();
            Name tableName = DSL.name(xc.getTableCatalog(), xc.getTableSchema(), xc.getTableName());
            InformationSchemaTable table = this.tablesByName.get(tableName);
            if (table == null) {
                errors.add(String.format("Table " + tableName + " not defined for column " + xc.getColumnName(), new Object[0]));
                continue;
            }
            AbstractTable.createField(xc.getColumnName(), this.type(typeName, n, precision, scale, nullable), table);
        }
        HashMap hashMap = new HashMap();
        ArrayList<KeyColumnUsage> keyColumnUsages = new ArrayList<KeyColumnUsage>(meta.getKeyColumnUsages());
        Collections.sort(keyColumnUsages, new Comparator<KeyColumnUsage>(){

            @Override
            public int compare(KeyColumnUsage o1, KeyColumnUsage o2) {
                int p2;
                int p1 = o1.getOrdinalPosition();
                return p1 < (p2 = o2.getOrdinalPosition()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
        for (KeyColumnUsage keyColumnUsage : keyColumnUsages) {
            Name tableName;
            InformationSchemaTable table;
            Name constraintName = DSL.name(keyColumnUsage.getConstraintCatalog(), keyColumnUsage.getConstraintSchema(), keyColumnUsage.getConstraintName());
            ArrayList<TableField> fields = (ArrayList<TableField>)hashMap.get(constraintName);
            if (fields == null) {
                fields = new ArrayList<TableField>();
                hashMap.put(constraintName, fields);
            }
            if ((table = this.tablesByName.get(tableName = DSL.name(keyColumnUsage.getTableCatalog(), keyColumnUsage.getTableSchema(), keyColumnUsage.getTableName()))) == null) {
                errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                continue;
            }
            TableField field = (TableField)table.field(keyColumnUsage.getColumnName());
            if (field == null) {
                errors.add(String.format("Column " + keyColumnUsage.getColumnName() + " not defined for table " + tableName, new Object[0]));
                continue;
            }
            fields.add(field);
        }
        for (TableConstraint tableConstraint : meta.getTableConstraints()) {
            switch (tableConstraint.getConstraintType()) {
                case PRIMARY_KEY: 
                case UNIQUE: {
                    Name tableName = DSL.name(tableConstraint.getTableCatalog(), tableConstraint.getTableSchema(), tableConstraint.getTableName());
                    Name constraintName = DSL.name(tableConstraint.getConstraintCatalog(), tableConstraint.getConstraintSchema(), tableConstraint.getConstraintName());
                    InformationSchemaTable table = this.tablesByName.get(tableName);
                    if (table == null) {
                        errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    c = (List)hashMap.get(constraintName);
                    if (c == null || c.isEmpty()) {
                        errors.add(String.format("No columns defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    UniqueKeyImpl key = (UniqueKeyImpl)AbstractKeys.createUniqueKey(table, tableConstraint.getConstraintName(), c.toArray(new TableField[0]));
                    if (tableConstraint.getConstraintType() == TableConstraintType.PRIMARY_KEY) {
                        table.primaryKey = key;
                        this.primaryKeys.add(key);
                    }
                    table.uniqueKeys.add(key);
                    this.uniqueKeysByName.put(constraintName, key);
                    break;
                }
            }
        }
        for (ReferentialConstraint referentialConstraint : meta.getReferentialConstraints()) {
            this.referentialKeys.put(DSL.name(referentialConstraint.getConstraintCatalog(), referentialConstraint.getConstraintSchema(), referentialConstraint.getConstraintName()), DSL.name(referentialConstraint.getUniqueConstraintCatalog(), referentialConstraint.getUniqueConstraintSchema(), referentialConstraint.getUniqueConstraintName()));
        }
        for (TableConstraint tableConstraint : meta.getTableConstraints()) {
            switch (tableConstraint.getConstraintType()) {
                case FOREIGN_KEY: {
                    Name tableName = DSL.name(tableConstraint.getTableCatalog(), tableConstraint.getTableSchema(), tableConstraint.getTableName());
                    Name constraintName = DSL.name(tableConstraint.getConstraintCatalog(), tableConstraint.getConstraintSchema(), tableConstraint.getConstraintName());
                    InformationSchemaTable table = this.tablesByName.get(tableName);
                    if (table == null) {
                        errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    c = (List)hashMap.get(constraintName);
                    if (c == null || c.isEmpty()) {
                        errors.add(String.format("No columns defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    UniqueKeyImpl<Record> uniqueKey = this.uniqueKeysByName.get(this.referentialKeys.get(constraintName));
                    if (uniqueKey == null) {
                        errors.add(String.format("No unique key defined for foreign key " + constraintName, new Object[0]));
                        break;
                    }
                    ForeignKey<Record, Record> key = AbstractKeys.createForeignKey(uniqueKey, table, tableConstraint.getConstraintName(), c.toArray(new TableField[0]));
                    table.foreignKeys.add(key);
                    break;
                }
            }
        }
        for (org.jooq.util.xml.jaxb.Sequence sequence : meta.getSequences()) {
            Name schemaName = DSL.name(sequence.getSequenceCatalog(), sequence.getSequenceSchema());
            Schema schema = this.schemasByName.get(schemaName);
            if (schema == null) {
                errors.add(String.format("Schema " + schemaName + " not defined for sequence " + sequence.getSequenceName(), new Object[0]));
                continue;
            }
            String typeName = sequence.getDataType();
            int length = sequence.getCharacterMaximumLength() == null ? 0 : sequence.getCharacterMaximumLength();
            int precision = sequence.getNumericPrecision() == null ? 0 : sequence.getNumericPrecision();
            int scale = sequence.getNumericScale() == null ? 0 : sequence.getNumericScale();
            boolean nullable = true;
            InformationSchemaSequence is = new InformationSchemaSequence(sequence.getSequenceName(), schema, this.type(typeName, length, precision, scale, nullable));
            this.sequences.add(is);
        }
        for (Schema schema : this.schemas) {
            Catalog c2 = schema.getCatalog();
            List<Schema> list = this.schemasPerCatalog.get(c2);
            if (list == null) {
                list = new ArrayList<Schema>();
                this.schemasPerCatalog.put(c2, list);
            }
            list.add(schema);
        }
        for (InformationSchemaTable informationSchemaTable : this.tables) {
            Schema s = informationSchemaTable.getSchema();
            List<InformationSchemaTable> list = this.tablesPerSchema.get(s);
            if (list == null) {
                list = new ArrayList<InformationSchemaTable>();
                this.tablesPerSchema.put(s, list);
            }
            list.add(informationSchemaTable);
        }
        for (Sequence sequence : this.sequences) {
            Schema s = sequence.getSchema();
            List<Sequence<?>> list = this.sequencesPerSchema.get(s);
            if (list == null) {
                list = new ArrayList();
                this.sequencesPerSchema.put(s, list);
            }
            list.add(sequence);
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(((Object)errors).toString());
        }
    }

    private final DataType<?> type(String typeName, int length, int precision, int scale, boolean nullable) {
        DataType<Object> type = null;
        try {
            type = DefaultDataType.getDataType(this.configuration.family(), typeName);
            type = type.nullable(nullable);
            if (length != 0) {
                type = type.length(length);
            } else if (precision != 0 || scale != 0) {
                type = type.precision(precision, scale);
            }
        }
        catch (SQLDialectNotSupportedException e) {
            type = SQLDataType.OTHER;
        }
        return type;
    }

    @Override
    public final List<Catalog> getCatalogs() {
        return Collections.unmodifiableList(this.catalogs);
    }

    @Override
    public final List<Schema> getSchemas() {
        return Collections.unmodifiableList(this.schemas);
    }

    @Override
    public final List<Table<?>> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public final List<Sequence<?>> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this.source, (Writer)writer);
        return writer.toString();
    }

    private final class InformationSchemaSequence<N extends Number>
    extends SequenceImpl<N> {
        private static final long serialVersionUID = -1246697252597049756L;

        InformationSchemaSequence(String name, Schema schema, DataType<N> type) {
            super(name, schema, type);
        }
    }

    private final class InformationSchemaTable
    extends TableImpl<Record> {
        private static final long serialVersionUID = 4314110578549768267L;
        UniqueKey<Record> primaryKey;
        final List<UniqueKey<Record>> uniqueKeys;
        final List<ForeignKey<Record, Record>> foreignKeys;

        public InformationSchemaTable(String name, Schema schema) {
            super(name, schema);
            this.uniqueKeys = new ArrayList<UniqueKey<Record>>();
            this.foreignKeys = new ArrayList<ForeignKey<Record, Record>>();
        }

        @Override
        public UniqueKey<Record> getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public List<UniqueKey<Record>> getKeys() {
            return Collections.unmodifiableList(this.uniqueKeys);
        }

        @Override
        public List<ForeignKey<Record, ?>> getReferences() {
            return Collections.unmodifiableList(this.foreignKeys);
        }
    }

    private final class InformationSchemaSchema
    extends SchemaImpl {
        private static final long serialVersionUID = 7290709749127378187L;

        public InformationSchemaSchema(String name, Catalog catalog) {
            super(name, catalog);
        }

        @Override
        public final List<Table<?>> getTables() {
            return Collections.unmodifiableList((List)InformationSchemaMetaImpl.this.tablesPerSchema.get(this));
        }

        @Override
        public final List<Sequence<?>> getSequences() {
            return Collections.unmodifiableList((List)InformationSchemaMetaImpl.this.sequencesPerSchema.get(this));
        }
    }

    private final class InformationSchemaCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = 87038321849045492L;

        InformationSchemaCatalog(String name) {
            super(name);
        }

        @Override
        public final List<Schema> getSchemas() {
            return Collections.unmodifiableList((List)InformationSchemaMetaImpl.this.schemasPerCatalog.get(this));
        }
    }
}

