/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.jooq.AttachableInternal;
import org.jooq.Configuration;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.ResultOrRows;
import org.jooq.Results;

final class ResultsImpl
extends AbstractList<Result<Record>>
implements Results,
AttachableInternal {
    private static final long serialVersionUID = 1744826140354980500L;
    private Configuration configuration;
    private final List<ResultOrRows> results;

    ResultsImpl(Configuration configuration) {
        this.configuration = configuration;
        this.results = new ArrayList<ResultOrRows>();
    }

    @Override
    public final List<ResultOrRows> resultsOrRows() {
        return this.results;
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
        for (Result result : this) {
            if (result == null) continue;
            result.attach(c);
        }
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (ResultOrRows result : this.results) {
            if (result.result() == null) {
                sb.append(separator).append("Update count: ").append(result.rows());
            } else {
                sb.append(separator).append("Result set:\n").append(result.result());
            }
            separator = "\n";
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.results.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResultsImpl) {
            ResultsImpl other = (ResultsImpl)obj;
            return this.results.equals(other.results);
        }
        return false;
    }

    @Override
    public final int size() {
        return this.list().size();
    }

    @Override
    public final Result<Record> get(int index) {
        return this.list().get(index);
    }

    @Override
    public Result<Record> set(int index, Result<Record> element) {
        return this.results.set(this.translatedIndex(index), new ResultOrRowsImpl(element)).result();
    }

    @Override
    public void add(int index, Result<Record> element) {
        this.results.add(this.translatedIndex(index), new ResultOrRowsImpl(element));
    }

    @Override
    public Result<Record> remove(int index) {
        return this.results.remove(this.translatedIndex(index)).result();
    }

    @Override
    public void clear() {
        this.results.clear();
    }

    private final List<Result<Record>> list() {
        ArrayList<Result<Record>> list = new ArrayList<Result<Record>>();
        for (ResultOrRows result : this.results) {
            if (result.result() == null) continue;
            list.add(result.result());
        }
        return list;
    }

    private final int translatedIndex(int index) {
        int translated = 0;
        for (int i = 0; i < index; ++i) {
            while (this.results.get(translated++).result() == null) {
            }
        }
        return translated;
    }

    static final class ResultOrRowsImpl
    implements ResultOrRows {
        private final Result<Record> result;
        private final int rows;

        ResultOrRowsImpl(Result<Record> result) {
            this(result, result != null ? result.size() : 0);
        }

        ResultOrRowsImpl(int rows) {
            this(null, rows);
        }

        private ResultOrRowsImpl(Result<Record> result, int rows) {
            this.result = result;
            this.rows = rows;
        }

        @Override
        public final Result<Record> result() {
            return this.result;
        }

        @Override
        public final int rows() {
            return this.rows;
        }

        public int hashCode() {
            int prime = 31;
            int r = 1;
            r = 31 * r + (this.result == null ? 0 : this.result.hashCode());
            r = 31 * r + this.rows;
            return r;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResultOrRowsImpl other = (ResultOrRowsImpl)obj;
            if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
                return false;
            }
            return this.rows == other.rows;
        }
    }
}

