/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.ConditionProvider;
import org.jooq.Configuration;
import org.jooq.DeleteQuery;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableRecord;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.UpdateQuery;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DataChangedException;
import org.jooq.exception.NoDataFoundException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.RecordDelegate;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class UpdatableRecordImpl<R extends UpdatableRecord<R>>
extends TableRecordImpl<R>
implements UpdatableRecord<R> {
    private static final long serialVersionUID = -1012420583600561579L;
    private static final JooqLogger log = JooqLogger.getLogger(UpdatableRecordImpl.class);

    public UpdatableRecordImpl(Table<R> table) {
        super(table);
    }

    @Override
    public Record key() {
        RecordImpl result = new RecordImpl(this.getPrimaryKey().getFields());
        result.setValues(result.fields.fields.fields, this);
        return result;
    }

    @Override
    public final <O extends TableRecord<O>> O fetchChild(ForeignKey<O, R> key) {
        return (O)((TableRecord)Tools.filterOne(this.fetchChildren(key)));
    }

    @Override
    public final <O extends TableRecord<O>> Result<O> fetchChildren(ForeignKey<O, R> key) {
        return key.fetchChildren((R)this);
    }

    final UniqueKey<R> getPrimaryKey() {
        return this.getTable().getPrimaryKey();
    }

    @Override
    public final int store() {
        return this.store(this.fields.fields.fields);
    }

    @Override
    public final int store(final Field<?> ... storeFields) throws DataAccessException, DataChangedException {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.STORE).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = UpdatableRecordImpl.this.store0(storeFields);
                return record;
            }
        });
        return result[0];
    }

    @Override
    public final int update() {
        return this.update(this.fields.fields.fields);
    }

    @Override
    public int update(Field<?> ... storeFields) throws DataAccessException, DataChangedException {
        return this.storeUpdate(storeFields, this.getPrimaryKey().getFieldsArray());
    }

    private final int store0(Field<?>[] storeFields) {
        TableField<R, ?>[] keys = this.getPrimaryKey().getFieldsArray();
        boolean executeUpdate = false;
        if (SettingsTools.updatablePrimaryKeys(Tools.settings(this))) {
            executeUpdate = this.fetched;
        } else {
            for (TableField field : keys) {
                if (this.changed(field) || !field.getDataType().nullable() && this.getValue(field) == null) {
                    executeUpdate = false;
                    break;
                }
                executeUpdate = true;
            }
        }
        int result = 0;
        result = executeUpdate ? this.storeUpdate(storeFields, keys) : this.storeInsert(storeFields);
        return result;
    }

    private final int storeUpdate(final Field<?>[] storeFields, final TableField<R, ?>[] keys) {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.UPDATE).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = UpdatableRecordImpl.this.storeUpdate0(storeFields, keys);
                return record;
            }
        });
        return result[0];
    }

    private final int storeUpdate0(Field<?>[] storeFields, TableField<R, ?>[] keys) {
        UpdateQuery update = this.create().updateQuery(this.getTable());
        this.addChangedValues(storeFields, update);
        Tools.addConditions(update, this, keys);
        if (!update.isExecutable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Query is not executable", update);
            }
            return 0;
        }
        BigInteger version = this.addRecordVersion(update);
        Timestamp timestamp = this.addRecordTimestamp(update);
        if (this.isExecuteWithOptimisticLocking()) {
            if (this.isTimestampOrVersionAvailable()) {
                this.addConditionForVersionAndTimestamp(update);
            } else {
                this.checkIfChanged(keys);
            }
        }
        int result = update.execute();
        this.checkIfChanged(result, version, timestamp);
        if (result > 0) {
            for (Field<?> storeField : storeFields) {
                this.changed(storeField, false);
            }
        }
        return result;
    }

    @Override
    public final int delete() {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.DELETE).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = UpdatableRecordImpl.this.delete0();
                return record;
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int delete0() {
        TableField<R, ?>[] keys = this.getPrimaryKey().getFieldsArray();
        try {
            DeleteQuery delete1 = this.create().deleteQuery(this.getTable());
            Tools.addConditions(delete1, this, keys);
            if (this.isExecuteWithOptimisticLocking()) {
                if (this.isTimestampOrVersionAvailable()) {
                    this.addConditionForVersionAndTimestamp(delete1);
                } else {
                    this.checkIfChanged(keys);
                }
            }
            int result = delete1.execute();
            this.checkIfChanged(result, null, null);
            int n = result;
            return n;
        }
        finally {
            this.changed(true);
            this.fetched = false;
        }
    }

    @Override
    public final void refresh() {
        this.refresh(this.fields.fields.fields);
    }

    @Override
    public final void refresh(final Field<?> ... refreshFields) {
        SelectQuery<Record> select = this.create().selectQuery();
        select.addSelect(refreshFields);
        select.addFrom((TableLike<?>)this.getTable());
        Tools.addConditions(select, this, this.getPrimaryKey().getFieldsArray());
        if (select.execute() != 1) {
            throw new NoDataFoundException("Exactly one row expected for refresh. Record does not exist in database.");
        }
        final AbstractRecord source = (AbstractRecord)select.getResult().get(0);
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.REFRESH).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                UpdatableRecordImpl.this.setValues(refreshFields, source);
                return record;
            }
        });
    }

    @Override
    public final R copy() {
        return (R)((UpdatableRecord)Tools.newRecord(false, this.getTable(), this.configuration()).operate(new RecordOperation<R, RuntimeException>(){

            @Override
            public R operate(R copy) throws RuntimeException {
                List key = UpdatableRecordImpl.this.getPrimaryKey().getFields();
                for (Field<?> field : UpdatableRecordImpl.this.fields.fields.fields) {
                    if (key.contains(field)) continue;
                    this.setValue((Record)copy, field);
                }
                return copy;
            }

            private final <T> void setValue(Record record, Field<T> field) {
                record.setValue(field, UpdatableRecordImpl.this.getValue(field));
            }
        }));
    }

    private final boolean isExecuteWithOptimisticLocking() {
        Configuration configuration = this.configuration();
        if (configuration != null) {
            return Boolean.TRUE.equals(configuration.settings().isExecuteWithOptimisticLocking());
        }
        return false;
    }

    private final void addConditionForVersionAndTimestamp(ConditionProvider query) {
        TableField v = this.getTable().getRecordVersion();
        TableField t = this.getTable().getRecordTimestamp();
        if (v != null) {
            Tools.addCondition(query, this, v);
        }
        if (t != null) {
            Tools.addCondition(query, this, t);
        }
    }

    private final void checkIfChanged(TableField<R, ?>[] keys) {
        UpdatableRecord record;
        SelectQuery select = this.create().selectQuery(this.getTable());
        Tools.addConditions(select, this, keys);
        if (!Arrays.asList(SQLDialect.SQLITE).contains((Object)this.create().configuration().dialect().family())) {
            select.setForUpdate(true);
        }
        if ((record = (UpdatableRecord)select.fetchOne()) == null) {
            throw new DataChangedException("Database record no longer exists");
        }
        for (Field<?> field : this.fields.fields.fields) {
            Object thatObject;
            Object thisObject = this.original(field);
            if (StringUtils.equals(thisObject, thatObject = record.original(field))) continue;
            throw new DataChangedException("Database record has been changed");
        }
    }

    private final void checkIfChanged(int result, BigInteger version, Timestamp timestamp) {
        if (result > 0) {
            this.setRecordVersionAndTimestamp(version, timestamp);
        } else if (this.isExecuteWithOptimisticLocking()) {
            throw new DataChangedException("Database record has been changed or doesn't exist any longer");
        }
    }
}

