/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Row;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBindingGetSQLInputContext;
import org.jooq.impl.DefaultBindingSetSQLOutputContext;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.RowImpl;
import org.jooq.impl.Tools;

public class UDTRecordImpl<R extends UDTRecord<R>>
extends AbstractRecord
implements UDTRecord<R> {
    private static final long serialVersionUID = 5671315498175872799L;
    private final UDT<R> udt;

    public UDTRecordImpl(UDT<R> udt) {
        super(udt.fields());
        this.udt = udt;
    }

    @Override
    public final UDT<R> getUDT() {
        return this.udt;
    }

    @Override
    public Row fieldsRow() {
        return this.fields;
    }

    @Override
    public Row valuesRow() {
        return new RowImpl(Tools.fields(this.intoArray(), this.fields.fields.fields()));
    }

    @Override
    public final String getSQLTypeName() throws SQLException {
        Configuration configuration = DefaultExecuteContext.localConfiguration();
        return Tools.getMappedUDTName(configuration, this);
    }

    @Override
    public final void readSQL(SQLInput stream, String typeName) throws SQLException {
        Configuration configuration = DefaultExecuteContext.localConfiguration();
        Map<Object, Object> data = DefaultExecuteContext.localData();
        for (Field<?> field : this.getUDT().fields()) {
            this.setValue(configuration, data, stream, field);
        }
    }

    private final <T> void setValue(Configuration configuration, Map<Object, Object> data, SQLInput stream, Field<T> field) throws SQLException {
        DefaultBindingGetSQLInputContext out = new DefaultBindingGetSQLInputContext(configuration, data, stream);
        field.getBinding().get(out);
        this.setValue(field, out.value());
    }

    @Override
    public final void writeSQL(SQLOutput stream) throws SQLException {
        Configuration configuration = DefaultExecuteContext.localConfiguration();
        Map<Object, Object> data = DefaultExecuteContext.localData();
        for (Field<?> field : this.getUDT().fields()) {
            this.setValue(configuration, data, stream, field);
        }
    }

    private final <T> void setValue(Configuration configuration, Map<Object, Object> data, SQLOutput stream, Field<T> field) throws SQLException {
        field.getBinding().set(new DefaultBindingSetSQLOutputContext<T>(configuration, data, stream, this.getValue(field)));
    }

    @Override
    public String toString() {
        return DSL.using(this.configuration()).renderInlined(DSL.inline(this));
    }
}

