/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Alias;
import org.jooq.impl.Fields;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

public class TableImpl<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = 261033315221985068L;
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    final Fields<R> fields = new Fields(new Field[0]);
    final Alias<Table<R>> alias;
    protected final Field<?>[] parameters;

    public TableImpl(String name) {
        this(name, null, null, null, null);
    }

    public TableImpl(String name, Schema schema) {
        this(name, schema, null, null, null);
    }

    public TableImpl(String name, Schema schema, Table<R> aliased) {
        this(name, schema, aliased, null, null);
    }

    public TableImpl(String name, Schema schema, Table<R> aliased, Field<?>[] parameters) {
        this(name, schema, aliased, parameters, null);
    }

    public TableImpl(String name, Schema schema, Table<R> aliased, Field<?>[] parameters, String comment) {
        super(name, schema, comment);
        this.alias = aliased != null ? new Alias<Table<R>>(aliased, name) : null;
        this.parameters = parameters;
    }

    Table<R> getAliasedTable() {
        if (this.alias != null) {
            return this.alias.wrapped();
        }
        return null;
    }

    @Override
    final Fields<R> fields0() {
        return this.fields;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.alias != null ? CLAUSES_TABLE_ALIAS : CLAUSES_TABLE_REFERENCE;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.alias != null) {
            this.alias.accept(ctx);
        } else {
            Schema mappedSchema;
            if (ctx.qualify() && (ctx.family() != SQLDialect.POSTGRES || this.parameters == null || ctx.declareTables()) && (mappedSchema = Tools.getMappedSchema(ctx.configuration(), this.getSchema())) != null) {
                ctx.visit(mappedSchema);
                ctx.sql('.');
            }
            ctx.literal(Tools.getMappedTable(ctx.configuration(), this).getName());
            if (this.parameters != null && ctx.declareTables()) {
                if (ctx.family() == SQLDialect.FIREBIRD && this.parameters.length == 0) {
                    ctx.visit(new QueryPartList((QueryPart[])this.parameters));
                } else {
                    ctx.sql('(').visit(new QueryPartList((QueryPart[])this.parameters)).sql(')');
                }
            }
        }
    }

    @Override
    public Table<R> as(String as) {
        if (this.alias != null) {
            return this.alias.wrapped().as(as);
        }
        return new TableAlias(this, as);
    }

    @Override
    public Table<R> as(String as, String ... fieldAliases) {
        if (this.alias != null) {
            return this.alias.wrapped().as(as, fieldAliases);
        }
        return new TableAlias(this, as, fieldAliases);
    }

    @Override
    public Class<? extends R> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public boolean declaresTables() {
        return this.alias != null || this.parameters != null || super.declaresTables();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof TableImpl) {
            TableImpl other = (TableImpl)that;
            return StringUtils.equals(this.getSchema(), other.getSchema()) && StringUtils.equals(this.getName(), other.getName()) && Arrays.equals(this.parameters, other.parameters);
        }
        return super.equals(that);
    }
}

