/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.AttachableInternal;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.RowN;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.exception.DetachedException;
import org.jooq.impl.AbstractKey;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.Tools;

class ReferenceImpl<R extends Record, O extends Record>
extends AbstractKey<R>
implements ForeignKey<R, O> {
    private static final long serialVersionUID = 3636724364192618701L;
    private final UniqueKey<O> key;

    @SafeVarargs
    ReferenceImpl(UniqueKey<O> key, Table<R> table, TableField<R, ?> ... fields) {
        super(table, fields);
        this.key = key;
    }

    @Override
    public final UniqueKey<O> getKey() {
        return this.key;
    }

    @Override
    public final O fetchParent(R record) {
        return (O)Tools.filterOne(this.fetchParents(new Record[]{record}));
    }

    @Override
    @SafeVarargs
    public final Result<O> fetchParents(R ... records) {
        return this.fetchParents((Collection<? extends R>)Tools.list(records));
    }

    @Override
    public final Result<R> fetchChildren(O record) {
        return this.fetchChildren((Collection<? extends O>)Tools.list(record));
    }

    @Override
    @SafeVarargs
    public final Result<R> fetchChildren(O ... records) {
        return this.fetchChildren((Collection<? extends O>)Tools.list(records));
    }

    @Override
    public final Result<O> fetchParents(Collection<? extends R> records) {
        if (records == null || records.size() == 0) {
            return new ResultImpl((Configuration)new DefaultConfiguration(), this.key.getFields());
        }
        return ReferenceImpl.fetch(records, this.key.getTable(), this.key.getFieldsArray(), this.getFieldsArray());
    }

    @Override
    public final Result<R> fetchChildren(Collection<? extends O> records) {
        if (records == null || records.size() == 0) {
            return new ResultImpl((Configuration)new DefaultConfiguration(), this.getFields());
        }
        return ReferenceImpl.fetch(records, this.getTable(), this.getFieldsArray(), this.key.getFieldsArray());
    }

    private static <R1 extends Record, R2 extends Record> Result<R1> fetch(Collection<? extends R2> records, Table<R1> table, TableField<R1, ?>[] fields1, TableField<R2, ?>[] fields2) {
        if (fields1.length == 1) {
            return ReferenceImpl.extractDSLContext(records).selectFrom(table).where(fields1[0].in((Collection<?>)ReferenceImpl.extractValues(records, fields2[0]))).fetch();
        }
        return ReferenceImpl.extractDSLContext(records).selectFrom(table).where(DSL.row(fields1).in(ReferenceImpl.extractRows(records, fields2))).fetch();
    }

    private static <R extends Record> List<Object> extractValues(Collection<? extends R> records, TableField<R, ?> field2) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Record record : records) {
            result.add(record.getValue(field2));
        }
        return result;
    }

    private static <R extends Record> List<RowN> extractRows(Collection<? extends R> records, TableField<R, ?>[] fields) {
        ArrayList<RowN> rows = new ArrayList<RowN>();
        for (Record record : records) {
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values[i] = record.getValue(fields[i]);
            }
            rows.add(DSL.row(values));
        }
        return rows;
    }

    private static <R extends Record> DSLContext extractDSLContext(Collection<? extends R> records) throws DetachedException {
        Record first = (Record)Tools.first(records);
        if (first instanceof AttachableInternal) {
            return DSL.using(((AttachableInternal)((Object)first)).configuration());
        }
        throw new DetachedException("Supply at least one attachable record");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FOREIGN KEY (");
        String s1 = "";
        for (Field field : this.getFields()) {
            sb.append(s1);
            sb.append(DSL.name(field.getName()));
            s1 = ", ";
        }
        sb.append(") REFERENCES ");
        sb.append(this.key.getTable());
        sb.append("(");
        String s2 = "";
        for (Field field : this.key.getFields()) {
            sb.append(s2);
            sb.append(DSL.name(field.getName()));
            s2 = ", ";
        }
        sb.append(")");
        return sb.toString();
    }
}

