/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.Merge;
import org.jooq.MergeNotMatchedStep;
import org.jooq.MergeOnConditionStep;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractStoreQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldMapForInsert;
import org.jooq.impl.FieldMapForUpdate;
import org.jooq.impl.FieldMapsForInsert;
import org.jooq.impl.Fields;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;

class InsertQueryImpl<R extends Record>
extends AbstractStoreQuery<R>
implements InsertQuery<R> {
    private static final long serialVersionUID = 4466005417945353842L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.INSERT};
    private final FieldMapForUpdate updateMap = new FieldMapForUpdate(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
    private final FieldMapsForInsert insertMaps = new FieldMapsForInsert();
    private Select<?> select;
    private boolean defaultValues;
    private boolean onDuplicateKeyUpdate;
    private boolean onDuplicateKeyIgnore;

    InsertQueryImpl(Configuration configuration, WithImpl with, Table<R> into) {
        super(configuration, with, into);
    }

    @Override
    public final void newRecord() {
        this.insertMaps.newRecord();
    }

    protected final FieldMapForInsert getValues() {
        return this.insertMaps.getMap();
    }

    @Override
    public final void addRecord(R record) {
        this.newRecord();
        this.setRecord(record);
    }

    @Override
    public final void onDuplicateKeyUpdate(boolean flag) {
        this.onDuplicateKeyIgnore = false;
        this.onDuplicateKeyUpdate = flag;
    }

    @Override
    public final void onDuplicateKeyIgnore(boolean flag) {
        this.onDuplicateKeyUpdate = false;
        this.onDuplicateKeyIgnore = flag;
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, T value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, Field<T> value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final void addValuesForUpdate(Map<? extends Field<?>, ?> map) {
        this.updateMap.set(map);
    }

    @Override
    public final void setDefaultValues() {
        this.defaultValues = true;
    }

    @Override
    public final void setSelect(Field<?>[] f, Select<?> s) {
        this.insertMaps.getMap().putFields(Arrays.asList(f));
        this.select = s;
    }

    @Override
    public final void addValues(Map<? extends Field<?>, ?> map) {
        this.insertMaps.getMap().set(map);
    }

    @Override
    final void accept0(Context<?> ctx) {
        block17: {
            block16: {
                if (!this.onDuplicateKeyUpdate) break block16;
                switch (ctx.family()) {
                    case CUBRID: 
                    case MARIADB: 
                    case MYSQL: {
                        this.toSQLInsert(ctx);
                        ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).keyword("on duplicate key update").sql(' ').visit(this.updateMap).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                        break block17;
                    }
                    case POSTGRES: {
                        this.toSQLInsert(ctx);
                        ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).keyword("on conflict").sql(" (");
                        if (this.table.getPrimaryKey() == null) {
                            ctx.sql("[unknown primary key]");
                        } else {
                            boolean qualify = ctx.qualify();
                            ctx.qualify(false).visit(new Fields(this.table.getPrimaryKey().getFields())).qualify(qualify);
                        }
                        ctx.sql(") ").keyword("do update").formatSeparator().keyword("set").sql(' ').formatIndentLockStart().visit(this.updateMap).formatIndentLockEnd().end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                        break block17;
                    }
                    case H2: {
                        throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY UPDATE clause cannot be emulated for " + (Object)((Object)ctx.dialect()));
                    }
                    case HSQLDB: {
                        ctx.visit(this.toMerge(ctx.configuration()));
                        break block17;
                    }
                    default: {
                        throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY UPDATE clause cannot be emulated for " + (Object)((Object)ctx.dialect()));
                    }
                }
            }
            if (this.onDuplicateKeyIgnore) {
                switch (ctx.dialect()) {
                    case MARIADB: 
                    case MYSQL: 
                    case SQLITE: {
                        this.toSQLInsert(ctx);
                        ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                        break;
                    }
                    case POSTGRES_9_5: {
                        this.toSQLInsert(ctx);
                        ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).keyword("on conflict do nothing").end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                        break;
                    }
                    case CUBRID: {
                        FieldMapForUpdate update = new FieldMapForUpdate(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
                        Field<?> field = this.table.field(0);
                        update.put(field, field);
                        this.toSQLInsert(ctx);
                        ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).keyword("on duplicate key update").sql(' ').visit(update).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                        break;
                    }
                    case HSQLDB: {
                        ctx.visit(this.toMerge(ctx.configuration()));
                        break;
                    }
                    default: {
                        ctx.visit(this.toInsertSelect(ctx.configuration()));
                        break;
                    }
                }
            } else {
                this.toSQLInsert(ctx);
                ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
            }
        }
        ctx.start(Clause.INSERT_RETURNING);
        this.toSQLReturning(ctx);
        ctx.end(Clause.INSERT_RETURNING);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final void toSQLInsert(Context<?> ctx) {
        boolean declareTables = ctx.declareTables();
        ctx.start(Clause.INSERT_INSERT_INTO).keyword("insert").sql(' ').keyword(this.onDuplicateKeyIgnore && Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)ctx.family()) ? "ignore " : (this.onDuplicateKeyIgnore && SQLDialect.SQLITE == ctx.family() ? "or ignore " : "")).keyword("into").sql(' ').declareTables(true).visit(this.table).declareTables(declareTables);
        if (this.insertMaps.isExecutable()) {
            ctx.sql(' ');
            this.insertMaps.insertMaps.get(0).toSQLReferenceKeys(ctx);
        }
        ctx.end(Clause.INSERT_INSERT_INTO);
        if (this.select != null) {
            ctx.formatSeparator().start(Clause.INSERT_SELECT).visit(this.select).end(Clause.INSERT_SELECT);
        } else if (this.defaultValues) {
            switch (ctx.family()) {
                case MARIADB: 
                case MYSQL: 
                case DERBY: {
                    ctx.formatSeparator().keyword("values").sql('(');
                    int count = this.table.fields().length;
                    String separator = "";
                    for (int i = 0; i < count; ++i) {
                        ctx.sql(separator);
                        ctx.keyword("default");
                        separator = ", ";
                    }
                    ctx.sql(')');
                    break;
                }
                default: {
                    ctx.formatSeparator().keyword("default values");
                    break;
                }
            }
        } else {
            ctx.visit(this.insertMaps);
        }
    }

    private final QueryPart toInsertSelect(Configuration configuration) {
        if (this.table.getPrimaryKey() != null) {
            return this.create(configuration).insertInto(this.table).columns(this.insertMaps.getMap().keySet()).select(DSL.select(this.insertMaps.getMap().values()).whereNotExists(DSL.selectOne().from((TableLike<?>)this.table).where(this.matchByPrimaryKey())));
        }
        throw new IllegalStateException("The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into non-updatable tables : " + this.table);
    }

    private final Merge<R> toMerge(Configuration configuration) {
        if (this.table.getPrimaryKey() != null) {
            MergeOnConditionStep on;
            MergeNotMatchedStep notMatched = on = this.create(configuration).mergeInto(this.table).usingDual().on(this.matchByPrimaryKey());
            if (this.onDuplicateKeyUpdate) {
                notMatched = on.whenMatchedThenUpdate().set(this.updateMap);
            }
            return notMatched.whenNotMatchedThenInsert(this.insertMaps.getMap().keySet()).values(this.insertMaps.getMap().values());
        }
        throw new IllegalStateException("The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into non-updatable tables : " + this.table);
    }

    private final Condition matchByPrimaryKey() {
        Condition condition = null;
        Iterator iterator = this.table.getPrimaryKey().getFields().iterator();
        while (iterator.hasNext()) {
            Field f;
            Field field = f = (Field)iterator.next();
            Field value = (Field)this.insertMaps.getMap().get(field);
            Condition other = field.equal(value);
            if (condition == null) {
                condition = other;
                continue;
            }
            condition = condition.and(other);
        }
        return condition;
    }

    @Override
    public final boolean isExecutable() {
        return this.insertMaps.isExecutable() || this.defaultValues || this.select != null;
    }
}

