/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractQueryPartMap;
import org.jooq.impl.Tools;

class FieldMapForInsert
extends AbstractQueryPartMap<Field<?>, Field<?>> {
    private static final long serialVersionUID = -2192833491610583485L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD_ROW};

    FieldMapForInsert() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean indent = this.size() > 1;
        ctx.sql('(');
        if (indent) {
            ctx.formatIndentStart();
        }
        String separator = "";
        for (Field field : this.values()) {
            ctx.sql(separator);
            if (indent) {
                ctx.formatNewLine();
            }
            ctx.visit(field);
            separator = ", ";
        }
        if (indent) {
            ctx.formatIndentEnd().formatNewLine();
        }
        ctx.sql(')');
    }

    final void toSQLReferenceKeys(Context<?> ctx) {
        boolean indent = this.size() > 1;
        ctx.sql('(');
        if (indent) {
            ctx.formatIndentStart();
        }
        boolean qualify = ctx.qualify();
        ctx.qualify(false);
        String separator = "";
        for (Field field : this.keySet()) {
            ctx.sql(separator);
            if (indent) {
                ctx.formatNewLine();
            }
            ctx.visit(field);
            separator = ", ";
        }
        ctx.qualify(qualify);
        if (indent) {
            ctx.formatIndentEnd().formatNewLine();
        }
        ctx.sql(')');
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    final void putFields(Collection<? extends Field<?>> fields) {
        for (Field<?> field : fields) {
            this.put(field, null);
        }
    }

    final void putValues(Collection<? extends Field<?>> values) {
        if (values.size() != this.size()) {
            throw new IllegalArgumentException("The number of values must match the number of fields: " + this);
        }
        Iterator<Field<?>> it = values.iterator();
        for (Map.Entry entry : this.entrySet()) {
            entry.setValue(it.next());
        }
    }

    final void set(Map<? extends Field<?>, ?> map) {
        for (Map.Entry<Field<?>, ?> entry : map.entrySet()) {
            Field<?> field = entry.getKey();
            Object value = entry.getValue();
            this.put((QueryPart)entry.getKey(), Tools.field(value, field));
        }
    }
}

