/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;

class ArrayTableEmulation
extends AbstractTable<Record> {
    private static final long serialVersionUID = 2392515064450536343L;
    private final Object[] array;
    private final Fields<Record> field;
    private final String alias;
    private final String fieldAlias;
    private transient Table<Record> table;

    ArrayTableEmulation(Object[] array) {
        this(array, "array_table", null);
    }

    ArrayTableEmulation(Object[] array, String alias) {
        this(array, alias, null);
    }

    ArrayTableEmulation(Object[] array, String alias, String fieldAlias) {
        super(alias);
        this.array = array;
        this.alias = alias;
        this.fieldAlias = fieldAlias == null ? "COLUMN_VALUE" : fieldAlias;
        this.field = new Fields(DSL.field(DSL.name(alias, this.fieldAlias), DSL.getDataType(array.getClass().getComponentType())));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final Table<Record> as(String as) {
        return new ArrayTableEmulation(this.array, as);
    }

    @Override
    public final Table<Record> as(String as, String ... fieldAliases) {
        if (fieldAliases == null) {
            return new ArrayTableEmulation(this.array, as);
        }
        if (fieldAliases.length == 1) {
            return new ArrayTableEmulation(this.array, as, fieldAliases[0]);
        }
        throw new IllegalArgumentException("Array table simulations can only have a single field alias");
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    @Override
    final Fields<Record> fields0() {
        return this.field;
    }

    private final Table<Record> table(Configuration configuration) {
        if (this.table == null) {
            Select<Record> select = null;
            for (Object element : this.array) {
                Param<?> val = DSL.val(element, this.field.fields[0].getDataType());
                SelectSelectStep<Record> subselect = DSL.using(configuration).select(val.as("COLUMN_VALUE")).select(new SelectField[0]);
                select = select == null ? subselect : select.unionAll(subselect);
            }
            if (select == null) {
                select = DSL.using(configuration).select(DSL.one().as("COLUMN_VALUE")).select(new SelectField[0]).where(DSL.falseCondition());
            }
            this.table = select.asTable(this.alias);
        }
        return this.table;
    }
}

