/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools;

import org.jooq.tools.JooqLogger;

public final class StopWatch {
    private static final JooqLogger log = JooqLogger.getLogger(StopWatch.class);
    private long start;
    private long split;

    public StopWatch() {
        this.split = this.start = System.nanoTime();
    }

    public void splitTrace(String message) {
        if (log.isTraceEnabled()) {
            log.trace((Object)message, this.splitMessage());
        }
    }

    public void splitDebug(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message, this.splitMessage());
        }
    }

    public void splitInfo(String message) {
        if (log.isInfoEnabled()) {
            log.info((Object)message, this.splitMessage());
        }
    }

    public long split() {
        return System.nanoTime() - this.start;
    }

    private String splitMessage() {
        long temp = this.split;
        this.split = System.nanoTime();
        if (temp == this.start) {
            return "Total: " + StopWatch.format(this.split - this.start);
        }
        return "Total: " + StopWatch.format(this.split - this.start) + ", +" + StopWatch.format(this.split - temp);
    }

    public static String format(long nanoTime) {
        if (nanoTime > 60000000000L) {
            return StopWatch.formatHours(nanoTime / 1000000000L);
        }
        if (nanoTime > 1000000000L) {
            return (double)(nanoTime / 1000000L) / 1000.0 + "s";
        }
        return (double)(nanoTime / 1000L) / 1000.0 + "ms";
    }

    public static String formatHours(long seconds) {
        long s = seconds % 60L;
        long m = seconds / 60L % 60L;
        long h = seconds / 3600L;
        StringBuilder sb = new StringBuilder();
        if (h != 0L) {
            if (h < 10L) {
                sb.append("0");
                sb.append(h);
                sb.append(":");
            } else {
                sb.append(h);
                sb.append(":");
            }
        }
        if (m < 10L) {
            sb.append("0");
            sb.append(m);
            sb.append(":");
        } else {
            sb.append(m);
            sb.append(":");
        }
        if (s < 10L) {
            sb.append("0");
            sb.append(s);
        } else {
            sb.append(s);
        }
        return sb.toString();
    }
}

