/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Map;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractQueryPartMap;
import org.jooq.impl.Tools;

class FieldMapForUpdate
extends AbstractQueryPartMap<Field<?>, Field<?>> {
    private static final long serialVersionUID = -6139709404698673799L;
    private final Clause assignmentClause;

    FieldMapForUpdate(Clause assignmentClause) {
        this.assignmentClause = assignmentClause;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.size() > 0) {
            String separator = "";
            boolean restoreQualify = ctx.qualify();
            boolean supportsQualify = Arrays.asList(SQLDialect.POSTGRES, SQLDialect.SQLITE).contains((Object)ctx.family()) ? false : restoreQualify;
            for (Map.Entry entry : this.entrySet()) {
                ctx.sql(separator);
                if (!"".equals(separator)) {
                    ctx.formatNewLine();
                }
                ctx.start(this.assignmentClause).qualify(supportsQualify).visit((QueryPart)entry.getKey()).qualify(restoreQualify).sql(" = ").visit((QueryPart)entry.getValue()).end(this.assignmentClause);
                separator = ", ";
            }
        } else {
            ctx.sql("[ no fields are updated ]");
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    final void set(Map<? extends Field<?>, ?> map) {
        for (Map.Entry<Field<?>, ?> entry : map.entrySet()) {
            Field<?> field = entry.getKey();
            Object value = entry.getValue();
            this.put((QueryPart)entry.getKey(), Tools.field(value, field));
        }
    }
}

