/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jooq.Attachable;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Scope;
import org.jooq.UDTRecord;
import org.jooq.conf.ParamType;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.MappingException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBindingSQLContext;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.jdbc.MockArray;
import org.jooq.tools.reflect.Reflect;
import org.jooq.types.DayToSecond;
import org.jooq.types.Interval;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UNumber;
import org.jooq.types.UShort;
import org.jooq.types.YearToMonth;
import org.jooq.util.postgres.PostgresUtils;

public class DefaultBinding<T, U>
implements Binding<T, U> {
    static final JooqLogger log = JooqLogger.getLogger(DefaultBinding.class);
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private static final long serialVersionUID = -198499389344950496L;
    final Class<T> type;
    final Converter<T, U> converter;
    @Deprecated
    final boolean isLob;

    public DefaultBinding(Converter<T, U> converter) {
        this(converter, false);
    }

    DefaultBinding(Converter<T, U> converter, boolean isLob) {
        this.type = converter.fromType();
        this.converter = converter;
        this.isLob = isLob;
    }

    static <T, X, U> Binding<T, U> newBinding(final Converter<X, U> converter, DataType<T> type, final Binding<T, X> binding) {
        Binding<Object, Object> theBinding = converter == null && binding == null ? type.getBinding() : (converter == null ? binding : (binding == null ? new DefaultBinding<X, U>(converter, type.isLob()) : new Binding<T, U>(){
            private static final long serialVersionUID = 8912340791845209886L;
            final Converter<T, U> theConverter;
            {
                this.theConverter = Converters.of(binding.converter(), converter);
            }

            @Override
            public Converter<T, U> converter() {
                return this.theConverter;
            }

            @Override
            public void sql(BindingSQLContext<U> ctx) throws SQLException {
                binding.sql(ctx.convert(converter));
            }

            @Override
            public void register(BindingRegisterContext<U> ctx) throws SQLException {
                binding.register(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetStatementContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetStatementContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }
        }));
        return theBinding;
    }

    @Override
    public Converter<T, U> converter() {
        return this.converter;
    }

    @Override
    public void sql(BindingSQLContext<U> ctx) {
        T converted = this.converter.to(ctx.value());
        switch (ctx.render().castMode()) {
            case NEVER: {
                this.toSQL(ctx, converted);
                return;
            }
            case ALWAYS: {
                this.toSQLCast(ctx, converted);
                return;
            }
        }
        if (this.shouldCast(ctx, converted)) {
            this.toSQLCast(ctx, converted);
        } else {
            this.toSQL(ctx, converted);
        }
    }

    private final boolean shouldCast(BindingSQLContext<U> ctx, T converted) {
        if (ctx.render().paramType() != ParamType.INLINED && !(converted instanceof EnumType)) {
            switch (ctx.family()) {
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: 
                case CUBRID: 
                case POSTGRES: {
                    return true;
                }
            }
        }
        if (Interval.class.isAssignableFrom(this.type)) {
            switch (ctx.family()) {
                case POSTGRES: {
                    return true;
                }
            }
        }
        if (this.type == OffsetTime.class || this.type == OffsetDateTime.class) {
            switch (ctx.family()) {
                case POSTGRES: {
                    return true;
                }
            }
        }
        return false;
    }

    private final void toSQLCast(BindingSQLContext<U> ctx, T converted) {
        DataType<T> dataType = DefaultDataType.getDataType(ctx.dialect(), this.type);
        DataType<T> sqlDataType = dataType.getSQLDataType();
        SQLDialect family = ctx.family();
        if (converted != null && this.type == BigDecimal.class && Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB).contains((Object)family)) {
            int scale = ((BigDecimal)converted).scale();
            int precision = scale + ((BigDecimal)converted).precision();
            if (family == SQLDialect.FIREBIRD) {
                precision = Math.min(precision, 18);
            }
            this.toSQLCast(ctx, converted, dataType, 0, precision, scale);
        } else if (SQLDataType.OTHER == sqlDataType) {
            if (converted != null) {
                this.toSQLCast(ctx, converted, DefaultDataType.getDataType(family, converted.getClass()), 0, 0, 0);
            } else if (Arrays.asList(new Object[0]).contains((Object)family)) {
                ctx.render().sql(ctx.variable());
            } else {
                this.toSQLCast(ctx, converted, DefaultDataType.getDataType(family, String.class), 0, 0, 0);
            }
        } else if (Arrays.asList(SQLDialect.POSTGRES).contains((Object)family) && (sqlDataType == null || !sqlDataType.isTemporal())) {
            this.toSQL(ctx, converted);
        } else if ((sqlDataType == SQLDataType.VARCHAR || sqlDataType == SQLDataType.CHAR) && Arrays.asList(SQLDialect.FIREBIRD).contains((Object)family)) {
            this.toSQLCast(ctx, converted, dataType, this.getValueLength(converted), 0, 0);
        } else {
            this.toSQLCast(ctx, converted, dataType, dataType.length(), dataType.precision(), dataType.scale());
        }
    }

    private final int getValueLength(T value) {
        String string = (String)value;
        if (string == null) {
            return 1;
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return Math.min(32672, 4 * length);
        }
        return Math.min(32672, length);
    }

    private final void toSQLCast(BindingSQLContext<U> ctx, T converted, DataType<?> dataType, int length, int precision, int scale) {
        ctx.render().keyword("cast").sql('(');
        this.toSQL(ctx, converted);
        ctx.render().sql(' ').keyword("as").sql(' ').sql(dataType.length(length).precision(precision, scale).getCastTypeName(ctx.configuration())).sql(')');
    }

    private final void toSQL(BindingSQLContext<U> ctx, Object val) {
        SQLDialect family = ctx.family();
        RenderContext render = ctx.render();
        if (render.paramType() == ParamType.INLINED) {
            if (val == null) {
                render.keyword("null");
            } else if (this.type == Boolean.class) {
                if (Arrays.asList(SQLDialect.FIREBIRD, SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql((Boolean)val != false ? "1" : "0");
                } else {
                    render.keyword(((Boolean)val).toString());
                }
            } else if (this.type == byte[].class) {
                byte[] binary = (byte[])val;
                if (Arrays.asList(new Object[0]).contains((Object)family)) {
                    render.sql("0x").sql(DefaultBinding.convertBytesToHex(binary));
                } else if (Arrays.asList(SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql("X'").sql(DefaultBinding.convertBytesToHex(binary)).sql('\'');
                } else if (Arrays.asList(new Object[0]).contains((Object)family)) {
                    render.keyword("hextoraw('").sql(DefaultBinding.convertBytesToHex(binary)).sql("')");
                } else if (family == SQLDialect.POSTGRES) {
                    render.sql("E'").sql(PostgresUtils.toPGString(binary)).keyword("'::bytea");
                } else {
                    render.sql("X'").sql(DefaultBinding.convertBytesToHex(binary)).sql('\'');
                }
            } else if (Interval.class.isAssignableFrom(this.type)) {
                render.sql('\'').sql(this.escape(val, render)).sql('\'');
            } else if (Number.class.isAssignableFrom(this.type)) {
                render.sql(((Number)val).toString());
            } else if (this.type == Date.class) {
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql('\'').sql(this.escape(val, render)).sql('\'');
                } else if (family == SQLDialect.DERBY) {
                    render.keyword("date('").sql(this.escape(val, render)).sql("')");
                } else if (family == SQLDialect.MYSQL) {
                    render.keyword("{d '").sql(this.escape(val, render)).sql("'}");
                } else {
                    render.keyword("date '").sql(this.escape(val, render)).sql('\'');
                }
            } else if (this.type == Timestamp.class) {
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql('\'').sql(this.escape(val, render)).sql('\'');
                } else if (family == SQLDialect.DERBY) {
                    render.keyword("timestamp('").sql(this.escape(val, render)).sql("')");
                } else if (family == SQLDialect.CUBRID) {
                    render.keyword("datetime '").sql(this.escape(val, render)).sql('\'');
                } else if (family == SQLDialect.MYSQL) {
                    render.keyword("{ts '").sql(this.escape(val, render)).sql("'}");
                } else {
                    render.keyword("timestamp '").sql(this.escape(val, render)).sql('\'');
                }
            } else if (this.type == Time.class) {
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    render.sql('\'').sql(new SimpleDateFormat("HH:mm:ss").format((Time)val)).sql('\'');
                } else if (family == SQLDialect.DERBY) {
                    render.keyword("time").sql("('").sql(this.escape(val, render)).sql("')");
                } else if (family == SQLDialect.MYSQL) {
                    render.keyword("{t '").sql(this.escape(val, render)).sql("'}");
                } else {
                    render.keyword("time").sql(" '").sql(this.escape(val, render)).sql('\'');
                }
            } else if (this.type.isArray()) {
                String separator = "";
                if (family == SQLDialect.H2) {
                    render.sql('(');
                    for (Object o : (Object[])val) {
                        render.sql(separator);
                        new DefaultBinding(Converters.identity(this.type.getComponentType()), this.isLob).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                        separator = ", ";
                    }
                    render.sql(')');
                } else if (family == SQLDialect.POSTGRES) {
                    render.visit(DSL.inline(PostgresUtils.toPGArrayString((Object[])val)));
                } else {
                    render.keyword("ARRAY");
                    render.sql('[');
                    for (Object o : (Object[])val) {
                        render.sql(separator);
                        new DefaultBinding(Converters.identity(this.type.getComponentType()), this.isLob).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                        separator = ", ";
                    }
                    render.sql(']');
                    if (family == SQLDialect.POSTGRES && EnumType.class.isAssignableFrom(this.type.getComponentType())) {
                        DefaultBinding.pgRenderEnumCast(render, this.type);
                    }
                }
            } else if (EnumType.class.isAssignableFrom(this.type)) {
                String literal = ((EnumType)val).getLiteral();
                if (literal == null) {
                    new DefaultBinding<String, String>(Converters.identity(String.class), this.isLob).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
                } else {
                    new DefaultBinding<String, String>(Converters.identity(String.class), this.isLob).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
                }
            } else if (UDTRecord.class.isAssignableFrom(this.type)) {
                render.sql("[UDT]");
            } else {
                render.sql('\'').sql(this.escape(val, render), true).sql('\'');
            }
        } else if (family == SQLDialect.POSTGRES) {
            if (EnumType.class.isAssignableFrom(this.type) || this.type.isArray() && EnumType.class.isAssignableFrom(this.type.getComponentType())) {
                render.sql(ctx.variable());
                DefaultBinding.pgRenderEnumCast(render, this.type);
            } else if (this.type.isArray() && byte[].class != this.type) {
                render.sql(ctx.variable());
                render.sql("::");
                render.keyword(DefaultDataType.getDataType(family, this.type).getCastTypeName(render.configuration()));
            } else {
                render.sql(ctx.variable());
            }
        } else {
            render.sql(ctx.variable());
        }
    }

    private final String escape(Object val, Context<?> context) {
        String result = val.toString();
        if (Tools.needsBackslashEscaping(context.configuration())) {
            result = result.replace("\\", "\\\\");
        }
        return result.replace("'", "''");
    }

    private static final String convertBytesToHex(byte[] value) {
        return DefaultBinding.convertBytesToHex(value, value.length);
    }

    private static final String convertBytesToHex(byte[] value, int len) {
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    @Override
    public void register(BindingRegisterContext<U> ctx) throws SQLException {
        Configuration configuration = ctx.configuration();
        int sqlType = DefaultDataType.getDataType(ctx.dialect(), this.type).getSQLType();
        switch (configuration.dialect().family()) {
            default: 
        }
        ctx.statement().registerOutParameter(ctx.index(), sqlType);
    }

    @Override
    public void set(BindingSetStatementContext<U> ctx) throws SQLException {
        block36: {
            Class<Object> actualType;
            T value;
            block65: {
                SQLDialect dialect;
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        block58: {
                                            block57: {
                                                block56: {
                                                    block55: {
                                                        block54: {
                                                            block53: {
                                                                block52: {
                                                                    block51: {
                                                                        block50: {
                                                                            block49: {
                                                                                block48: {
                                                                                    block47: {
                                                                                        block46: {
                                                                                            block45: {
                                                                                                block44: {
                                                                                                    block43: {
                                                                                                        block42: {
                                                                                                            block41: {
                                                                                                                block40: {
                                                                                                                    block39: {
                                                                                                                        block38: {
                                                                                                                            block37: {
                                                                                                                                block35: {
                                                                                                                                    Configuration configuration = ctx.configuration();
                                                                                                                                    dialect = ctx.dialect();
                                                                                                                                    value = this.converter.to(ctx.value());
                                                                                                                                    if (log.isTraceEnabled()) {
                                                                                                                                        if (value != null && value.getClass().isArray() && value.getClass() != byte[].class) {
                                                                                                                                            log.trace((Object)("Binding variable " + ctx.index()), Arrays.asList((Object[])value) + " (" + this.type + ")");
                                                                                                                                        } else {
                                                                                                                                            log.trace((Object)("Binding variable " + ctx.index()), value + " (" + this.type + ")");
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (value != null) break block35;
                                                                                                                                    int sqlType = DefaultDataType.getDataType(dialect, this.type).getSQLType();
                                                                                                                                    if (UDTRecord.class.isAssignableFrom(this.type)) {
                                                                                                                                        ctx.statement().setNull(ctx.index(), sqlType, Tools.getMappedUDTName(configuration, this.type));
                                                                                                                                    } else if (Arrays.asList(SQLDialect.POSTGRES).contains((Object)configuration.family()) && sqlType == 2004) {
                                                                                                                                        ctx.statement().setNull(ctx.index(), -2);
                                                                                                                                    } else if (sqlType != 1111) {
                                                                                                                                        ctx.statement().setNull(ctx.index(), sqlType);
                                                                                                                                    } else {
                                                                                                                                        ctx.statement().setObject(ctx.index(), null);
                                                                                                                                    }
                                                                                                                                    break block36;
                                                                                                                                }
                                                                                                                                actualType = this.type;
                                                                                                                                if (actualType == Object.class) {
                                                                                                                                    actualType = value.getClass();
                                                                                                                                }
                                                                                                                                if (actualType != Blob.class) break block37;
                                                                                                                                ctx.statement().setBlob(ctx.index(), (Blob)value);
                                                                                                                                break block36;
                                                                                                                            }
                                                                                                                            if (actualType != Boolean.class) break block38;
                                                                                                                            ctx.statement().setBoolean(ctx.index(), (Boolean)value);
                                                                                                                            break block36;
                                                                                                                        }
                                                                                                                        if (actualType != BigDecimal.class) break block39;
                                                                                                                        if (Arrays.asList(SQLDialect.SQLITE).contains((Object)dialect.family())) {
                                                                                                                            ctx.statement().setString(ctx.index(), value.toString());
                                                                                                                        } else {
                                                                                                                            ctx.statement().setBigDecimal(ctx.index(), (BigDecimal)value);
                                                                                                                        }
                                                                                                                        break block36;
                                                                                                                    }
                                                                                                                    if (actualType != BigInteger.class) break block40;
                                                                                                                    if (Arrays.asList(SQLDialect.SQLITE).contains((Object)dialect.family())) {
                                                                                                                        ctx.statement().setString(ctx.index(), value.toString());
                                                                                                                    } else {
                                                                                                                        ctx.statement().setBigDecimal(ctx.index(), new BigDecimal((BigInteger)value));
                                                                                                                    }
                                                                                                                    break block36;
                                                                                                                }
                                                                                                                if (actualType != Byte.class) break block41;
                                                                                                                ctx.statement().setByte(ctx.index(), (Byte)value);
                                                                                                                break block36;
                                                                                                            }
                                                                                                            if (actualType != byte[].class) break block42;
                                                                                                            ctx.statement().setBytes(ctx.index(), (byte[])value);
                                                                                                            break block36;
                                                                                                        }
                                                                                                        if (actualType != Clob.class) break block43;
                                                                                                        ctx.statement().setClob(ctx.index(), (Clob)value);
                                                                                                        break block36;
                                                                                                    }
                                                                                                    if (actualType != Double.class) break block44;
                                                                                                    ctx.statement().setDouble(ctx.index(), (Double)value);
                                                                                                    break block36;
                                                                                                }
                                                                                                if (actualType != Float.class) break block45;
                                                                                                ctx.statement().setFloat(ctx.index(), ((Float)value).floatValue());
                                                                                                break block36;
                                                                                            }
                                                                                            if (actualType != Integer.class) break block46;
                                                                                            ctx.statement().setInt(ctx.index(), (Integer)value);
                                                                                            break block36;
                                                                                        }
                                                                                        if (actualType != Long.class) break block47;
                                                                                        ctx.statement().setLong(ctx.index(), (Long)value);
                                                                                        break block36;
                                                                                    }
                                                                                    if (actualType != Short.class) break block48;
                                                                                    ctx.statement().setShort(ctx.index(), (Short)value);
                                                                                    break block36;
                                                                                }
                                                                                if (actualType != String.class) break block49;
                                                                                ctx.statement().setString(ctx.index(), (String)value);
                                                                                break block36;
                                                                            }
                                                                            if (actualType != Date.class) break block50;
                                                                            if (dialect == SQLDialect.SQLITE) {
                                                                                ctx.statement().setString(ctx.index(), ((Date)value).toString());
                                                                            } else {
                                                                                ctx.statement().setDate(ctx.index(), (Date)value);
                                                                            }
                                                                            break block36;
                                                                        }
                                                                        if (actualType != Time.class) break block51;
                                                                        if (dialect == SQLDialect.SQLITE) {
                                                                            ctx.statement().setString(ctx.index(), ((Time)value).toString());
                                                                        } else {
                                                                            ctx.statement().setTime(ctx.index(), (Time)value);
                                                                        }
                                                                        break block36;
                                                                    }
                                                                    if (actualType != Timestamp.class) break block52;
                                                                    if (dialect == SQLDialect.SQLITE) {
                                                                        ctx.statement().setString(ctx.index(), ((Timestamp)value).toString());
                                                                    } else {
                                                                        ctx.statement().setTimestamp(ctx.index(), (Timestamp)value);
                                                                    }
                                                                    break block36;
                                                                }
                                                                if (actualType != LocalDate.class) break block53;
                                                                ctx.statement().setDate(ctx.index(), Date.valueOf((LocalDate)value));
                                                                break block36;
                                                            }
                                                            if (actualType != LocalTime.class) break block54;
                                                            ctx.statement().setTime(ctx.index(), Time.valueOf((LocalTime)value));
                                                            break block36;
                                                        }
                                                        if (actualType != LocalDateTime.class) break block55;
                                                        ctx.statement().setTimestamp(ctx.index(), Timestamp.valueOf((LocalDateTime)value));
                                                        break block36;
                                                    }
                                                    if (actualType != OffsetTime.class) break block56;
                                                    ctx.statement().setString(ctx.index(), value.toString());
                                                    break block36;
                                                }
                                                if (actualType != OffsetDateTime.class) break block57;
                                                ctx.statement().setString(ctx.index(), value.toString());
                                                break block36;
                                            }
                                            if (actualType != YearToMonth.class) break block58;
                                            if (dialect.family() == SQLDialect.POSTGRES) {
                                                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval((YearToMonth)value));
                                            } else {
                                                ctx.statement().setString(ctx.index(), value.toString());
                                            }
                                            break block36;
                                        }
                                        if (actualType != DayToSecond.class) break block59;
                                        if (dialect.family() == SQLDialect.POSTGRES) {
                                            ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval((DayToSecond)value));
                                        } else {
                                            ctx.statement().setString(ctx.index(), value.toString());
                                        }
                                        break block36;
                                    }
                                    if (actualType != UByte.class) break block60;
                                    ctx.statement().setShort(ctx.index(), ((UByte)value).shortValue());
                                    break block36;
                                }
                                if (actualType != UShort.class) break block61;
                                ctx.statement().setInt(ctx.index(), ((UShort)value).intValue());
                                break block36;
                            }
                            if (actualType != UInteger.class) break block62;
                            ctx.statement().setLong(ctx.index(), ((UInteger)value).longValue());
                            break block36;
                        }
                        if (actualType != ULong.class) break block63;
                        ctx.statement().setBigDecimal(ctx.index(), new BigDecimal(value.toString()));
                        break block36;
                    }
                    if (actualType != UUID.class) break block64;
                    switch (dialect.family()) {
                        case H2: 
                        case POSTGRES: {
                            ctx.statement().setObject(ctx.index(), value);
                            break;
                        }
                        default: {
                            ctx.statement().setString(ctx.index(), value.toString());
                            break;
                        }
                    }
                    break block36;
                }
                if (!actualType.isArray()) break block65;
                switch (dialect.family()) {
                    case POSTGRES: {
                        ctx.statement().setString(ctx.index(), PostgresUtils.toPGArrayString((Object[])value));
                        break block36;
                    }
                    case HSQLDB: {
                        Object[] a = (Object[])value;
                        Class<Object> t = actualType;
                        if (actualType == UUID[].class) {
                            a = Convert.convertArray(a, String[].class);
                            t = String[].class;
                        }
                        ctx.statement().setArray(ctx.index(), new MockArray<Object>(dialect, a, t));
                        break block36;
                    }
                    case H2: {
                        ctx.statement().setObject(ctx.index(), value);
                        break block36;
                    }
                    default: {
                        throw new SQLDialectNotSupportedException("Cannot bind ARRAY types in dialect " + (Object)((Object)dialect));
                    }
                }
            }
            if (EnumType.class.isAssignableFrom(actualType)) {
                ctx.statement().setString(ctx.index(), ((EnumType)value).getLiteral());
            } else {
                ctx.statement().setObject(ctx.index(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
        block21: {
            T value;
            block36: {
                block37: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block27: {
                                                    block28: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block20: {
                                                                                Configuration configuration = ctx.configuration();
                                                                                value = this.converter.to(ctx.value());
                                                                                if (value != null) break block20;
                                                                                ctx.output().writeObject(null);
                                                                                break block21;
                                                                            }
                                                                            if (this.type != Blob.class) break block22;
                                                                            ctx.output().writeBlob((Blob)value);
                                                                            break block21;
                                                                        }
                                                                        if (this.type != Boolean.class) break block23;
                                                                        ctx.output().writeBoolean((Boolean)value);
                                                                        break block21;
                                                                    }
                                                                    if (this.type != BigInteger.class) break block24;
                                                                    ctx.output().writeBigDecimal(new BigDecimal((BigInteger)value));
                                                                    break block21;
                                                                }
                                                                if (this.type != BigDecimal.class) break block25;
                                                                ctx.output().writeBigDecimal((BigDecimal)value);
                                                                break block21;
                                                            }
                                                            if (this.type != Byte.class) break block26;
                                                            ctx.output().writeByte((Byte)value);
                                                            break block21;
                                                        }
                                                        if (this.type != byte[].class) break block27;
                                                        if (!this.isLob) break block28;
                                                        Blob blob = null;
                                                        try {
                                                            blob = (Blob)Reflect.on("oracle.sql.BLOB").call("createTemporary", Reflect.on(ctx.output()).call("getSTRUCT").call("getJavaSqlConnection").get(), false, Reflect.on("oracle.sql.BLOB").get("DURATION_SESSION")).get();
                                                            blob.setBytes(1L, (byte[])value);
                                                            ctx.output().writeBlob(blob);
                                                        }
                                                        catch (Throwable throwable) {
                                                            DefaultExecuteContext.register(blob);
                                                            throw throwable;
                                                        }
                                                        DefaultExecuteContext.register(blob);
                                                        break block21;
                                                    }
                                                    ctx.output().writeBytes((byte[])value);
                                                    break block21;
                                                }
                                                if (this.type != Clob.class) break block29;
                                                ctx.output().writeClob((Clob)value);
                                                break block21;
                                            }
                                            if (this.type != Date.class) break block30;
                                            ctx.output().writeDate((Date)value);
                                            break block21;
                                        }
                                        if (this.type != Double.class) break block31;
                                        ctx.output().writeDouble((Double)value);
                                        break block21;
                                    }
                                    if (this.type != Float.class) break block32;
                                    ctx.output().writeFloat(((Float)value).floatValue());
                                    break block21;
                                }
                                if (this.type != Integer.class) break block33;
                                ctx.output().writeInt((Integer)value);
                                break block21;
                            }
                            if (this.type != Long.class) break block34;
                            ctx.output().writeLong((Long)value);
                            break block21;
                        }
                        if (this.type != Short.class) break block35;
                        ctx.output().writeShort((Short)value);
                        break block21;
                    }
                    if (this.type != String.class) break block36;
                    if (!this.isLob) break block37;
                    Clob clob = null;
                    try {
                        clob = (Clob)Reflect.on("oracle.sql.CLOB").call("createTemporary", Reflect.on(ctx.output()).call("getSTRUCT").call("getJavaSqlConnection").get(), false, Reflect.on("oracle.sql.CLOB").get("DURATION_SESSION")).get();
                        clob.setString(1L, (String)value);
                        ctx.output().writeClob(clob);
                    }
                    catch (Throwable throwable) {
                        DefaultExecuteContext.register(clob);
                        throw throwable;
                    }
                    DefaultExecuteContext.register(clob);
                    break block21;
                }
                ctx.output().writeString((String)value);
                break block21;
            }
            if (this.type == Time.class) {
                ctx.output().writeTime((Time)value);
            } else if (this.type == Timestamp.class) {
                ctx.output().writeTimestamp((Timestamp)value);
            } else if (this.type == YearToMonth.class) {
                ctx.output().writeString(value.toString());
            } else if (this.type == DayToSecond.class) {
                ctx.output().writeString(value.toString());
            } else if (UNumber.class.isAssignableFrom(this.type)) {
                ctx.output().writeString(value.toString());
            } else if (this.type == UUID.class) {
                ctx.output().writeString(value.toString());
            } else if (EnumType.class.isAssignableFrom(this.type)) {
                ctx.output().writeString(((EnumType)value).getLiteral());
            } else if (UDTRecord.class.isAssignableFrom(this.type)) {
                ctx.output().writeObject((UDTRecord)value);
            } else {
                throw new UnsupportedOperationException("Type " + this.type + " is not supported");
            }
        }
    }

    @Override
    public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
        Object result = null;
        if (this.type == Blob.class) {
            result = ctx.resultSet().getBlob(ctx.index());
        } else if (this.type == Boolean.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), (Boolean)ctx.resultSet().getBoolean(ctx.index()));
        } else if (this.type == BigInteger.class) {
            BigDecimal b;
            result = ctx.configuration().dialect() == SQLDialect.SQLITE ? Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigInteger.class) : ((b = ctx.resultSet().getBigDecimal(ctx.index())) == null ? null : b.toBigInteger());
        } else if (this.type == BigDecimal.class) {
            result = ctx.configuration().dialect() == SQLDialect.SQLITE ? Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigDecimal.class) : ctx.resultSet().getBigDecimal(ctx.index());
        } else if (this.type == Byte.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Byte.valueOf(ctx.resultSet().getByte(ctx.index())));
        } else if (this.type == byte[].class) {
            result = ctx.resultSet().getBytes(ctx.index());
        } else if (this.type == Clob.class) {
            result = ctx.resultSet().getClob(ctx.index());
        } else if (this.type == Date.class) {
            result = DefaultBinding.getDate(ctx.configuration().dialect(), ctx.resultSet(), ctx.index());
        } else if (this.type == Double.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Double.valueOf(ctx.resultSet().getDouble(ctx.index())));
        } else if (this.type == Float.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Float.valueOf(ctx.resultSet().getFloat(ctx.index())));
        } else if (this.type == Integer.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Integer.valueOf(ctx.resultSet().getInt(ctx.index())));
        } else if (this.type == LocalDate.class) {
            result = this.localDate(DefaultBinding.getDate(ctx.configuration().dialect(), ctx.resultSet(), ctx.index()));
        } else if (this.type == LocalTime.class) {
            result = this.localTime(DefaultBinding.getTime(ctx.configuration().dialect(), ctx.resultSet(), ctx.index()));
        } else if (this.type == LocalDateTime.class) {
            result = this.localDateTime(DefaultBinding.getTimestamp(ctx.configuration().dialect(), ctx.resultSet(), ctx.index()));
        } else if (this.type == Long.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Long.valueOf(ctx.resultSet().getLong(ctx.index())));
        } else if (this.type == OffsetTime.class) {
            result = this.offsetTime(ctx.resultSet().getString(ctx.index()));
        } else if (this.type == OffsetDateTime.class) {
            result = this.offsetDateTime(ctx.resultSet().getString(ctx.index()));
        } else if (this.type == Short.class) {
            result = JDBCUtils.wasNull(ctx.resultSet(), Short.valueOf(ctx.resultSet().getShort(ctx.index())));
        } else if (this.type == String.class) {
            result = ctx.resultSet().getString(ctx.index());
        } else if (this.type == Time.class) {
            result = DefaultBinding.getTime(ctx.configuration().dialect(), ctx.resultSet(), ctx.index());
        } else if (this.type == Timestamp.class) {
            result = DefaultBinding.getTimestamp(ctx.configuration().dialect(), ctx.resultSet(), ctx.index());
        } else if (this.type == YearToMonth.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.resultSet().getObject(ctx.index())) == null ? null : PostgresUtils.toYearToMonth(object)) : ((string = ctx.resultSet().getString(ctx.index())) == null ? null : YearToMonth.valueOf(string));
        } else if (this.type == DayToSecond.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.resultSet().getObject(ctx.index())) == null ? null : PostgresUtils.toDayToSecond(object)) : ((string = ctx.resultSet().getString(ctx.index())) == null ? null : DayToSecond.valueOf(string));
        } else if (this.type == UByte.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UByte.class);
        } else if (this.type == UShort.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UShort.class);
        } else if (this.type == UInteger.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UInteger.class);
        } else if (this.type == ULong.class) {
            result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), ULong.class);
        } else if (this.type == UUID.class) {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    result = ctx.resultSet().getObject(ctx.index());
                    break;
                }
                default: {
                    result = Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UUID.class);
                    break;
                }
            }
        } else if (this.type.isArray()) {
            switch (ctx.family()) {
                case POSTGRES: {
                    result = DefaultBinding.pgGetArray(ctx, ctx.resultSet(), this.type, ctx.index());
                    break;
                }
                default: {
                    result = DefaultBinding.convertArray(ctx.resultSet().getArray(ctx.index()), this.type);
                    break;
                }
            }
        } else if (EnumType.class.isAssignableFrom(this.type)) {
            result = DefaultBinding.getEnumType(this.type, ctx.resultSet().getString(ctx.index()));
        } else if (Record.class.isAssignableFrom(this.type)) {
            switch (ctx.family()) {
                case POSTGRES: {
                    result = DefaultBinding.pgNewRecord(this.type, null, ctx.resultSet().getObject(ctx.index()));
                    break;
                }
                default: {
                    result = ctx.resultSet().getObject(ctx.index(), DefaultBinding.typeMap(this.type, ctx.configuration()));
                    break;
                }
            }
        } else if (Result.class.isAssignableFrom(this.type)) {
            ResultSet nested = (ResultSet)ctx.resultSet().getObject(ctx.index());
            result = DSL.using(ctx.configuration()).fetch(nested);
        } else {
            result = DefaultBinding.unlob(ctx.resultSet().getObject(ctx.index()));
        }
        if (result instanceof Attachable && Tools.attachRecords(ctx.configuration())) {
            ((Attachable)result).attach(ctx.configuration());
        }
        ctx.value(this.converter.from((Blob)result));
    }

    private final LocalDate localDate(Date date) {
        return date == null ? null : date.toLocalDate();
    }

    private final LocalTime localTime(Time time) {
        return time == null ? null : time.toLocalTime();
    }

    private final LocalDateTime localDateTime(Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    private final OffsetTime offsetTime(String string) {
        if (string == null) {
            return null;
        }
        if (string.lastIndexOf(43) == string.length() - 3) {
            string = string + ":00";
        }
        return OffsetTime.parse(string);
    }

    private final OffsetDateTime offsetDateTime(String string) {
        if (string == null) {
            return null;
        }
        if (string.lastIndexOf(43) == string.length() - 3) {
            string = string + ":00";
        }
        if (string.charAt(10) == ' ') {
            string = string.substring(0, 10) + "T" + string.substring(11);
        }
        return OffsetDateTime.parse(string);
    }

    @Override
    public void get(BindingGetStatementContext<U> ctx) throws SQLException {
        Object result = null;
        if (this.type == Blob.class) {
            result = ctx.statement().getBlob(ctx.index());
        } else if (this.type == Boolean.class) {
            result = JDBCUtils.wasNull(ctx.statement(), (Boolean)ctx.statement().getBoolean(ctx.index()));
        } else if (this.type == BigInteger.class) {
            BigDecimal d = ctx.statement().getBigDecimal(ctx.index());
            result = d == null ? null : d.toBigInteger();
        } else if (this.type == BigDecimal.class) {
            result = ctx.statement().getBigDecimal(ctx.index());
        } else if (this.type == Byte.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Byte.valueOf(ctx.statement().getByte(ctx.index())));
        } else if (this.type == byte[].class) {
            result = ctx.statement().getBytes(ctx.index());
        } else if (this.type == Clob.class) {
            result = ctx.statement().getClob(ctx.index());
        } else if (this.type == Date.class) {
            result = ctx.statement().getDate(ctx.index());
        } else if (this.type == Double.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Double.valueOf(ctx.statement().getDouble(ctx.index())));
        } else if (this.type == Float.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Float.valueOf(ctx.statement().getFloat(ctx.index())));
        } else if (this.type == Integer.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Integer.valueOf(ctx.statement().getInt(ctx.index())));
        } else if (this.type == Long.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Long.valueOf(ctx.statement().getLong(ctx.index())));
        } else if (this.type == Short.class) {
            result = JDBCUtils.wasNull(ctx.statement(), Short.valueOf(ctx.statement().getShort(ctx.index())));
        } else if (this.type == String.class) {
            result = ctx.statement().getString(ctx.index());
        } else if (this.type == Time.class) {
            result = ctx.statement().getTime(ctx.index());
        } else if (this.type == Timestamp.class) {
            result = ctx.statement().getTimestamp(ctx.index());
        } else if (this.type == YearToMonth.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.statement().getObject(ctx.index())) == null ? null : PostgresUtils.toYearToMonth(object)) : ((string = ctx.statement().getString(ctx.index())) == null ? null : YearToMonth.valueOf(string));
        } else if (this.type == DayToSecond.class) {
            String string;
            Object object;
            result = ctx.family() == SQLDialect.POSTGRES ? ((object = ctx.statement().getObject(ctx.index())) == null ? null : PostgresUtils.toDayToSecond(object)) : ((string = ctx.statement().getString(ctx.index())) == null ? null : DayToSecond.valueOf(string));
        } else if (this.type == UByte.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : UByte.valueOf(string);
        } else if (this.type == UShort.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : UShort.valueOf(string);
        } else if (this.type == UInteger.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : UInteger.valueOf(string);
        } else if (this.type == ULong.class) {
            String string = ctx.statement().getString(ctx.index());
            result = string == null ? null : ULong.valueOf(string);
        } else if (this.type == UUID.class) {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    result = ctx.statement().getObject(ctx.index());
                    break;
                }
                default: {
                    result = Convert.convert((Object)ctx.statement().getString(ctx.index()), UUID.class);
                    break;
                }
            }
        } else if (this.type.isArray()) {
            result = DefaultBinding.convertArray(ctx.statement().getObject(ctx.index()), this.type);
        } else if (EnumType.class.isAssignableFrom(this.type)) {
            result = DefaultBinding.getEnumType(this.type, ctx.statement().getString(ctx.index()));
        } else if (Record.class.isAssignableFrom(this.type)) {
            switch (ctx.family()) {
                case POSTGRES: {
                    result = DefaultBinding.pgNewRecord(this.type, null, ctx.statement().getObject(ctx.index()));
                    break;
                }
                default: {
                    result = ctx.statement().getObject(ctx.index(), DefaultBinding.typeMap(this.type, ctx.configuration()));
                    break;
                }
            }
        } else if (Result.class.isAssignableFrom(this.type)) {
            ResultSet nested = (ResultSet)ctx.statement().getObject(ctx.index());
            result = DSL.using(ctx.configuration()).fetch(nested);
        } else {
            result = ctx.statement().getObject(ctx.index());
        }
        if (result instanceof Attachable && Tools.attachRecords(ctx.configuration())) {
            ((Attachable)result).attach(ctx.configuration());
        }
        ctx.value(this.converter.from((Blob)result));
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration) {
        return DefaultBinding.typeMap(type, configuration, new HashMap());
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration, Map<String, Class<?>> result) {
        try {
            if (UDTRecord.class.isAssignableFrom(type)) {
                Class<?> t = type;
                result.put(Tools.getMappedUDTName(configuration, t), t);
                UDTRecord r = (UDTRecord)t.newInstance();
                for (Field<?> field : r.getUDT().fields()) {
                    DefaultBinding.typeMap(field.getType(), configuration, result);
                }
            }
        }
        catch (Exception e) {
            throw new MappingException("Error while collecting type map", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
        Object result = null;
        if (this.type == Blob.class) {
            result = ctx.input().readBlob();
        } else if (this.type == Boolean.class) {
            result = JDBCUtils.wasNull(ctx.input(), (Boolean)ctx.input().readBoolean());
        } else if (this.type == BigInteger.class) {
            BigDecimal d = ctx.input().readBigDecimal();
            result = d == null ? null : d.toBigInteger();
        } else if (this.type == BigDecimal.class) {
            result = ctx.input().readBigDecimal();
        } else if (this.type == Byte.class) {
            result = JDBCUtils.wasNull(ctx.input(), Byte.valueOf(ctx.input().readByte()));
        } else if (this.type == byte[].class) {
            if (this.isLob) {
                Blob blob = null;
                try {
                    blob = ctx.input().readBlob();
                    result = blob == null ? null : blob.getBytes(1L, (int)blob.length());
                }
                finally {
                    JDBCUtils.safeFree(blob);
                }
            } else {
                result = ctx.input().readBytes();
            }
        } else {
            java.sql.Array array;
            String string;
            result = this.type == Clob.class ? ctx.input().readClob() : (this.type == Date.class ? ctx.input().readDate() : (this.type == Double.class ? JDBCUtils.wasNull(ctx.input(), Double.valueOf(ctx.input().readDouble())) : (this.type == Float.class ? JDBCUtils.wasNull(ctx.input(), Float.valueOf(ctx.input().readFloat())) : (this.type == Integer.class ? JDBCUtils.wasNull(ctx.input(), Integer.valueOf(ctx.input().readInt())) : (this.type == Long.class ? JDBCUtils.wasNull(ctx.input(), Long.valueOf(ctx.input().readLong())) : (this.type == Short.class ? JDBCUtils.wasNull(ctx.input(), Short.valueOf(ctx.input().readShort())) : (this.type == String.class ? ctx.input().readString() : (this.type == Time.class ? ctx.input().readTime() : (this.type == Timestamp.class ? ctx.input().readTimestamp() : (this.type == YearToMonth.class ? ((string = ctx.input().readString()) == null ? null : YearToMonth.valueOf(string)) : (this.type == DayToSecond.class ? ((string = ctx.input().readString()) == null ? null : DayToSecond.valueOf(string)) : (this.type == UByte.class ? ((string = ctx.input().readString()) == null ? null : UByte.valueOf(string)) : (this.type == UShort.class ? ((string = ctx.input().readString()) == null ? null : UShort.valueOf(string)) : (this.type == UInteger.class ? ((string = ctx.input().readString()) == null ? null : UInteger.valueOf(string)) : (this.type == ULong.class ? ((string = ctx.input().readString()) == null ? null : ULong.valueOf(string)) : (this.type == UUID.class ? Convert.convert((Object)ctx.input().readString(), UUID.class) : (this.type.isArray() ? ((array = ctx.input().readArray()) == null ? null : array.getArray()) : (EnumType.class.isAssignableFrom(this.type) ? DefaultBinding.getEnumType(this.type, ctx.input().readString()) : (UDTRecord.class.isAssignableFrom(this.type) ? ctx.input().readObject() : DefaultBinding.unlob(ctx.input().readObject()))))))))))))))))))));
        }
        ctx.value(this.converter.from((Blob)result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object unlob(Object object) throws SQLException {
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return byArray;
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            try {
                String string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        }
        return object;
    }

    private static final <T> T getEnumType(Class<T> type, String literal) {
        try {
            Object[] list;
            for (Object e : list = (Object[])type.getMethod("values", new Class[0]).invoke(type, new Object[0])) {
                String l = ((EnumType)e).getLiteral();
                if (!l.equals(literal)) continue;
                return (T)e;
            }
        }
        catch (Exception e) {
            throw new DataTypeException("Unknown enum literal found : " + literal);
        }
        return null;
    }

    private static final Object[] convertArray(Object array, Class<? extends Object[]> type) throws SQLException {
        if (array instanceof Object[]) {
            return Convert.convert(array, type);
        }
        if (array instanceof java.sql.Array) {
            return DefaultBinding.convertArray((java.sql.Array)array, type);
        }
        return null;
    }

    private static final Object[] convertArray(java.sql.Array array, Class<? extends Object[]> type) throws SQLException {
        if (array != null) {
            return Convert.convert(array.getArray(), type);
        }
        return null;
    }

    private static final Date getDate(SQLDialect dialect, ResultSet rs, int index) throws SQLException {
        if (dialect == SQLDialect.SQLITE) {
            String date = rs.getString(index);
            if (date != null) {
                return new Date(DefaultBinding.parse(Date.class, date));
            }
            return null;
        }
        return rs.getDate(index);
    }

    private static final Time getTime(SQLDialect dialect, ResultSet rs, int index) throws SQLException {
        if (dialect == SQLDialect.SQLITE) {
            String time = rs.getString(index);
            if (time != null) {
                return new Time(DefaultBinding.parse(Time.class, time));
            }
            return null;
        }
        return rs.getTime(index);
    }

    private static final Timestamp getTimestamp(SQLDialect dialect, ResultSet rs, int index) throws SQLException {
        if (dialect == SQLDialect.SQLITE) {
            String timestamp = rs.getString(index);
            if (timestamp != null) {
                return new Timestamp(DefaultBinding.parse(Timestamp.class, timestamp));
            }
            return null;
        }
        return rs.getTimestamp(index);
    }

    private static final long parse(Class<? extends java.util.Date> type, String date) throws SQLException {
        try {
            return Long.valueOf(date);
        }
        catch (NumberFormatException e) {
            if (type == Timestamp.class) {
                return Timestamp.valueOf(date).getTime();
            }
            if (type == Date.class) {
                return Date.valueOf(date.split(" ")[0]).getTime();
            }
            if (type == Time.class) {
                return Time.valueOf(date).getTime();
            }
            throw new SQLException("Could not parse date " + date, e);
        }
    }

    private static final <T> T pgFromString(Class<T> type, String string) {
        if (string == null) {
            return null;
        }
        if (type != Blob.class) {
            if (type == Boolean.class) {
                return (T)Convert.convert((Object)string, Boolean.class);
            }
            if (type == BigInteger.class) {
                return (T)new BigInteger(string);
            }
            if (type == BigDecimal.class) {
                return (T)new BigDecimal(string);
            }
            if (type == Byte.class) {
                return (T)Byte.valueOf(string);
            }
            if (type == byte[].class) {
                return (T)PostgresUtils.toBytes(string);
            }
            if (type != Clob.class) {
                if (type == Date.class) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
                    return (T)new Date(DefaultBinding.pgParseDate(string, f).getTime());
                }
                if (type == Double.class) {
                    return (T)Double.valueOf(string);
                }
                if (type == Float.class) {
                    return (T)Float.valueOf(string);
                }
                if (type == Integer.class) {
                    return (T)Integer.valueOf(string);
                }
                if (type == Long.class) {
                    return (T)Long.valueOf(string);
                }
                if (type == Short.class) {
                    return (T)Short.valueOf(string);
                }
                if (type == String.class) {
                    return (T)string;
                }
                if (type == Time.class) {
                    SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
                    return (T)new Time(DefaultBinding.pgParseDate(string, f).getTime());
                }
                if (type == Timestamp.class) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return (T)new Timestamp(DefaultBinding.pgParseDate(string, f).getTime());
                }
                if (type == UByte.class) {
                    return (T)UByte.valueOf(string);
                }
                if (type == UShort.class) {
                    return (T)UShort.valueOf(string);
                }
                if (type == UInteger.class) {
                    return (T)UInteger.valueOf(string);
                }
                if (type == ULong.class) {
                    return (T)ULong.valueOf(string);
                }
                if (type == UUID.class) {
                    return (T)UUID.fromString(string);
                }
                if (type.isArray()) {
                    return (T)DefaultBinding.pgNewArray(type, string);
                }
                if (EnumType.class.isAssignableFrom(type)) {
                    return DefaultBinding.getEnumType(type, string);
                }
                if (Record.class.isAssignableFrom(type)) {
                    return (T)DefaultBinding.pgNewRecord(type, null, string);
                }
            }
        }
        throw new UnsupportedOperationException("Class " + type + " is not supported");
    }

    private static final java.util.Date pgParseDate(String string, SimpleDateFormat f) {
        try {
            return f.parse(string);
        }
        catch (ParseException e) {
            throw new DataTypeException("Error while converting date", e);
        }
    }

    static final Record pgNewRecord(Class<?> type, Field<?>[] fields, final Object object) {
        if (object == null) {
            return null;
        }
        return Tools.newRecord(true, type, fields).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) {
                List<String> values = PostgresUtils.toPGObject(object.toString());
                Row row = record.fieldsRow();
                for (int i = 0; i < row.size(); ++i) {
                    DefaultBinding.pgSetValue(record, row.field(i), values.get(i));
                }
                return record;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T pgGetArray(Scope ctx, ResultSet rs, Class<T> type, int index) throws SQLException {
        java.sql.Array array = null;
        try {
            array = rs.getArray(index);
            if (array == null) {
                T t = null;
                return t;
            }
            Object[] objectArray = DefaultBinding.convertArray(array, type);
            return (T)objectArray;
        }
        finally {
            JDBCUtils.safeFree(array);
        }
    }

    private static final Object[] pgNewArray(Class<?> type, String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> component = type.getComponentType();
            String values = string.replaceAll("^\\{(.*)\\}$", "$1");
            if ("".equals(values)) {
                return (Object[])Array.newInstance(component, 0);
            }
            String[] split = values.split(",");
            Object[] result = (Object[])Array.newInstance(component, split.length);
            for (int i = 0; i < split.length; ++i) {
                result[i] = DefaultBinding.pgFromString(type.getComponentType(), split[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw new DataTypeException("Error while creating array", e);
        }
    }

    static final <T> void pgSetValue(Record record, Field<T> field, String value) {
        record.setValue(field, DefaultBinding.pgFromString(field.getType(), value));
    }

    private static final void pgRenderEnumCast(RenderContext render, Class<?> type) {
        Class<?> enumType = type.isArray() ? type.getComponentType() : type;
        EnumType e = (EnumType)enumType.getEnumConstants()[0];
        Schema schema = e.getSchema();
        if (schema != null) {
            render.sql("::");
            schema = DSL.using(render.configuration()).map(schema);
            if (schema != null && Boolean.TRUE.equals(render.configuration().settings().isRenderSchema())) {
                render.visit(schema);
                render.sql('.');
            }
            render.visit(DSL.name(e.getName()));
        }
        if (type.isArray()) {
            render.sql("[]");
        }
    }
}

