/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.RecordUnmapper;
import org.jooq.exception.MappingException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

public class DefaultRecordUnmapper<E, R extends Record>
implements RecordUnmapper<E, R> {
    private final Class<? extends E> type;
    private final RecordType<R> rowType;
    private final Field<?>[] fields;
    private final Configuration configuration;
    private RecordUnmapper<E, R> delegate;

    public DefaultRecordUnmapper(Class<? extends E> type, RecordType<R> rowType, Configuration configuration) {
        this.type = type;
        this.rowType = rowType;
        this.fields = rowType.fields();
        this.configuration = configuration;
        this.init();
    }

    private final void init() {
        this.delegate = this.type.isArray() ? new ArrayUnmapper() : (Map.class.isAssignableFrom(this.type) ? new MapUnmapper() : (Iterable.class.isAssignableFrom(this.type) ? new IterableUnmapper() : new PojoUnmapper()));
    }

    @Override
    public final R unmap(E source) {
        return this.delegate.unmap(source);
    }

    private final Record newRecord() {
        return DSL.using(this.configuration).newRecord(this.rowType.fields());
    }

    private static final void setValue(Record record, Object source, java.lang.reflect.Field member, Field<?> field) throws IllegalAccessException {
        Class<?> mType = member.getType();
        if (mType.isPrimitive()) {
            if (mType == Byte.TYPE) {
                Tools.setValue(record, field, member.getByte(source));
            } else if (mType == Short.TYPE) {
                Tools.setValue(record, field, member.getShort(source));
            } else if (mType == Integer.TYPE) {
                Tools.setValue(record, field, member.getInt(source));
            } else if (mType == Long.TYPE) {
                Tools.setValue(record, field, member.getLong(source));
            } else if (mType == Float.TYPE) {
                Tools.setValue(record, field, Float.valueOf(member.getFloat(source)));
            } else if (mType == Double.TYPE) {
                Tools.setValue(record, field, member.getDouble(source));
            } else if (mType == Boolean.TYPE) {
                Tools.setValue(record, field, member.getBoolean(source));
            } else if (mType == Character.TYPE) {
                Tools.setValue(record, field, Character.valueOf(member.getChar(source)));
            }
        } else {
            Tools.setValue(record, field, member.get(source));
        }
    }

    private static final String klass(Object o) {
        return o == null ? "null" : o.getClass().toString();
    }

    private final class PojoUnmapper
    implements RecordUnmapper<E, R> {
        private PojoUnmapper() {
        }

        @Override
        public R unmap(E source) {
            Record record = DefaultRecordUnmapper.this.newRecord();
            try {
                boolean useAnnotations = Tools.hasColumnAnnotations(DefaultRecordUnmapper.this.configuration, DefaultRecordUnmapper.this.type);
                for (Field<?> field : DefaultRecordUnmapper.this.fields) {
                    Method method;
                    List<java.lang.reflect.Field> members;
                    if (useAnnotations) {
                        members = Tools.getAnnotatedMembers(DefaultRecordUnmapper.this.configuration, DefaultRecordUnmapper.this.type, field.getName(), true);
                        method = Tools.getAnnotatedGetter(DefaultRecordUnmapper.this.configuration, DefaultRecordUnmapper.this.type, field.getName(), true);
                    } else {
                        members = Tools.getMatchingMembers(DefaultRecordUnmapper.this.configuration, DefaultRecordUnmapper.this.type, field.getName(), true);
                        method = Tools.getMatchingGetter(DefaultRecordUnmapper.this.configuration, DefaultRecordUnmapper.this.type, field.getName(), true);
                    }
                    if (method != null) {
                        Tools.setValue(record, field, method.invoke(source, new Object[0]));
                        continue;
                    }
                    if (members.size() <= 0) continue;
                    DefaultRecordUnmapper.setValue(record, source, members.get(0), field);
                }
                return record;
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record from " + DefaultRecordUnmapper.this.type, e);
            }
        }
    }

    private final class MapUnmapper
    implements RecordUnmapper<E, R> {
        private MapUnmapper() {
        }

        @Override
        public R unmap(E source) {
            if (source instanceof Map) {
                Map map = (Map)source;
                Record record = DefaultRecordUnmapper.this.newRecord();
                for (int i = 0; i < DefaultRecordUnmapper.this.fields.length; ++i) {
                    String name = DefaultRecordUnmapper.this.fields[i].getName();
                    if (!map.containsKey(name)) continue;
                    Tools.setValue(record, DefaultRecordUnmapper.this.fields[i], map.get(name));
                }
                return record;
            }
            throw new MappingException("Map expected. Got: " + DefaultRecordUnmapper.klass(source));
        }
    }

    private final class IterableUnmapper
    implements RecordUnmapper<E, R> {
        private IterableUnmapper() {
        }

        @Override
        public final R unmap(E source) {
            if (source instanceof Iterable) {
                Iterable iterable = (Iterable)source;
                Iterator it = iterable.iterator();
                int size = DefaultRecordUnmapper.this.rowType.size();
                AbstractRecord record = (AbstractRecord)DefaultRecordUnmapper.this.newRecord();
                for (int i = 0; i < size && it.hasNext(); ++i) {
                    Tools.setValue(record, DefaultRecordUnmapper.this.rowType.field(i), i, it.next());
                }
                return record;
            }
            throw new MappingException("Iterable expected. Got: " + DefaultRecordUnmapper.klass(source));
        }
    }

    private final class ArrayUnmapper
    implements RecordUnmapper<E, R> {
        private ArrayUnmapper() {
        }

        @Override
        public final R unmap(E source) {
            if (source instanceof Object[]) {
                Object[] array = (Object[])source;
                int size = DefaultRecordUnmapper.this.rowType.size();
                AbstractRecord record = (AbstractRecord)DefaultRecordUnmapper.this.newRecord();
                for (int i = 0; i < size && i < array.length; ++i) {
                    Tools.setValue(record, DefaultRecordUnmapper.this.rowType.field(i), i, array[i]);
                }
                return record;
            }
            throw new MappingException("Object[] expected. Got: " + DefaultRecordUnmapper.klass(source));
        }
    }
}

