/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropSchemaFinalStep;
import org.jooq.DropSchemaStep;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropSchemaImpl
extends AbstractRowCountQuery
implements DropSchemaStep,
DropSchemaFinalStep {
    private static final long serialVersionUID = 1L;
    private final Schema schema;
    private final boolean dropSchemaIfExists;
    private Boolean cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_SCHEMA};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> REQUIRES_RESTRICT = SQLDialect.supportedBy(SQLDialect.DERBY);

    DropSchemaImpl(Configuration configuration, Schema schema, boolean dropSchemaIfExists) {
        this(configuration, schema, dropSchemaIfExists, null);
    }

    DropSchemaImpl(Configuration configuration, Schema schema, boolean dropSchemaIfExists, Boolean cascade) {
        super(configuration);
        this.schema = schema;
        this.dropSchemaIfExists = dropSchemaIfExists;
        this.cascade = cascade;
    }

    final Schema $schema() {
        return this.schema;
    }

    final boolean $dropSchemaIfExists() {
        return this.dropSchemaIfExists;
    }

    final Boolean $cascade() {
        return this.cascade;
    }

    @Override
    public final DropSchemaImpl cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final DropSchemaImpl restrict() {
        this.cascade = false;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.accept0(ctx);
    }

    private void accept0(Context<?> ctx) {
        if (this.dropSchemaIfExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_SCHEMA);
            this.accept1(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_SCHEMA);
        } else {
            this.accept1(ctx);
        }
    }

    private void accept1(Context<?> ctx) {
        ctx.start(Clause.DROP_SCHEMA_SCHEMA).visit(Keywords.K_DROP);
        ctx.sql(' ').visit(Keywords.K_SCHEMA);
        if (this.dropSchemaIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.schema);
        if (this.cascade != null && this.cascade.booleanValue()) {
            ctx.sql(' ').visit(Keywords.K_CASCADE);
        } else if (this.cascade != null && !this.cascade.booleanValue() || REQUIRES_RESTRICT.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.DROP_SCHEMA_SCHEMA);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

