/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import java.util.Set;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;

final class Array<T>
extends AbstractField<T[]> {
    private static final long serialVersionUID = -6629785423729163857L;
    private static final Set<SQLDialect> REQUIRES_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private final Fields<Record> fields;

    Array(Collection<? extends Field<T>> fields) {
        super(Names.N_ARRAY, Array.type(fields));
        this.fields = new Fields(fields);
    }

    private static <T> DataType<T[]> type(Collection<? extends Field<T>> fields) {
        if (fields == null || fields.isEmpty()) {
            return SQLDataType.OTHER.getArrayDataType();
        }
        return fields.iterator().next().getDataType().getArrayDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        boolean squareBrackets = true;
        ctx.visit(Keywords.K_ARRAY).sql(squareBrackets ? (char)'[' : '(').visit(this.fields).sql(squareBrackets ? (char)']' : ')');
        if (this.fields.fields.length == 0 && REQUIRES_CAST.contains((Object)ctx.dialect())) {
            ctx.sql("::").visit(Keywords.K_INT).sql("[]");
        }
    }
}

