/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Set;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.JSONTableColumnPathStep;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class JSONTable
extends AbstractTable<Record>
implements JSONTableColumnPathStep {
    private static final long serialVersionUID = -4881363881968319258L;
    private static final Set<SQLDialect> REQUIRES_COLUMN_PATH = SQLDialect.supportedBy(SQLDialect.MYSQL);
    private final Field<String> path;
    private final Field<?> json;
    private final QueryPartList<JSONTableColumn> columns;
    private final boolean hasOrdinality;
    private transient Fields<Record> fields;

    JSONTable(Field<?> json, Field<String> path) {
        this(json, path, null, false);
    }

    private JSONTable(Field<?> json, Field<String> path, QueryPartList<JSONTableColumn> columns, boolean hasOrdinality) {
        super(TableOptions.expression(), Names.N_JSON_TABLE);
        this.json = json;
        this.path = path;
        this.columns = columns == null ? new QueryPartList() : columns;
        this.hasOrdinality = hasOrdinality;
    }

    @Override
    public final JSONTable column(String name) {
        return this.column(DSL.name(name));
    }

    @Override
    public final JSONTable column(Name name) {
        return this.column((Field)DSL.field(name));
    }

    @Override
    public final JSONTable column(Field<?> name) {
        return this.column((Field)name, name.getDataType());
    }

    @Override
    public final JSONTable column(String name, DataType<?> type) {
        return this.column(DSL.name(name), (DataType)type);
    }

    @Override
    public final JSONTable column(Name name, DataType<?> type) {
        return this.column((Field)DSL.field(name), (DataType)type);
    }

    @Override
    public final JSONTable column(Field<?> name, DataType<?> type) {
        QueryPartList<JSONTableColumn> c = new QueryPartList<JSONTableColumn>((Iterable<JSONTableColumn>)this.columns);
        c.add(new JSONTableColumn(name, type, false, null));
        return new JSONTable(this.json, this.path, c, this.hasOrdinality);
    }

    @Override
    public final JSONTable forOrdinality() {
        return this.path0(true, null);
    }

    @Override
    public final JSONTable path(String p) {
        return this.path0(false, p);
    }

    private final JSONTable path0(boolean forOrdinality, String p) {
        QueryPartList<JSONTableColumn> c = new QueryPartList<JSONTableColumn>((Iterable<JSONTableColumn>)this.columns);
        int i = c.size() - 1;
        JSONTableColumn last = (JSONTableColumn)c.get(i);
        c.set(i, new JSONTableColumn(last.field, last.type, forOrdinality, p));
        return new JSONTable(this.json, this.path, c, this.hasOrdinality || forOrdinality);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    final Fields<Record> fields0() {
        if (this.fields == null) {
            ArrayList f = new ArrayList();
            for (JSONTableColumn c : this.columns) {
                f.add(c.field.getDataType() == c.type ? c.field : DSL.field(c.field.getQualifiedName(), c.type));
            }
            this.fields = new Fields(f);
        }
        return this.fields;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                this.acceptPostgres(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private final void acceptPostgres(Context<?> ctx) {
        ArrayList<Field<Object>> cols = new ArrayList<Field<Object>>();
        for (JSONTableColumn col : this.columns) {
            if (col.forOrdinality) {
                cols.add(DSL.field("o").as(col.field));
                continue;
            }
            cols.add(DSL.field("(jsonb_path_query_first(j, {0}::jsonpath)->>0)::{1}", col.path != null ? DSL.val(col.path) : DSL.inline("$." + col.field.getName()), DSL.keyword(col.type.getCastTypeName(ctx.configuration()))).as(col.field));
        }
        Tools.visitSubquery(ctx, DSL.select(cols).from(this.hasOrdinality ? "jsonb_path_query({0}, {1}::jsonpath) {with} {ordinality} {as} t(j, o)" : "jsonb_path_query({0}, {1}::jsonpath) {as} t(j)", this.json.getType() == JSONB.class ? this.json : this.json.cast(SQLDataType.JSONB), this.path), true);
    }

    private final void acceptStandard(Context<?> ctx) {
        ctx.visit(Keywords.K_JSON_TABLE).sql('(').formatIndentStart().formatNewLine();
        ctx.visit(this.json).sql(',').formatSeparator();
        this.acceptJSONPath(ctx);
        ctx.formatSeparator().visit(Keywords.K_COLUMNS).sql(" (").visit(this.columns).sql(')');
        ctx.formatIndentEnd().formatNewLine().sql(')');
    }

    private final void acceptJSONPath(Context<?> ctx) {
        ctx.visit(this.path);
    }

    @Override
    public boolean declaresTables() {
        return true;
    }

    private static class JSONTableColumn
    extends AbstractQueryPart {
        private static final long serialVersionUID = 783627375014050176L;
        final Field<?> field;
        final DataType<?> type;
        final boolean forOrdinality;
        final String path;

        JSONTableColumn(Field<?> field, DataType<?> type, boolean forOrdinality, String path) {
            this.field = field;
            this.type = type;
            this.forOrdinality = forOrdinality;
            this.path = path;
        }

        @Override
        public final void accept(Context<?> ctx) {
            String p;
            boolean previous = ctx.qualify();
            ctx.qualify(false).visit(this.field).qualify(previous).sql(' ');
            if (this.forOrdinality) {
                ctx.visit(Keywords.K_FOR).sql(' ').visit(Keywords.K_ORDINALITY);
            } else {
                Tools.toSQLDDLTypeDeclaration(ctx, this.type);
            }
            String string = this.path != null ? this.path : (p = !this.forOrdinality && REQUIRES_COLUMN_PATH.contains((Object)ctx.dialect()) ? "$." + this.field.getName() : null);
            if (p != null) {
                ctx.sql(' ').visit(Keywords.K_PATH).sql(' ').visit(DSL.inline(p));
            }
        }
    }
}

