/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Catalog;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Internal;
import org.jooq.Keyword;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractTypedNamed;
import org.jooq.impl.CommentImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.Tools;

@Internal
public class SequenceImpl<T extends Number>
extends AbstractTypedNamed<T>
implements Sequence<T> {
    private static final long serialVersionUID = 6224349401603636427L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.SEQUENCE, Clause.SEQUENCE_REFERENCE};
    private final boolean nameIsPlainSQL;
    private final Schema schema;
    private final Field<T> startWith;
    private final Field<T> incrementBy;
    private final Field<T> minvalue;
    private final Field<T> maxvalue;
    private final boolean cycle;
    private final Field<T> cache;

    @Deprecated
    public SequenceImpl(String name, Schema schema, DataType<T> type) {
        this(name, schema, type, false);
    }

    SequenceImpl(String name, Schema schema, DataType<T> type, boolean nameIsPlainSQL) {
        this(DSL.name(name), schema, type, nameIsPlainSQL);
    }

    SequenceImpl(Name name, Schema schema, DataType<T> type, boolean nameIsPlainSQL) {
        this(name, schema, type, nameIsPlainSQL, null, null, null, null, false, null);
    }

    SequenceImpl(Name name, Schema schema, DataType<T> type, boolean nameIsPlainSQL, Field<T> startWith, Field<T> incrementBy, Field<T> minvalue, Field<T> maxvalue, boolean cycle, Field<T> cache) {
        super(SequenceImpl.qualify(schema, name), CommentImpl.NO_COMMENT, type);
        this.schema = schema;
        this.nameIsPlainSQL = nameIsPlainSQL;
        this.startWith = startWith;
        this.incrementBy = incrementBy;
        this.minvalue = minvalue;
        this.maxvalue = maxvalue;
        this.cycle = cycle;
        this.cache = cache;
    }

    @Override
    public final Catalog getCatalog() {
        return this.getSchema() == null ? null : this.getSchema().getCatalog();
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final Field<T> getStartWith() {
        return this.startWith;
    }

    @Override
    public final Field<T> getIncrementBy() {
        return this.incrementBy;
    }

    @Override
    public final Field<T> getMinvalue() {
        return this.minvalue;
    }

    @Override
    public final Field<T> getMaxvalue() {
        return this.maxvalue;
    }

    @Override
    public final boolean getCycle() {
        return this.cycle;
    }

    @Override
    public final Field<T> getCache() {
        return this.cache;
    }

    @Override
    public final Field<T> currval() {
        return new SequenceFunction(SequenceMethod.CURRVAL);
    }

    @Override
    public final Field<T> nextval() {
        return new SequenceFunction(SequenceMethod.NEXTVAL);
    }

    @Override
    public final void accept(Context<?> ctx) {
        Schema mappedSchema = Tools.getMappedSchema(ctx.configuration(), this.schema);
        if (mappedSchema != null && !"".equals(mappedSchema.getName()) && ctx.family() != SQLDialect.CUBRID) {
            ctx.visit(mappedSchema).sql('.');
        }
        if (this.nameIsPlainSQL) {
            ctx.sql(this.getName());
        } else {
            ctx.visit(this.getUnqualifiedName());
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private class SequenceFunction
    extends AbstractField<T> {
        private static final long serialVersionUID = 2292275568395094887L;
        private final SequenceMethod method;

        SequenceFunction(SequenceMethod method) {
            super(method.name, SequenceImpl.this.getDataType());
            this.method = method;
        }

        @Override
        public final void accept(Context<?> ctx) {
            Configuration configuration = ctx.configuration();
            SQLDialect family = configuration.family();
            switch (family) {
                case POSTGRES: {
                    ctx.visit(this.method.keyword).sql('(');
                    ctx.sql('\'').stringLiteral(true).visit(SequenceImpl.this).stringLiteral(false).sql('\'');
                    ctx.sql(')');
                    break;
                }
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: 
                case MARIADB: {
                    if (this.method == SequenceMethod.NEXTVAL) {
                        ctx.visit(Keywords.K_NEXT_VALUE_FOR).sql(' ').visit(SequenceImpl.this);
                        break;
                    }
                    if (family == SQLDialect.H2) {
                        ctx.visit(SequenceImpl.this).sql('.').visit(this.method.keyword);
                        break;
                    }
                    if (family == SQLDialect.HSQLDB) {
                        ctx.visit(Keywords.K_CURRENT_VALUE_FOR).sql(' ').visit(SequenceImpl.this);
                        break;
                    }
                    if (family == SQLDialect.MARIADB) {
                        ctx.visit(Keywords.K_PREVIOUS_VALUE_FOR).sql(' ').visit(SequenceImpl.this);
                        break;
                    }
                    if (family == SQLDialect.FIREBIRD) {
                        ctx.visit(Keywords.F_GEN_ID).sql('(').visit(SequenceImpl.this).sql(", 0)");
                        break;
                    }
                    throw new SQLDialectNotSupportedException("The sequence's current value functionality is not supported for the " + (Object)((Object)family) + " dialect.");
                }
                case CUBRID: {
                    ctx.visit(SequenceImpl.this).sql('.');
                    if (this.method == SequenceMethod.NEXTVAL) {
                        ctx.visit(DSL.keyword("next_value"));
                        break;
                    }
                    ctx.visit(DSL.keyword("current_value"));
                    break;
                }
                default: {
                    ctx.visit(SequenceImpl.this).sql('.').visit(this.method.keyword);
                }
            }
        }
    }

    private static enum SequenceMethod {
        CURRVAL(Keywords.K_CURRVAL, Names.N_CURRVAL),
        NEXTVAL(Keywords.K_NEXTVAL, Names.N_NEXTVAL);

        final Keyword keyword;
        final Name name;

        private SequenceMethod(Keyword keyword, Name name) {
            this.keyword = keyword;
            this.name = name;
        }
    }
}

