/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class ScopeStack<K, V>
implements Iterable<V> {
    private int scopeLevel = -1;
    private Map<K, List<V>> stack;
    private final Constructor<V> constructor;

    ScopeStack(final V defaultValue) {
        this(new Constructor<V>(){

            @Override
            public V create(int scopeLevel) {
                return defaultValue;
            }
        });
    }

    ScopeStack(Constructor<V> constructor) {
        this.constructor = constructor;
    }

    private final Map<K, List<V>> stack() {
        if (this.stack == null) {
            this.stack = new LinkedHashMap<K, List<V>>();
        }
        return this.stack;
    }

    private final void trim() {
        int l = this.scopeLevel + 1;
        if (l >= 0) {
            Iterator<Map.Entry<K, List<V>>> it = this.stack().entrySet().iterator();
            while (it.hasNext()) {
                int size;
                Map.Entry<K, List<V>> entry = it.next();
                List<V> list = entry.getValue();
                while ((size = list.size()) > l || size > 0 && list.get(size - 1) == null) {
                    list.remove(size - 1);
                }
                if (!list.isEmpty()) continue;
                it.remove();
            }
        }
    }

    final boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public final Iterator<V> iterator() {
        return new Iterator<V>(){
            Iterator<List<V>> it;
            V next;
            {
                this.it = ScopeStack.this.stack().values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.move() != null;
            }

            @Override
            public V next() {
                if (this.next == null) {
                    return this.move();
                }
                Object result = this.next;
                this.next = null;
                return result;
            }

            private V move() {
                while (this.it.hasNext()) {
                    List list = this.it.next();
                    if (list.isEmpty()) continue;
                    this.next = list.get(list.size() - 1);
                    break;
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    final void setAll(V value) {
        for (K key : this.stack().keySet()) {
            this.set(key, value);
        }
    }

    final void set(K key, V value) {
        this.set0(this.list(key), value);
    }

    private final V get0(List<V> list) {
        int i = list.size() - 1;
        return i == -1 ? null : (V)list.get(i);
    }

    final V get(K key) {
        return this.get0(this.list(key));
    }

    final V getOrCreate(K key) {
        List<V> list = this.list(key);
        V result = this.get0(list);
        if (result == null) {
            result = this.constructor.create(this.scopeLevel);
            this.set0(list, result);
        }
        return result;
    }

    private void set0(List<V> list, V value) {
        int l = this.scopeLevel + 1;
        int size = list.size();
        if (size < l) {
            list.addAll(Collections.nCopies(l - size, null));
        }
        list.set(this.scopeLevel, value);
    }

    private List<V> list(K key) {
        List<V> list = this.stack().get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.stack().put(key, list);
        }
        return list;
    }

    final boolean inScope() {
        return this.scopeLevel > -1;
    }

    final void scopeStart() {
        ++this.scopeLevel;
    }

    final void scopeEnd() {
        --this.scopeLevel;
        this.trim();
    }

    public String toString() {
        return this.stack().toString();
    }

    @FunctionalInterface
    static interface Constructor<V> {
        public V create(int var1);
    }
}

