/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;

final class Repeat
extends AbstractField<String> {
    private static final long serialVersionUID = -7273879239726265322L;
    private final Field<String> string;
    private final Field<? extends Number> count;

    Repeat(Field<String> string, Field<? extends Number> count) {
        super(Names.N_RPAD, SQLDataType.VARCHAR);
        this.string = string;
        this.count = count;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(DSL.rpad(this.string, DSL.length(this.string).mul(this.count), this.string));
                break;
            }
            case SQLITE: {
                ctx.visit(Keywords.F_REPLACE).sql('(').visit(Keywords.F_HEX).sql('(').visit(Keywords.F_ZEROBLOB).sql('(').visit(this.count).sql(")), '00', ").visit(this.string).sql(')');
                break;
            }
            default: {
                ctx.visit(Keywords.F_REPEAT).sql('(').visit(this.string).sql(", ").visit(this.count).sql(')');
            }
        }
    }
}

