/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.jooq.Batch;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.Loader;
import org.jooq.LoaderCSVOptionsStep;
import org.jooq.LoaderCSVStep;
import org.jooq.LoaderContext;
import org.jooq.LoaderError;
import org.jooq.LoaderFieldMapper;
import org.jooq.LoaderJSONOptionsStep;
import org.jooq.LoaderJSONStep;
import org.jooq.LoaderOptionsStep;
import org.jooq.LoaderRowListener;
import org.jooq.LoaderRowsStep;
import org.jooq.LoaderXMLStep;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectQuery;
import org.jooq.Source;
import org.jooq.Table;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.LoaderConfigurationException;
import org.jooq.impl.DSL;
import org.jooq.impl.F1;
import org.jooq.impl.JSONReader;
import org.jooq.impl.LoaderErrorImpl;
import org.jooq.impl.MappingIterator;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.csv.CSVReader;
import org.xml.sax.InputSource;

final class LoaderImpl<R extends Record>
implements LoaderOptionsStep<R>,
LoaderRowsStep<R>,
LoaderXMLStep<R>,
LoaderCSVStep<R>,
LoaderCSVOptionsStep<R>,
LoaderJSONStep<R>,
LoaderJSONOptionsStep<R>,
Loader<R> {
    private static final JooqLogger log = JooqLogger.getLogger(LoaderImpl.class);
    private static final int ON_DUPLICATE_KEY_ERROR = 0;
    private static final int ON_DUPLICATE_KEY_IGNORE = 1;
    private static final int ON_DUPLICATE_KEY_UPDATE = 2;
    private static final int ON_ERROR_ABORT = 0;
    private static final int ON_ERROR_IGNORE = 1;
    private static final int COMMIT_NONE = 0;
    private static final int COMMIT_AFTER = 1;
    private static final int COMMIT_ALL = 2;
    private static final int BATCH_NONE = 0;
    private static final int BATCH_AFTER = 1;
    private static final int BATCH_ALL = 2;
    private static final int BULK_NONE = 0;
    private static final int BULK_AFTER = 1;
    private static final int BULK_ALL = 2;
    private static final int CONTENT_CSV = 0;
    private static final int CONTENT_XML = 1;
    private static final int CONTENT_JSON = 2;
    private static final int CONTENT_ARRAYS = 3;
    private final DSLContext create;
    private final Configuration configuration;
    private final Table<R> table;
    private int onDuplicate = 0;
    private int onError = 0;
    private int commit = 0;
    private int commitAfter = 1;
    private int batch = 0;
    private int batchAfter = 1;
    private int bulk = 0;
    private int bulkAfter = 1;
    private int content = 0;
    private Source input;
    private Iterator<? extends Object[]> arrays;
    private int ignoreRows = 1;
    private char quote = (char)34;
    private char separator = (char)44;
    private String nullString = null;
    private Field<?>[] source;
    private Field<?>[] fields;
    private LoaderFieldMapper fieldMapper;
    private boolean fieldsFromSource;
    private BitSet primaryKey;
    private LoaderRowListener listener;
    private LoaderContext result = new DefaultLoaderContext();
    private int ignored;
    private int processed;
    private int stored;
    private int executed;
    private int buffered;
    private final List<LoaderError> errors;

    LoaderImpl(Configuration configuration, Table<R> table) {
        this.create = DSL.using(configuration);
        this.configuration = configuration;
        this.table = table;
        this.errors = new ArrayList<LoaderError>();
    }

    @Override
    public final LoaderImpl<R> onDuplicateKeyError() {
        this.onDuplicate = 0;
        return this;
    }

    @Override
    public final LoaderImpl<R> onDuplicateKeyIgnore() {
        if (this.table.getPrimaryKey() == null) {
            throw new IllegalStateException("ON DUPLICATE KEY IGNORE only works on tables with explicit primary keys. Table is not updatable : " + this.table);
        }
        this.onDuplicate = 1;
        return this;
    }

    @Override
    public final LoaderImpl<R> onDuplicateKeyUpdate() {
        if (this.table.getPrimaryKey() == null) {
            throw new IllegalStateException("ON DUPLICATE KEY UPDATE only works on tables with explicit primary keys. Table is not updatable : " + this.table);
        }
        this.onDuplicate = 2;
        return this;
    }

    @Override
    public final LoaderImpl<R> onErrorIgnore() {
        this.onError = 1;
        return this;
    }

    @Override
    public final LoaderImpl<R> onErrorAbort() {
        this.onError = 0;
        return this;
    }

    @Override
    public final LoaderImpl<R> commitEach() {
        this.commit = 1;
        return this;
    }

    @Override
    public final LoaderImpl<R> commitAfter(int number) {
        this.commit = 1;
        this.commitAfter = number;
        return this;
    }

    @Override
    public final LoaderImpl<R> commitAll() {
        this.commit = 2;
        return this;
    }

    @Override
    public final LoaderImpl<R> commitNone() {
        this.commit = 0;
        return this;
    }

    @Override
    public final LoaderImpl<R> batchAll() {
        this.batch = 2;
        return this;
    }

    @Override
    public final LoaderImpl<R> batchNone() {
        this.batch = 0;
        return this;
    }

    @Override
    public final LoaderImpl<R> batchAfter(int number) {
        this.batch = 1;
        this.batchAfter = number;
        return this;
    }

    @Override
    public final LoaderImpl<R> bulkAll() {
        this.bulk = 2;
        return this;
    }

    @Override
    public final LoaderImpl<R> bulkNone() {
        this.bulk = 0;
        return this;
    }

    @Override
    public final LoaderImpl<R> bulkAfter(int number) {
        this.bulk = 1;
        this.bulkAfter = number;
        return this;
    }

    @Override
    public final LoaderRowsStep<R> loadArrays(Object[] ... a) {
        return this.loadArrays(Arrays.asList(a));
    }

    @Override
    public final LoaderRowsStep<R> loadArrays(Iterable<? extends Object[]> a) {
        return this.loadArrays(a.iterator());
    }

    @Override
    public final LoaderRowsStep<R> loadArrays(Iterator<? extends Object[]> a) {
        this.content = 3;
        this.arrays = a;
        return this;
    }

    @Override
    public final LoaderRowsStep<R> loadRecords(Record ... records) {
        return this.loadRecords(Arrays.asList(records));
    }

    @Override
    public final LoaderRowsStep<R> loadRecords(Iterable<? extends Record> records) {
        return this.loadRecords(records.iterator());
    }

    @Override
    public final LoaderRowsStep<R> loadRecords(Iterator<? extends Record> records) {
        return this.loadArrays(new MappingIterator<Record, Object[]>(records, new F1<Record, Object[]>(){

            @Override
            public final Object[] apply(Record value) {
                if (value == null) {
                    return null;
                }
                if (LoaderImpl.this.source == null) {
                    LoaderImpl.access$102(LoaderImpl.this, value.fields());
                }
                return value.intoArray();
            }
        }));
    }

    @Override
    public final LoaderRowsStep<R> loadArrays(Stream<? extends Object[]> a) {
        return this.loadArrays(a.iterator());
    }

    @Override
    public final LoaderRowsStep<R> loadRecords(Stream<? extends Record> records) {
        return this.loadRecords(records.iterator());
    }

    @Override
    public final LoaderImpl<R> loadCSV(File file) {
        return this.loadCSV(Source.of(file));
    }

    @Override
    public final LoaderImpl<R> loadCSV(File file, String charsetName) {
        return this.loadCSV(Source.of(file, charsetName));
    }

    @Override
    public final LoaderImpl<R> loadCSV(File file, Charset cs) {
        return this.loadCSV(Source.of(file, cs));
    }

    @Override
    public final LoaderImpl<R> loadCSV(File file, CharsetDecoder dec) {
        return this.loadCSV(Source.of(file, dec));
    }

    @Override
    public final LoaderImpl<R> loadCSV(String csv) {
        return this.loadCSV(Source.of(csv));
    }

    @Override
    public final LoaderImpl<R> loadCSV(InputStream stream) {
        return this.loadCSV(Source.of(stream));
    }

    @Override
    public final LoaderImpl<R> loadCSV(InputStream stream, String charsetName) {
        return this.loadCSV(Source.of(stream, charsetName));
    }

    @Override
    public final LoaderImpl<R> loadCSV(InputStream stream, Charset cs) {
        return this.loadCSV(Source.of(stream, cs));
    }

    @Override
    public final LoaderImpl<R> loadCSV(InputStream stream, CharsetDecoder dec) {
        return this.loadCSV(Source.of(stream, dec));
    }

    @Override
    public final LoaderImpl<R> loadCSV(Reader reader) {
        return this.loadCSV(Source.of(reader));
    }

    @Override
    public final LoaderImpl<R> loadCSV(Source s) {
        this.content = 0;
        this.input = s;
        return this;
    }

    @Override
    public final LoaderImpl<R> loadXML(File file) {
        return this.loadXML(Source.of(file));
    }

    @Override
    public final LoaderImpl<R> loadXML(File file, String charsetName) {
        return this.loadXML(Source.of(file, charsetName));
    }

    @Override
    public final LoaderImpl<R> loadXML(File file, Charset cs) {
        return this.loadXML(Source.of(file, cs));
    }

    @Override
    public final LoaderImpl<R> loadXML(File file, CharsetDecoder dec) {
        return this.loadXML(Source.of(file, dec));
    }

    @Override
    public final LoaderImpl<R> loadXML(String xml) {
        return this.loadXML(Source.of(xml));
    }

    @Override
    public final LoaderImpl<R> loadXML(InputStream stream) {
        return this.loadXML(Source.of(stream));
    }

    @Override
    public final LoaderImpl<R> loadXML(InputStream stream, String charsetName) {
        return this.loadXML(Source.of(stream, charsetName));
    }

    @Override
    public final LoaderImpl<R> loadXML(InputStream stream, Charset cs) {
        return this.loadXML(Source.of(stream, cs));
    }

    @Override
    public final LoaderImpl<R> loadXML(InputStream stream, CharsetDecoder dec) {
        return this.loadXML(Source.of(stream, dec));
    }

    @Override
    public final LoaderImpl<R> loadXML(Reader reader) {
        return this.loadXML(Source.of(reader));
    }

    @Override
    public final LoaderImpl<R> loadXML(InputSource s) {
        this.content = 1;
        throw new UnsupportedOperationException("This is not yet implemented");
    }

    @Override
    public final LoaderImpl<R> loadXML(Source s) {
        this.content = 1;
        this.input = s;
        throw new UnsupportedOperationException("This is not yet implemented");
    }

    @Override
    public final LoaderImpl<R> loadJSON(File file) {
        return this.loadJSON(Source.of(file));
    }

    @Override
    public final LoaderImpl<R> loadJSON(File file, String charsetName) {
        return this.loadJSON(Source.of(file, charsetName));
    }

    @Override
    public final LoaderImpl<R> loadJSON(File file, Charset cs) {
        return this.loadJSON(Source.of(file, cs));
    }

    @Override
    public final LoaderImpl<R> loadJSON(File file, CharsetDecoder dec) {
        return this.loadJSON(Source.of(file, dec));
    }

    @Override
    public final LoaderImpl<R> loadJSON(String json) {
        return this.loadJSON(Source.of(json));
    }

    @Override
    public final LoaderImpl<R> loadJSON(InputStream stream) {
        return this.loadJSON(Source.of(stream));
    }

    @Override
    public final LoaderImpl<R> loadJSON(InputStream stream, String charsetName) {
        return this.loadJSON(Source.of(stream, charsetName));
    }

    @Override
    public final LoaderImpl<R> loadJSON(InputStream stream, Charset cs) {
        return this.loadJSON(Source.of(stream, cs));
    }

    @Override
    public final LoaderImpl<R> loadJSON(InputStream stream, CharsetDecoder dec) {
        return this.loadJSON(Source.of(stream, dec));
    }

    @Override
    public final LoaderImpl<R> loadJSON(Reader reader) {
        return this.loadJSON(Source.of(reader));
    }

    @Override
    public final LoaderImpl<R> loadJSON(Source s) {
        this.content = 2;
        this.input = s;
        return this;
    }

    @Override
    public final LoaderImpl<R> fields(Field<?> ... f) {
        this.fields = f;
        this.primaryKey = new BitSet(f.length);
        if (this.table.getPrimaryKey() != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == null || !this.table.getPrimaryKey().getFields().contains(this.fields[i])) continue;
                this.primaryKey.set(i);
            }
        }
        return this;
    }

    @Override
    public final LoaderImpl<R> fields(Collection<? extends Field<?>> f) {
        return this.fields((Field[])f.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final LoaderImpl<R> fields(LoaderFieldMapper mapper) {
        this.fieldMapper = mapper;
        return this;
    }

    @Override
    public LoaderImpl<R> fieldsFromSource() {
        this.fieldsFromSource = true;
        return this;
    }

    private final void fields0(Object[] row) {
        Field[] f = new Field[row.length];
        if (this.source == null) {
            if (this.fieldsFromSource) {
                throw new LoaderConfigurationException("Using fieldsFromSource() requires field names to be available in source.");
            }
            this.source = Tools.fields(row.length);
        }
        if (this.fieldMapper != null) {
            for (int i = 0; i < row.length; ++i) {
                final int index = i;
                f[i] = this.fieldMapper.map(new LoaderFieldMapper.LoaderFieldContext(){

                    @Override
                    public int index() {
                        return index;
                    }

                    @Override
                    public Field<?> field() {
                        return LoaderImpl.this.source[index];
                    }
                });
            }
        } else if (this.fieldsFromSource) {
            for (int i = 0; i < row.length; ++i) {
                f[i] = this.table.field(this.source[i]);
                if (f[i] != null) continue;
                log.info("No column in target table " + this.table + " found for input field " + this.source[i]);
            }
        }
        this.fields(f);
    }

    @Override
    public final LoaderImpl<R> ignoreRows(int number) {
        this.ignoreRows = number;
        return this;
    }

    @Override
    public final LoaderImpl<R> quote(char q) {
        this.quote = q;
        return this;
    }

    @Override
    public final LoaderImpl<R> separator(char s) {
        this.separator = s;
        return this;
    }

    @Override
    public final LoaderImpl<R> nullString(String n) {
        this.nullString = n;
        return this;
    }

    @Override
    public final LoaderImpl<R> onRow(LoaderRowListener l) {
        this.listener = l;
        return this;
    }

    @Override
    public final LoaderImpl<R> execute() throws IOException {
        this.checkFlags();
        if (this.content == 0) {
            this.executeCSV();
        } else {
            if (this.content == 1) {
                throw new UnsupportedOperationException();
            }
            if (this.content == 2) {
                this.executeJSON();
            } else if (this.content == 3) {
                this.executeRows();
            } else {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    private void checkFlags() {
        if (this.batch != 0 && this.onDuplicate == 1) {
            throw new LoaderConfigurationException("Cannot apply batch loading with onDuplicateKeyIgnore flag. Turn off either flag.");
        }
        if (this.bulk != 0 && this.onDuplicate != 0) {
            throw new LoaderConfigurationException("Cannot apply bulk loading with onDuplicateKey flags. Turn off either flag.");
        }
    }

    private void executeJSON() throws IOException {
        try (Reader reader = null;){
            reader = this.input.reader();
            Result<Record> r = new JSONReader(this.create).read(reader);
            this.source = r.fields();
            List allRecords = Arrays.asList(r.intoArrays());
            this.executeSQL(allRecords.iterator());
        }
    }

    private final void executeCSV() throws IOException {
        try (CSVReader reader = null;){
            if (this.ignoreRows == 1) {
                reader = new CSVReader(this.input.reader(), this.separator, this.quote, 0);
                this.source = Tools.fieldsByName(reader.next());
            } else {
                reader = new CSVReader(this.input.reader(), this.separator, this.quote, this.ignoreRows);
            }
            this.executeSQL(reader);
        }
    }

    private void executeRows() {
        try {
            this.executeSQL(this.arrays);
        }
        catch (SQLException e) {
            throw Tools.translate(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeSQL(Iterator<? extends Object[]> iterator) throws SQLException {
        block43: {
            Object[] row = null;
            Batch bind = null;
            InsertQuery<R> insert = null;
            boolean newRecord = false;
            while (iterator.hasNext() && (row = iterator.next()) != null) {
                try {
                    block42: {
                        block41: {
                            block40: {
                                int i;
                                block39: {
                                    if (row.getClass() != Object[].class) {
                                        row = Arrays.copyOf(row, row.length, Object[].class);
                                    }
                                    if (this.fields == null) {
                                        this.fields0(row);
                                    }
                                    for (i = 0; i < row.length; ++i) {
                                        if (StringUtils.equals((Object)this.nullString, row[i])) {
                                            row[i] = null;
                                            continue;
                                        }
                                        if (i >= this.fields.length || this.fields[i] == null || this.fields[i].getType() != byte[].class || !(row[i] instanceof String)) continue;
                                        row[i] = DatatypeConverter.parseBase64Binary((String)((String)row[i]));
                                    }
                                    ++this.processed;
                                    if (this.onDuplicate == 1 && this.primaryKey.cardinality() > 0) {
                                        SelectQuery<R> select = this.create.selectQuery(this.table);
                                        for (int i2 = 0; i2 < row.length; ++i2) {
                                            if (i2 >= this.fields.length || !this.primaryKey.get(i2)) continue;
                                            select.addConditions(this.getCondition(this.fields[i2], row[i2]));
                                        }
                                        try {
                                            if (!this.create.fetchExists(select)) break block39;
                                            ++this.ignored;
                                            if (this.listener == null) continue;
                                        }
                                        catch (DataAccessException e) {
                                            this.errors.add(new LoaderErrorImpl(e, row, this.processed - 1, select));
                                        }
                                        this.listener.row(this.result);
                                        continue;
                                    }
                                }
                                ++this.buffered;
                                if (insert == null) {
                                    insert = this.create.insertQuery(this.table);
                                }
                                if (newRecord) {
                                    newRecord = false;
                                    insert.newRecord();
                                }
                                for (i = 0; i < row.length; ++i) {
                                    if (i >= this.fields.length || this.fields[i] == null) continue;
                                    this.addValue0(insert, this.fields[i], row[i]);
                                }
                                if (this.onDuplicate == 2) {
                                    insert.onDuplicateKeyUpdate(true);
                                    for (i = 0; i < row.length; ++i) {
                                        if (i >= this.fields.length || this.fields[i] == null || this.primaryKey.get(i)) continue;
                                        this.addValueForUpdate0(insert, this.fields[i], row[i]);
                                    }
                                } else if (this.onDuplicate == 0) {
                                    // empty if block
                                }
                                if (this.bulk == 0 || this.bulk != 2 && this.processed % this.bulkAfter == 0) break block40;
                                newRecord = true;
                                if (this.listener == null) continue;
                                this.listener.row(this.result);
                                continue;
                            }
                            if (this.batch == 0) break block41;
                            if (bind == null) {
                                bind = this.create.batch((Query)insert);
                            }
                            bind.bind(insert.getBindValues().toArray());
                            insert = null;
                            if (this.batch != 2 && this.processed % (this.bulkAfter * this.batchAfter) == 0) break block41;
                            if (this.listener == null) continue;
                            this.listener.row(this.result);
                            continue;
                        }
                        try {
                            if (bind != null) {
                                bind.execute();
                            } else if (insert != null) {
                                insert.execute();
                            }
                            this.stored += this.buffered;
                            ++this.executed;
                            this.buffered = 0;
                            bind = null;
                            insert = null;
                            if (this.commit != 1 || this.processed % this.batchAfter != 0 || this.processed / this.batchAfter % this.commitAfter != 0) break block42;
                            this.commit();
                        }
                        catch (DataAccessException e) {
                            this.errors.add(new LoaderErrorImpl(e, row, this.processed - 1, insert));
                            this.ignored += this.buffered;
                            this.buffered = 0;
                            if (this.onError != 0) break block42;
                            if (this.listener != null) {
                                this.listener.row(this.result);
                            }
                            break block43;
                        }
                    }
                    if (this.listener == null) continue;
                    this.listener.row(this.result);
                }
                catch (Throwable throwable) {
                    if (this.listener == null) throw throwable;
                    this.listener.row(this.result);
                    throw throwable;
                }
            }
            if (this.buffered != 0) {
                try {
                    if (bind != null) {
                        bind.execute();
                    }
                    if (insert != null) {
                        insert.execute();
                    }
                    this.stored += this.buffered;
                    ++this.executed;
                    this.buffered = 0;
                }
                catch (DataAccessException e) {
                    this.errors.add(new LoaderErrorImpl(e, row, this.processed - 1, insert));
                    this.ignored += this.buffered;
                    this.buffered = 0;
                }
                if (this.onError == 0) {
                    // empty if block
                }
            }
        }
        try {
            if (this.commit != 2) {
                if (this.commit != 1) return;
                this.commit();
                return;
            }
            if (!this.errors.isEmpty()) {
                this.stored = 0;
                this.rollback();
                return;
            }
            this.commit();
            return;
        }
        catch (DataAccessException e) {
            this.errors.add(new LoaderErrorImpl(e, null, this.processed - 1, null));
        }
    }

    private void commit() throws SQLException {
        Connection connection = this.configuration.connectionProvider().acquire();
        try {
            connection.commit();
        }
        finally {
            this.configuration.connectionProvider().release(connection);
        }
    }

    private void rollback() throws SQLException {
        Connection connection = this.configuration.connectionProvider().acquire();
        try {
            connection.rollback();
        }
        finally {
            this.configuration.connectionProvider().release(connection);
        }
    }

    private <T> void addValue0(InsertQuery<R> insert, Field<T> field, Object row) {
        insert.addValue(field, field.getDataType().convert(row));
    }

    private <T> void addValueForUpdate0(InsertQuery<R> insert, Field<T> field, Object row) {
        insert.addValueForUpdate(field, field.getDataType().convert(row));
    }

    private <T> Condition getCondition(Field<T> field, Object string) {
        return field.equal(field.getDataType().convert(string));
    }

    @Override
    public final List<LoaderError> errors() {
        return this.errors;
    }

    @Override
    public final int processed() {
        return this.processed;
    }

    @Override
    public final int executed() {
        return this.executed;
    }

    @Override
    public final int ignored() {
        return this.ignored;
    }

    @Override
    public final int stored() {
        return this.stored;
    }

    @Override
    public final LoaderContext result() {
        return this.result;
    }

    static /* synthetic */ Field[] access$102(LoaderImpl x0, Field[] x1) {
        x0.source = x1;
        return x1;
    }

    private class DefaultLoaderContext
    implements LoaderContext {
        private DefaultLoaderContext() {
        }

        @Override
        public final List<LoaderError> errors() {
            return LoaderImpl.this.errors;
        }

        @Override
        public final int processed() {
            return LoaderImpl.this.processed;
        }

        @Override
        public final int executed() {
            return LoaderImpl.this.executed;
        }

        @Override
        public final int ignored() {
            return LoaderImpl.this.ignored;
        }

        @Override
        public final int stored() {
            return LoaderImpl.this.stored;
        }
    }
}

