/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.SQLDataType;

final class Limit
extends AbstractQueryPart {
    private static final long serialVersionUID = 2053741242981425602L;
    private static final Field<Integer> ZERO = DSL.zero();
    private static final Field<Integer> ONE = DSL.one();
    private static final Param<Integer> MAX = DSL.inline(Integer.MAX_VALUE);
    private Field<?> numberOfRows;
    private Field<?> numberOfRowsOrMax = MAX;
    private Field<?> offset;
    private Field<?> offsetOrZero = ZERO;
    private Field<?> offsetPlusOne = ONE;
    private boolean rendersParams;
    private boolean withTies;
    private boolean percent;

    Limit() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        ParamType paramType = ctx.paramType();
        RenderContext.CastMode castMode = ctx.castMode();
        switch (ctx.dialect()) {
            case CUBRID: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.offsetOrZero).sql(", ").visit(this.numberOfRowsOrMax).castMode(castMode);
                break;
            }
            case FIREBIRD: 
            case H2: 
            case DERBY: {
                if (ctx.family() == SQLDialect.H2 && !this.withTies() && !this.percent()) {
                    this.acceptDefault(ctx, castMode);
                    break;
                }
                this.acceptStandard(ctx, castMode);
                break;
            }
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.numberOfRowsOrMax);
                if (!this.offsetZero()) {
                    ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
                }
                ctx.castMode(castMode);
                break;
            }
            default: {
                this.acceptDefault(ctx, castMode);
            }
        }
    }

    private final void acceptStandard(Context<?> ctx, RenderContext.CastMode castMode) {
        ctx.castMode(RenderContext.CastMode.NEVER);
        if (!this.offsetZero()) {
            ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero).sql(' ').visit(Keywords.K_ROWS);
        }
        if (!this.limitZero()) {
            ctx.formatSeparator().visit(Keywords.K_FETCH_NEXT).sql(' ').visit(this.numberOfRows);
            if (this.percent) {
                ctx.sql(' ').visit(Keywords.K_PERCENT);
            }
            ctx.sql(' ').visit(this.withTies ? Keywords.K_ROWS_WITH_TIES : Keywords.K_ROWS_ONLY);
        }
        ctx.castMode(castMode);
    }

    private final void acceptDefault(Context<?> ctx, RenderContext.CastMode castMode) {
        ctx.castMode(RenderContext.CastMode.NEVER);
        if (!this.limitZero()) {
            ctx.formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.numberOfRows);
        }
        if (!this.offsetZero()) {
            ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
        }
        ctx.castMode(castMode);
    }

    final boolean limitZero() {
        return this.numberOfRows == null;
    }

    final boolean limitOne() {
        return !this.limitZero() && !this.withTies() && !this.percent() && this.numberOfRows instanceof Param && Long.valueOf(1L).equals(((Param)this.numberOfRows).getValue());
    }

    final boolean offsetZero() {
        return this.offset == null;
    }

    final Field<?> getLowerRownum() {
        return this.offsetOrZero;
    }

    final Field<?> getUpperRownum() {
        return this.offsetOrZero.add(this.numberOfRowsOrMax);
    }

    final boolean isApplicable() {
        return this.offset != null || this.numberOfRows != null;
    }

    final boolean rendersParams() {
        return this.rendersParams;
    }

    final void setOffset(Number offset) {
        if (offset.longValue() != 0L) {
            this.offset = DSL.val((Object)offset.longValue(), SQLDataType.BIGINT);
            this.offsetOrZero = this.offset;
            this.offsetPlusOne = DSL.val((Object)(offset.longValue() + 1L), SQLDataType.BIGINT);
        }
    }

    final void setOffset(Param<? extends Number> offset) {
        this.offset = offset;
        this.offsetOrZero = offset;
        this.rendersParams = this.rendersParams |= offset.isInline();
    }

    final void setNumberOfRows(Number numberOfRows) {
        this.numberOfRows = DSL.val((Object)numberOfRows.longValue(), SQLDataType.BIGINT);
        this.numberOfRowsOrMax = this.numberOfRows;
    }

    final void setNumberOfRows(Param<? extends Number> numberOfRows) {
        this.numberOfRows = numberOfRows;
        this.numberOfRowsOrMax = numberOfRows;
        this.rendersParams |= numberOfRows.isInline();
    }

    final void setPercent(boolean percent) {
        this.percent = percent;
    }

    final boolean percent() {
        return this.percent;
    }

    final void setWithTies(boolean withTies) {
        this.withTies = withTies;
    }

    final boolean withTies() {
        return this.withTies;
    }
}

