/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.RowN;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class InCondition<T>
extends AbstractCondition {
    private static final long serialVersionUID = -1653924248576930761L;
    private static final int IN_LIMIT = 1000;
    private static final Clause[] CLAUSES_IN = new Clause[]{Clause.CONDITION, Clause.CONDITION_IN};
    private static final Clause[] CLAUSES_IN_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_IN};
    private static final Set<SQLDialect> REQUIRES_IN_LIMIT = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_EMPTY_LISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private final Field<T> field;
    private final Field<?>[] values;
    private final Comparator comparator;

    InCondition(Field<T> field, Field<?>[] values, Comparator comparator) {
        this.field = field;
        this.values = values;
        this.comparator = comparator;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.comparator == Comparator.IN ? CLAUSES_IN : CLAUSES_IN_NOT;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (Tools.isEmbeddable(this.field)) {
            if (this.comparator == Comparator.IN) {
                ctx.visit(DSL.row(Tools.embeddedFields(this.field)).in(this.rows()));
            } else {
                ctx.visit(DSL.row(Tools.embeddedFields(this.field)).notIn(this.rows()));
            }
        } else {
            this.accept0(ctx);
        }
    }

    private final RowN[] rows() {
        RowN[] result = new RowN[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = DSL.row(Tools.embeddedFields(this.values[i]));
        }
        return result;
    }

    private final void accept0(Context<?> ctx) {
        List<Field<?>> list = Arrays.asList(this.values);
        if (list.size() == 0 && NO_SUPPORT_EMPTY_LISTS.contains((Object)ctx.family())) {
            if (this.comparator == Comparator.IN) {
                ctx.visit(DSL.falseCondition());
            } else {
                ctx.visit(DSL.trueCondition());
            }
        } else if (list.size() > 1000) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.sql('(').formatIndentStart().formatNewLine();
                    for (int i = 0; i < list.size(); i += 1000) {
                        if (i > 0) {
                            if (this.comparator == Comparator.IN) {
                                ctx.formatSeparator().visit(Keywords.K_OR).sql(' ');
                            } else {
                                ctx.formatSeparator().visit(Keywords.K_AND).sql(' ');
                            }
                        }
                        this.toSQLSubValues(ctx, InCondition.padded(ctx, list.subList(i, Math.min(i + 1000, list.size()))));
                    }
                    ctx.formatIndentEnd().formatNewLine().sql(')');
                    break;
                }
                default: {
                    this.toSQLSubValues(ctx, list);
                    break;
                }
            }
        } else {
            this.toSQLSubValues(ctx, InCondition.padded(ctx, list));
        }
    }

    static <T> List<T> padded(Context<?> ctx, List<T> list) {
        return ctx.paramType() == ParamType.INDEXED && Boolean.TRUE.equals(ctx.settings().isInListPadding()) ? new PaddedList(list, REQUIRES_IN_LIMIT.contains((Object)ctx.family()) ? 1000 : Integer.MAX_VALUE, StringUtils.defaultIfNull(ctx.settings().getInListPadBase(), 2)) : list;
    }

    private void toSQLSubValues(Context<?> ctx, List<Field<?>> subValues) {
        ctx.visit(this.field).sql(' ').visit(this.comparator.toKeyword()).sql(" (");
        if (subValues.size() > 1) {
            ctx.formatIndentStart().formatNewLine();
        }
        String separator = "";
        for (Field<?> value : subValues) {
            ctx.sql(separator).formatNewLineAfterPrintMargin().visit(value);
            separator = ", ";
        }
        if (subValues.size() > 1) {
            ctx.formatIndentEnd().formatNewLine();
        }
        ctx.sql(')');
    }

    static class PaddedList<T>
    extends AbstractList<T> {
        private final List<T> delegate;
        private final int realSize;
        private final int padSize;

        PaddedList(List<T> delegate, int maxPadding, int padBase) {
            int b = Math.max(2, padBase);
            this.delegate = delegate;
            this.realSize = delegate.size();
            this.padSize = Math.min(maxPadding, (int)Math.round(Math.pow(b, Math.ceil(Math.log(this.realSize) / Math.log(b)))));
        }

        @Override
        public T get(int index) {
            return index < this.realSize ? this.delegate.get(index) : this.delegate.get(this.realSize - 1);
        }

        @Override
        public int size() {
            return this.padSize;
        }
    }
}

