/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.DatePart;
import org.jooq.Field;
import org.jooq.Keyword;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;

final class DateAdd<T>
extends AbstractField<T> {
    private static final long serialVersionUID = -19593015886723235L;
    private final Field<T> date;
    private final Field<? extends Number> interval;
    private final DatePart datePart;

    DateAdd(Field<T> date, Field<? extends Number> interval, DatePart datePart) {
        super(Names.N_DATEADD, date.getDataType());
        this.date = date;
        this.interval = interval;
        this.datePart = datePart;
    }

    @Override
    public final void accept(Context<?> ctx) {
        Keyword keyword = null;
        String string = null;
        switch (ctx.family()) {
            case CUBRID: 
            case MARIADB: 
            case MYSQL: {
                switch (this.datePart) {
                    case YEAR: {
                        keyword = Keywords.K_YEAR;
                        break;
                    }
                    case MONTH: {
                        keyword = Keywords.K_MONTH;
                        break;
                    }
                    case DAY: {
                        keyword = Keywords.K_DAY;
                        break;
                    }
                    case HOUR: {
                        keyword = Keywords.K_HOUR;
                        break;
                    }
                    case MINUTE: {
                        keyword = Keywords.K_MINUTE;
                        break;
                    }
                    case SECOND: {
                        keyword = Keywords.K_SECOND;
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Keywords.F_DATE_ADD).sql('(').visit(this.date).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(this.interval).sql(' ').visit(keyword).sql(')');
                break;
            }
            case DERBY: 
            case HSQLDB: {
                switch (this.datePart) {
                    case YEAR: {
                        keyword = DSL.keyword("sql_tsi_year");
                        break;
                    }
                    case MONTH: {
                        keyword = DSL.keyword("sql_tsi_month");
                        break;
                    }
                    case DAY: {
                        keyword = DSL.keyword("sql_tsi_day");
                        break;
                    }
                    case HOUR: {
                        keyword = DSL.keyword("sql_tsi_hour");
                        break;
                    }
                    case MINUTE: {
                        keyword = DSL.keyword("sql_tsi_minute");
                        break;
                    }
                    case SECOND: {
                        keyword = DSL.keyword("sql_tsi_second");
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.sql("{fn ").visit(Keywords.F_TIMESTAMPADD).sql('(').visit(keyword).sql(", ").visit(this.interval).sql(", ").visit(this.date).sql(") }");
                break;
            }
            case FIREBIRD: {
                switch (this.datePart) {
                    case YEAR: {
                        keyword = Keywords.K_YEAR;
                        break;
                    }
                    case MONTH: {
                        keyword = Keywords.K_MONTH;
                        break;
                    }
                    case DAY: {
                        keyword = Keywords.K_DAY;
                        break;
                    }
                    case HOUR: {
                        keyword = Keywords.K_HOUR;
                        break;
                    }
                    case MINUTE: {
                        keyword = Keywords.K_MINUTE;
                        break;
                    }
                    case SECOND: {
                        keyword = Keywords.K_SECOND;
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Keywords.F_DATEADD).sql('(').visit(keyword).sql(", ").visit(this.interval).sql(", ").visit(this.date).sql(')');
                break;
            }
            case H2: {
                switch (this.datePart) {
                    case YEAR: {
                        string = "year";
                        break;
                    }
                    case MONTH: {
                        string = "month";
                        break;
                    }
                    case DAY: {
                        string = "day";
                        break;
                    }
                    case HOUR: {
                        string = "hour";
                        break;
                    }
                    case MINUTE: {
                        string = "minute";
                        break;
                    }
                    case SECOND: {
                        string = "second";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Keywords.F_DATEADD).sql('(').visit(DSL.inline(string)).sql(", ").visit(this.interval).sql(", ").visit(this.date).sql(')');
                break;
            }
            case POSTGRES: {
                switch (this.datePart) {
                    case YEAR: {
                        string = " year";
                        break;
                    }
                    case MONTH: {
                        string = " month";
                        break;
                    }
                    case DAY: {
                        string = " day";
                        break;
                    }
                    case HOUR: {
                        string = " hour";
                        break;
                    }
                    case MINUTE: {
                        string = " minute";
                        break;
                    }
                    case SECOND: {
                        string = " second";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                if (this.getDataType().isDate()) {
                    ctx.sql('(').visit(this.date).sql(" + (").visit(this.interval.concat(DSL.inline(string))).sql(")::interval)::date");
                    break;
                }
                ctx.sql('(').visit(this.date).sql(" + (").visit(this.interval.concat(DSL.inline(string))).sql(")::interval)");
                break;
            }
            case SQLITE: {
                switch (this.datePart) {
                    case YEAR: {
                        string = " year";
                        break;
                    }
                    case MONTH: {
                        string = " month";
                        break;
                    }
                    case DAY: {
                        string = " day";
                        break;
                    }
                    case HOUR: {
                        string = " hour";
                        break;
                    }
                    case MINUTE: {
                        string = " minute";
                        break;
                    }
                    case SECOND: {
                        string = " second";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Keywords.F_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.date).sql(", ").visit(this.interval.concat(DSL.inline(string))).sql(')');
            }
        }
    }

    private final void throwUnsupported() {
        throw new UnsupportedOperationException("Unknown date part : " + (Object)((Object)this.datePart));
    }
}

