/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractMeta;

final class CatalogMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = 7582210274970452691L;
    private final Catalog[] catalogs;

    CatalogMetaImpl(Configuration configuration, Catalog[] catalogs) {
        super(configuration);
        this.catalogs = catalogs;
    }

    @Override
    protected final List<Catalog> getCatalogs0() {
        return Arrays.asList(this.catalogs);
    }

    @Override
    protected final List<Schema> getSchemas0() {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Catalog catalog : this.catalogs) {
            result.addAll(catalog.getSchemas());
        }
        return result;
    }

    @Override
    protected final List<Table<?>> getTables0() {
        ArrayList result = new ArrayList();
        for (Catalog catalog : this.catalogs) {
            for (Schema schema : catalog.getSchemas()) {
                result.addAll(schema.getTables());
            }
        }
        return result;
    }

    @Override
    protected final List<Sequence<?>> getSequences0() {
        ArrayList result = new ArrayList();
        for (Catalog catalog : this.catalogs) {
            for (Schema schema : catalog.getSchemas()) {
                result.addAll(schema.getSequences());
            }
        }
        return result;
    }

    @Override
    protected final List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Catalog catalog : this.catalogs) {
            for (Schema schema : catalog.getSchemas()) {
                for (Table<?> table : schema.getTables()) {
                    if (table.getPrimaryKey() == null) continue;
                    result.add(table.getPrimaryKey());
                }
            }
        }
        return result;
    }
}

